/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import writer.DataWriter;

public class ExcelDataWriter
implements DataWriter {
    FileOutputStream fileOut;
    Workbook workbook;
    Sheet excelSheet;
    int currentCol = 0;
    int currentRow = 0;
    Row row = null;

    @Override
    public void create(File s, String name, boolean append) throws IOException {
        if (!append || !s.exists()) {
            this.fileOut = new FileOutputStream(s);
            this.workbook = new HSSFWorkbook();
        } else {
            FileInputStream inp = new FileInputStream(s);
            try {
                this.workbook = WorkbookFactory.create((InputStream)inp);
                ((InputStream)inp).close();
                this.fileOut = new FileOutputStream(s);
            }
            catch (InvalidFormatException ife) {
                System.out.println((Object)ife);
                ife.printStackTrace();
            }
        }
        this.excelSheet = this.workbook.createSheet(name);
    }

    @Override
    public void writeEntry(String s) throws IOException {
        if (this.row == null) {
            this.row = this.excelSheet.createRow(this.currentRow++);
            this.currentCol = 0;
        }
        Cell cell = this.row.createCell(this.currentCol++);
        cell.setCellValue(s);
    }

    @Override
    public void write(double s) throws IOException {
        if (this.row == null) {
            this.row = this.excelSheet.createRow(this.currentRow++);
            this.currentCol = 0;
        }
        Cell cell = this.row.createCell(this.currentCol++);
        cell.setCellValue(s);
    }

    @Override
    public void writeLine() {
        this.row = this.excelSheet.createRow(this.currentRow++);
        this.currentCol = 0;
    }

    public void write(Calendar s) throws IOException {
        if (this.row == null) {
            this.row = this.excelSheet.createRow(this.currentRow++);
            this.currentCol = 0;
        }
        Cell cell = this.row.createCell(this.currentCol++);
        cell.setCellValue(s);
        Cell cell1 = this.row.createCell(this.currentCol++);
        cell1.setCellValue((double)s.get(1));
        Cell cell2 = this.row.createCell(this.currentCol++);
        cell2.setCellValue((double)s.get(2));
        Cell cell3 = this.row.createCell(this.currentCol++);
        cell3.setCellValue((double)s.get(5));
    }

    @Override
    public void write(String s) throws IOException {
        String[] rows = null;
        rows = s.contains("\n") ? s.split("\n") : new String[]{s};
        for (String rowString : rows) {
            String[] cols;
            for (String col : cols = rowString.split("\t")) {
                if (this.row == null) {
                    this.row = this.excelSheet.createRow(this.currentRow++);
                    this.currentCol = 0;
                }
                Cell cell = this.row.createCell(this.currentCol++);
                cell.setCellValue(col);
            }
            if (rows.length <= 1) continue;
            this.row = this.excelSheet.createRow(this.currentRow++);
            this.currentCol = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.workbook.write((OutputStream)this.fileOut);
        this.fileOut.flush();
        this.fileOut.close();
    }
}

