/*
 * Decompiled with CFR 0.152.
 */
package netcdfTool2;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import netcdfTool2.ConverterTask;
import netcdfTool2.gis.ArbitraryRasterTransformer;
import netcdfTool2.gis.RasterTransformer;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import writer.DataWriter;
import writer.ExcelDataWriter;
import writer.StandardDataWriter;

public class NetCDFConverterTask
extends ConverterTask {
    final int latIndex = 0;
    final int lonIndex = 1;
    final int timeIndex = 2;
    Permutation p = null;
    double[][][] raster = null;
    Date[] timeArray;
    Dimension[] coordSystemDesc = null;
    Variable varMain = null;
    Variable varLat = null;
    Variable varLon = null;
    Variable varTime = null;
    int varLatIndex;
    int varLongIndex;
    int varTimeIndex;
    String varReLat = null;
    String varReLon = null;
    Array data = null;
    ArrayList<Variable> additionalDimensions;
    ArrayList<Variable> additionalIndicies;
    int fileCounter = 0;
    NetcdfFile ds;
    boolean is360dayyear = false;
    boolean working = false;

    public NetCDFConverterTask(NetcdfFile ds) {
        this.ds = ds;
        this.readMainDataSet();
    }

    public void setConversionDataset(Variable vMain) {
        this.varMain = vMain;
    }

    public void setTimeDataset(Variable varTime) {
        this.varTime = varTime;
    }

    public void setLatDataset(Variable varLat) {
        this.varLat = varLat;
    }

    public void setLonDataset(Variable varLon) {
        this.varLon = varLon;
    }

    public void setReLatDataset(String varReLat) {
        this.varReLat = varReLat;
    }

    public void setReLonDataset(String varReLon) {
        this.varReLon = varReLon;
    }

    public boolean readyToConvert() {
        if (this.working) {
            return false;
        }
        if (!this.readCoordinateSystem()) {
            return false;
        }
        if (this.varTime == null) {
            return false;
        }
        return this.varMain != null;
    }

    private Date[] read1DTimeArray(Array timeData, int[] shape) throws IOException {
        Date[] result = new Date[shape[0]];
        Date startDate = new Date();
        startDate.setTime(0L);
        if (this.options != null && this.varTime.findAttribute("calendar").getStringValue().equals("365_day")) {
            this.options.is365DayYear = true;
        }
        if (this.varTime.getUnitsString().contains("day as %Y%m%d.%f")) {
            for (int i = 0; i < shape[0]; ++i) {
                long number = (long)timeData.getDouble(i);
                double dnumber = timeData.getDouble(i);
                int day = (int)(number % 100L);
                int month = (int)((number /= 100L) % 100L);
                int year = (int)((number /= 100L) % 10000L);
                int secondsOfDay = (int)(86400.0 * (dnumber - Math.floor(dnumber)));
                int hour = secondsOfDay / 3600;
                int minute = (secondsOfDay %= 3600) / 60;
                int second = secondsOfDay %= 60;
                GregorianCalendar startCalendar = new GregorianCalendar();
                startCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                startCalendar.set(year, month - 1, day, hour, minute, second);
                result[i] = startCalendar.getTime();
            }
        } else if (this.varTime.getUnitsString().contains("since")) {
            String dateString = this.varTime.getUnitsString().split("since")[1];
            try {
                try {
                    startDate = this.format.parse(dateString);
                }
                catch (ParseException e) {
                    startDate = this.format2.parse(dateString);
                }
                if (this.varTime.getUnitsString().contains("seconds")) {
                    this.timeUnit = 13;
                } else if (this.varTime.getUnitsString().contains("minutes")) {
                    this.timeUnit = 12;
                } else if (this.varTime.getUnitsString().contains("hours")) {
                    this.timeUnit = 11;
                } else if (this.varTime.getUnitsString().contains("days")) {
                    this.timeUnit = 6;
                } else if (this.varTime.getUnitsString().contains("weeks")) {
                    this.timeUnit = 3;
                } else if (this.varTime.getUnitsString().contains("months")) {
                    this.timeUnit = 2;
                } else if (this.varTime.getUnitsString().contains("years")) {
                    this.timeUnit = 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = 0; i < shape[0]; ++i) {
                if (this.options != null && this.options.is360DayYear) {
                    result[i] = this.from360DayYear((long)timeData.getDouble(i), startDate).getTime();
                    continue;
                }
                if (this.options != null && this.options.is365DayYear) {
                    result[i] = this.from365DayYear((long)timeData.getDouble(i), startDate).getTime();
                    continue;
                }
                GregorianCalendar startCalendar = new GregorianCalendar();
                startCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                startCalendar.setTime(startDate);
                this.largeValueCalendarAdd(startCalendar, this.timeUnit, (long)timeData.getDouble(i));
                result[i] = startCalendar.getTime();
            }
        } else if (this.varTime.getUnitsString().contains("yyyymmddhh")) {
            for (int i = 0; i < shape[0]; ++i) {
                try {
                    result[i] = this.format4.parse(Integer.toString(timeData.getInt(i)));
                    continue;
                }
                catch (ParseException pe) {
                    pe.printStackTrace();
                }
            }
        } else {
            for (int i = 0; i < shape[0]; ++i) {
                GregorianCalendar startCalendar = new GregorianCalendar();
                startCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                startCalendar.setTime(startDate);
                this.largeValueCalendarAdd(startCalendar, this.timeUnit, (long)timeData.getDouble(i));
                result[i] = startCalendar.getTime();
            }
        }
        return result;
    }

    private Date[] read2DTimeArray(Array timeData, int[] shape) throws IOException {
        int timeIndex = shape[0] > shape[1] ? 0 : 1;
        Date[] result = new Date[shape[timeIndex]];
        for (int i = 0; i < shape[timeIndex]; ++i) {
            try {
                result[i] = this.format3.parse(timeData.slice(timeIndex, i).toString());
                continue;
            }
            catch (ParseException pe) {
                try {
                    result[i] = this.format.parse(timeData.slice(timeIndex, i).toString());
                    continue;
                }
                catch (ParseException pe2) {
                    try {
                        result[i] = this.format2.parse(timeData.slice(timeIndex, i).toString());
                        continue;
                    }
                    catch (ParseException pe3) {
                        this.setFailed("Could not parse date (YYYY-MM-dd_HH:mm:ss :" + timeData.slice(timeIndex, i).toString());
                        return null;
                    }
                }
            }
        }
        return result;
    }

    public Date[] readTimeArray() throws IOException {
        if (this.varTime == null) {
            return null;
        }
        Array timeData = this.varTime.read();
        int[] shape = timeData.getShape();
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.format2.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.format3.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.format4.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (shape.length == 1) {
            return this.read1DTimeArray(timeData, shape);
        }
        if (shape.length == 2) {
            return this.read2DTimeArray(timeData, shape);
        }
        return null;
    }

    public double[][][] readGrid(RasterTransformer transformer) throws IOException {
        if (this.varLon == null || this.varLat == null) {
            return null;
        }
        int[] lonShape = this.varLon.getShape();
        int[] latShape = this.varLat.getShape();
        if (latShape.length != lonShape.length) {
            this.setFailed("Lat/Lon Dataset is not compatible with each other");
            return null;
        }
        if (latShape.length == 1) {
            this.raster = new double[latShape[0]][lonShape[0]][2];
            Array latData = this.varLat.read();
            Array lonData = this.varLon.read();
            Index latIndex = latData.getIndex();
            Index lonIndex = lonData.getIndex();
            for (int j = 0; j < latShape[0]; ++j) {
                for (int k = 0; k < lonShape[0]; ++k) {
                    latIndex.set(j);
                    lonIndex.set(k);
                    this.raster[j][k][0] = lonData.getDouble(lonIndex);
                    this.raster[j][k][1] = latData.getDouble(latIndex);
                    this.raster[j][k] = transformer.transform(this.raster[j][k]);
                }
            }
        } else if (latShape.length == 2) {
            if (latShape[0] != lonShape[0] || latShape[1] != lonShape[1]) {
                this.setFailed("Lat/Lon Dataset is not compatible with each other");
                return null;
            }
            int[] shape = lonShape;
            this.raster = new double[shape[1]][shape[0]][2];
            Array latData = this.varLat.read();
            Array lonData = this.varLon.read();
            Index latIndex = latData.getIndex();
            Index lonIndex = lonData.getIndex();
            for (int j = 0; j < shape[0]; ++j) {
                for (int k = 0; k < shape[1]; ++k) {
                    latIndex.set(j, k);
                    lonIndex.set(j, k);
                    this.raster[k][j][0] = lonData.getDouble(lonIndex);
                    this.raster[k][j][1] = latData.getDouble(latIndex);
                    this.raster[k][j] = transformer.transform(this.raster[k][j]);
                }
            }
        } else if (latShape.length > 2) {
            this.setFailed("I have found a coordinate axis, with more than two dimension, what should I do now?");
            return null;
        }
        return this.raster;
    }

    private void saveSubsets(Array subset, Permutation p, String fileName, int expectedFileCount) {
        Permutation inv_p = p.invert();
        int[] shape = subset.getShape();
        if (shape.length > 3) {
            int lastDimension = inv_p.permute(shape.length - 1);
            int size = shape[lastDimension];
            for (int i = 0; i < size; ++i) {
                int splitIndex = fileName.lastIndexOf(46);
                String part1 = fileName.substring(0, splitIndex);
                String part2 = fileName.substring(splitIndex, fileName.length());
                part1 = part1 + "_" + this.coordSystemDesc[shape.length - 1].getName().replaceAll("[^a-zA-Z0-9]", "") + "=" + i + "_";
                Permutation p_reduced = p.removeIndex(lastDimension);
                if (size == 1) {
                    this.saveSubsets(subset.slice(lastDimension, i), p_reduced, fileName, expectedFileCount * size);
                    continue;
                }
                this.saveSubsets(subset.slice(lastDimension, i), p_reduced, part1 + part2, expectedFileCount * size);
            }
            return;
        }
        int T = this.timeArray.length;
        this.setProgress(0.0, "writing data");
        RasterTransformer transformer = null;
        if (this.options.transformationFile == null || !this.options.transformationFile.exists()) {
            if (this.options.transformer != null) {
                transformer = this.options.transformer;
            }
        } else {
            transformer = ArbitraryRasterTransformer.load(this.options.transformationFile);
            if (transformer == null) {
                JOptionPane.showMessageDialog(null, "Invalid transformation file: " + this.options.transformationFile);
            }
        }
        if (this.options.aggregationTime == 0) {
            long tDiff = this.timeArray[1].getTime() - this.timeArray[0].getTime();
            if (tDiff > 2678400000L) {
                this.options.aggregationTime = 5;
            } else if (tDiff > 86400000L) {
                this.options.aggregationTime = 4;
            } else if (tDiff > 3600000L) {
                this.options.aggregationTime = 2;
            } else if (tDiff > 0L) {
                this.options.aggregationTime = 1;
            }
            if (this.options.aggregationTime == 1) {
                System.out.println("Recognized timestep is hourly");
            }
            if (this.options.aggregationTime == 2) {
                System.out.println("Recognized timestep is daily");
            }
            if (this.options.aggregationTime == 4) {
                System.out.println("Recognized timestep is monthly");
            }
            if (this.options.aggregationTime == 5) {
                System.out.println("Recognized timestep is yearly");
            }
        }
        String header = transformer != null ? this.buildHeader(this.makeGrid(transformer), this.timeArray[0], this.timeArray[this.timeArray.length - 1], this.options.cells, this.options.aggregationTime, this.varMain, this.options.unitConvMode, this.options.fileNames) : this.buildHeader(this.raster, this.timeArray[0], this.timeArray[this.timeArray.length - 1], this.options.cells, this.options.aggregationTime, this.varMain, this.options.unitConvMode, this.options.fileNames);
        Index iterator = subset.getIndex();
        int[] indexArray = new int[3];
        try {
            int i;
            DataWriter writer = new StandardDataWriter();
            if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
                writer = new ExcelDataWriter();
            }
            writer.create(new File(fileName), this.options.datasetName, this.options.appendMode);
            ++this.fileCounter;
            if (!this.options.appendMode || writer instanceof ExcelDataWriter) {
                writer.write(header);
            }
            double[] aggregatedData = new double[this.options.cells.length];
            double[] lastAggregatedData = new double[this.options.cells.length];
            GregorianCalendar calendar = new GregorianCalendar();
            GregorianCalendar aggregationCalendar = new GregorianCalendar();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            aggregationCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            aggregationCalendar.setTime(this.timeArray[0]);
            this.roundCalendar(aggregationCalendar, this.options.aggregationTime);
            SimpleDateFormat aggregation_format = this.getRoundedFormat(this.options.aggregationTime);
            boolean calcSum = this.options.aggregationMode == 0;
            boolean calcAvg = this.options.aggregationMode == 1;
            boolean calcMin = this.options.aggregationMode == 2;
            boolean calcMax = this.options.aggregationMode == 3;
            boolean convNone = this.options.unitConvMode == 0;
            boolean convSecTU = this.options.unitConvMode == 1;
            boolean convSecHrs = this.options.unitConvMode == 3;
            boolean convKDeg = this.options.unitConvMode == 2;
            int aggregatedSteps = 0;
            for (i = 0; i < this.options.cells.length; ++i) {
                if (calcMin) {
                    aggregatedData[i] = Double.POSITIVE_INFINITY;
                }
                if (!calcMax) continue;
                aggregatedData[i] = Double.NEGATIVE_INFINITY;
            }
            if (T == 1) {
                for (i = 0; i < this.options.cells.length; ++i) {
                    double value;
                    if (this.options.xySwitch) {
                        indexArray[inv_p.permute((int)1)] = this.options.cells[i].y;
                        indexArray[inv_p.permute((int)0)] = this.options.cells[i].x;
                    } else {
                        indexArray[inv_p.permute((int)1)] = this.options.cells[i].x;
                        indexArray[inv_p.permute((int)0)] = this.options.cells[i].y;
                    }
                    indexArray[inv_p.permute((int)2)] = 0;
                    iterator.set(indexArray);
                    aggregatedData[i] = value = subset.getDouble(iterator);
                }
                aggregatedSteps = 1;
            }
            boolean additionalStep = false;
            for (int k = 0; k <= T; ++k) {
                int i2;
                if (k < T) {
                    calendar.setTime(this.timeArray[k]);
                }
                this.roundCalendar(calendar, this.options.aggregationTime);
                while (calendar.after(aggregationCalendar) || k == T) {
                    writer.writeLine();
                    if (writer instanceof StandardDataWriter) {
                        writer.write(aggregation_format.format(aggregationCalendar.getTime()));
                    } else if (writer instanceof ExcelDataWriter) {
                        ((ExcelDataWriter)writer).write(aggregationCalendar);
                    }
                    if (aggregatedSteps > 0) {
                        for (i2 = 0; i2 < this.options.cells.length; ++i2) {
                            if (calcAvg) {
                                int n = i2;
                                aggregatedData[n] = aggregatedData[n] / (double)aggregatedSteps;
                            }
                            if (convKDeg) {
                                int n = i2;
                                aggregatedData[n] = aggregatedData[n] - 273.15;
                            }
                            if (convSecHrs) {
                                int n = i2;
                                aggregatedData[n] = aggregatedData[n] / 3600.0;
                            }
                            if (convSecTU) {
                                long secondsInTimeunit = 1L;
                                switch (this.options.aggregationTime) {
                                    case 1: {
                                        secondsInTimeunit = 3600L;
                                        break;
                                    }
                                    case 2: {
                                        secondsInTimeunit = 86400L;
                                        break;
                                    }
                                    case 4: {
                                        secondsInTimeunit = 86400 * aggregationCalendar.getActualMaximum(5);
                                        break;
                                    }
                                    case 5: {
                                        secondsInTimeunit = 86400 * aggregationCalendar.getActualMaximum(6);
                                    }
                                }
                                int n = i2;
                                aggregatedData[n] = aggregatedData[n] * (double)secondsInTimeunit;
                            }
                            writer.write(String.format("%.1f", aggregatedData[i2]));
                            lastAggregatedData[i2] = aggregatedData[i2];
                            aggregatedData[i2] = 0.0;
                            if (calcMin) {
                                aggregatedData[i2] = Double.POSITIVE_INFINITY;
                            }
                            if (!calcMax) continue;
                            aggregatedData[i2] = Double.NEGATIVE_INFINITY;
                        }
                    } else {
                        for (i2 = 0; i2 < this.options.cells.length; ++i2) {
                            writer.write(String.format("%.1f", aggregatedData[i2]));
                        }
                    }
                    aggregatedSteps = 0;
                    if (this.options.aggregationTime == 2) {
                        aggregationCalendar.add(6, 1);
                    } else if (this.options.aggregationTime == 4) {
                        aggregationCalendar.add(2, 1);
                    } else if (this.options.aggregationTime == 3) {
                        aggregationCalendar.add(3, 1);
                    } else if (this.options.aggregationTime == 5) {
                        aggregationCalendar.add(1, 1);
                    } else if (this.options.aggregationTime == 1) {
                        aggregationCalendar.add(10, 1);
                    }
                    this.roundCalendar(aggregationCalendar, this.options.aggregationTime);
                    if (k != T) continue;
                    if (!this.options.is360DayYear || additionalStep) break;
                    additionalStep = true;
                }
                this.setProgress((int)(1000.0 * (double)this.fileCounter * (double)k / (double)(T * expectedFileCount)), null);
                for (i2 = 0; i2 < this.options.cells.length && k < T; ++i2) {
                    if (this.options.xySwitch) {
                        indexArray[inv_p.permute((int)1)] = this.options.cells[i2].y;
                        indexArray[inv_p.permute((int)0)] = this.options.cells[i2].x;
                    } else {
                        indexArray[inv_p.permute((int)1)] = this.options.cells[i2].x;
                        indexArray[inv_p.permute((int)0)] = this.options.cells[i2].y;
                    }
                    indexArray[inv_p.permute((int)2)] = k;
                    iterator.set(indexArray);
                    double value = subset.getDouble(iterator);
                    if (calcSum || calcAvg) {
                        int n = i2;
                        aggregatedData[n] = aggregatedData[n] + value;
                    }
                    if (calcMin) {
                        aggregatedData[i2] = Math.min(aggregatedData[i2], value);
                    }
                    if (!calcMax) continue;
                    aggregatedData[i2] = Math.max(aggregatedData[i2], value);
                }
                aggregatedSteps = (int)((double)aggregatedSteps + 1.0);
            }
            writer.close();
        }
        catch (Exception e) {
            this.setFailed("While I was reading the J2K data file an error occured! " + e.toString());
            e.printStackTrace();
        }
        this.setProgress(1000.0, "finished!");
    }

    private boolean readMainDataSet() {
        if (this.varMain == null) {
            this.setFailed("main data set was not provided. operation stopped");
            return false;
        }
        try {
            this.varMain.createNewCache();
            this.data = this.varMain.read();
        }
        catch (Exception e) {
            this.setFailed("Can't read main data set. operation stopped, because:" + e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean readCoordinateSystem() {
        if (this.varLat == null || this.varLon == null || this.varTime == null || this.varMain == null) {
            if (this.varLat == null) {
                this.setFailed("I didn't found any latitude data set, that's why I stopped this operation");
            } else if (this.varLon == null) {
                this.setFailed("I didn't found any longitude data set, that's why I stopped this operation");
            } else {
                this.setFailed("I didn't found any time data set, that's why I stopped this operation");
            }
            return false;
        }
        List dimList = this.varMain.getDimensions();
        Iterator dimIter = dimList.iterator();
        this.coordSystemDesc = new Dimension[dimList.size()];
        this.p = new Permutation(dimList.size());
        int freeIndex = 3;
        int currentIndex = 0;
        while (dimIter.hasNext()) {
            Dimension dim = (Dimension)dimIter.next();
            Variable v = this.ds.findVariable(dim.getName());
            try {
                int index = this.varMain.findDimensionIndex(dim.getName());
                if (dim.getName().equals(this.varLat.getShortName())) {
                    this.p.set(index, 0);
                } else if (this.varReLat != null && dim.getName().equals(this.varReLat)) {
                    this.p.set(index, 0);
                } else if (dim.getName().equals(this.varLon.getShortName())) {
                    this.p.set(index, 1);
                } else if (this.varReLon != null && dim.getName().equals(this.varReLon)) {
                    this.p.set(index, 1);
                } else if (dim.getName().equals(this.varTime.getShortName())) {
                    this.p.set(index, 2);
                } else {
                    this.p.set(index, freeIndex);
                    ++freeIndex;
                }
            }
            catch (Exception e) {
                this.setFailed("Can't read dimension data set. operation stopped, because:" + e.toString());
                e.printStackTrace();
                return false;
            }
            this.coordSystemDesc[currentIndex++] = dim;
        }
        this.latDesc = this.varLat.getShortName() + ":" + this.varLat.getDescription();
        this.lonDesc = this.varLon.getShortName() + ":" + this.varLon.getDescription();
        this.timeDesc = this.varTime.getShortName() + ":" + this.varTime.getDescription();
        try {
            this.timeArray = this.readTimeArray();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "An io-error occured during reading the netcdf dataset " + ioe);
            return false;
        }
        this.coordSystemDesc = (Dimension[])this.p.permute(this.coordSystemDesc);
        try {
            this.raster = this.readGrid(new ArbitraryRasterTransformer(0, 1));
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "An io-error occured during reading the netcdf dataset " + ioe);
            return false;
        }
        return true;
    }

    @Override
    public double[][][] makeGrid(RasterTransformer transformer) {
        try {
            this.raster = this.readGrid(transformer);
            return this.raster;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "An io-error occured during reading the netcdf dataset " + ioe);
            return null;
        }
    }

    @Override
    public void setOptions(ConverterTask.ConvertingOptions options) {
        this.options = options;
    }

    @Override
    public void execute() {
        try {
            this.working = true;
            if (!this.readCoordinateSystem()) {
                this.working = false;
                return;
            }
            if (this.options.outputFile == null) {
                this.working = false;
                JOptionPane.showMessageDialog(null, "Select an output file!");
                return;
            }
            this.data = this.varMain.read();
            this.saveSubsets(this.data, this.p, this.options.outputFile.getAbsolutePath(), 1);
            this.writeSelectedPolys(this.options);
            this.data = null;
            System.gc();
            return;
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, "An error occured, because:" + t.toString());
            t.printStackTrace();
            return;
        }
        finally {
            this.working = false;
        }
    }

    public class Permutation {
        private int[] permutation;

        public Permutation() {
        }

        public Permutation(int n) {
            this.permutation = new int[n];
            for (int i = 0; i < n; ++i) {
                this.permutation[i] = i;
            }
        }

        public Permutation(int[] permutation) {
            this.permutation = (int[])permutation.clone();
        }

        public void set(int i, int j) {
            this.permutation[i] = j;
        }

        public Object[] permute(Object[] array) {
            if (this.permutation.length != array.length) {
                return null;
            }
            Object[] permutedArray = (Object[])array.clone();
            for (int i = 0; i < this.permutation.length; ++i) {
                permutedArray[this.permutation[i]] = array[i];
            }
            return permutedArray;
        }

        public Permutation invert() {
            int[] inv = new int[this.permutation.length];
            block0: for (int i = 0; i < inv.length; ++i) {
                for (int j = 0; j < inv.length; ++j) {
                    if (this.permutation[j] != i) continue;
                    inv[i] = j;
                    continue block0;
                }
            }
            return new Permutation(inv);
        }

        public Permutation removeIndex(int index) {
            int[] new_permutation = new int[this.permutation.length - 1];
            int offset = 0;
            for (int i = 0; i < new_permutation.length; ++i) {
                if (i == index) {
                    offset = 1;
                }
                if (this.permutation[i + offset] < this.permutation[index]) {
                    new_permutation[i] = this.permutation[i + offset];
                }
                if (this.permutation[i + offset] <= this.permutation[index]) continue;
                new_permutation[i] = this.permutation[i + offset] - 1;
            }
            return new Permutation(new_permutation);
        }

        public int permute(int i) {
            if (i < 0 || i > this.permutation.length) {
                return -1;
            }
            return this.permutation[i];
        }
    }
}

