/*
 * Decompiled with CFR 0.152.
 */
package netcdfTool2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import netcdfTool2.ConverterTask;
import netcdfTool2.DatasetController;
import netcdfTool2.gis.ArbitraryRasterTransformer;
import netcdfTool2.gis.RasterTransformer;
import netcdfTool2.gis.ShapeFileViewer;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class DatasetViewer
extends JPanel {
    static final String VERSION_STRING = "2.1";
    private DatasetController controller = null;
    private JProgressBar bar;
    private JButton loadShapeFileButton = new JButton("Load ShapeFile");
    private JButton exportSelectedCellsButton = new JButton("Export Cells");
    private JButton importSelectedCellsButton = new JButton("Import Cells");
    private JButton startButton = new JButton("Start Extraction");
    private JCheckBox xySwitchBox = new JCheckBox("Switch rows & columns", null);
    private JComboBox transformers = new JComboBox();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton rb_sum = new JRadioButton("sum", false);
    private JRadioButton rb_avg = new JRadioButton("average", true);
    private JRadioButton rb_min = new JRadioButton("min", false);
    private JRadioButton rb_max = new JRadioButton("max", false);
    private ButtonGroup cbuttonGroup = new ButtonGroup();
    private JRadioButton c_none = new JRadioButton("none", true);
    private JRadioButton c_precip = new JRadioButton("*/s->*/tunit", false);
    private JRadioButton c_temp = new JRadioButton("K->\u00b0C", false);
    private JRadioButton c_sunh = new JRadioButton("s->h", false);
    private ShapeFileViewer gisPanel;
    private JComboBox dstCRS = new JComboBox();
    private JComboBox srcCRS = new JComboBox();
    private JComboBox aggregationMode = new JComboBox();
    private JFrame fileInputFrame = new JFrame();
    private JList recentFileList = new JList();
    private JTextField tmeanInputFileName = new JTextField("", 30);
    private JTextField tminInputFileName = new JTextField("", 30);
    private JTextField tmaxInputFileName = new JTextField("", 30);
    private JTextField precipInputFileName = new JTextField("", 30);
    private JTextField outputFileName = new JTextField("", 30);
    private JButton inputFileChooseBn = new JButton("Choose");
    private JButton outputFileChooseBn = new JButton("Choose");
    private JLabel convLabel = new JLabel("main variable: ");
    private JLabel lonLabel = new JLabel("x/lon variable: ");
    private JLabel latLabel = new JLabel("y/lat variable: ");
    private JLabel remapLonLabel = new JLabel("x/lon dimension: ");
    private JLabel remapLatLabel = new JLabel("y/lat dimension: ");
    private JLabel timeLabel = new JLabel("time dimension: ");
    private JComboBox convVariable = new JComboBox();
    private JComboBox latVariable = new JComboBox();
    private JComboBox lonVariable = new JComboBox();
    private JComboBox reLatVariable = new JComboBox();
    private JComboBox reLonVariable = new JComboBox();
    private JComboBox timeVariable = new JComboBox();
    private String[] timeSteps = new String[]{"millisecond", "second", "minute", "hour", "day", "month", "year"};
    private JComboBox timeStepFormat = new JComboBox<String>(this.timeSteps);
    private String[] netcdfAttr = new String[]{"dataType", "description", "dimensions", "name", "shape", "units"};
    private String[][] netcdfAttrData = new String[0][];
    private String[] fileTyps = new String[]{"netcdf"};
    private JComboBox supportedFileTyps = new JComboBox<String>(this.fileTyps);
    private final JTable netcdfVarTable = new JTable(this.netcdfAttrData, this.netcdfAttr);
    private JCheckBox is360DayYear = new JCheckBox("360 days per year", false);
    private JCheckBox is365DayYear = new JCheckBox("365 days per year", false);
    private JFileChooser chooser = new JFileChooser();
    private JFileChooser fc_output = new JFileChooser();
    private JFileChooser fc_shape = new JFileChooser();
    private File workspace;
    private Properties props;

    public DatasetViewer() {
        this.transformers.addItem(new ArbitraryRasterTransformer(0, 1));
        this.transformers.addItem(new ArbitraryRasterTransformer(0, 1, true));
        File transformerDirectory = new File("resources/transformer/");
        if (transformerDirectory == null || transformerDirectory.listFiles() == null) {
            JOptionPane.showMessageDialog(null, "Error resources are missing!");
        } else {
            for (File file : transformerDirectory.listFiles()) {
                ArbitraryRasterTransformer transformer = ArbitraryRasterTransformer.load(file);
                if (transformer == null) continue;
                this.transformers.addItem(transformer);
            }
        }
        this.controller = new DatasetController(this);
    }

    public void initGUI(List<Image> icons, Properties props) {
        this.props = props;
        JLabel tmeanInputFileLabel = new JLabel("Input file:");
        JLabel tmaxInputFileLabel = new JLabel("Max temperature input:");
        JLabel tminInputFileLabel = new JLabel("Min temperature input:");
        JLabel precipInputFileLabel = new JLabel("Precipitation input:");
        JLabel fileTypeLabel = new JLabel("type: ");
        this.tmeanInputFileName.setEnabled(false);
        this.outputFileName.setEnabled(false);
        this.supportedFileTyps.setEnabled(false);
        JPanel filePanel = new JPanel();
        GroupLayout filePanelLayout = new GroupLayout(filePanel);
        filePanel.setLayout(filePanelLayout);
        filePanel.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "Files"));
        filePanelLayout.setAutoCreateGaps(true);
        filePanelLayout.setHorizontalGroup(filePanelLayout.createParallelGroup().addGroup(filePanelLayout.createSequentialGroup().addComponent(tmeanInputFileLabel).addComponent(this.tmeanInputFileName).addComponent(this.inputFileChooseBn)));
        filePanelLayout.setVerticalGroup(filePanelLayout.createSequentialGroup().addGroup(filePanelLayout.createParallelGroup().addComponent(tmeanInputFileLabel).addComponent(this.tmeanInputFileName).addComponent(this.inputFileChooseBn)));
        tmeanInputFileLabel.setMinimumSize(new Dimension(100, tmeanInputFileLabel.getSize().height));
        JScrollPane netcdfVarTableScrollPane = new JScrollPane(this.netcdfVarTable);
        netcdfVarTableScrollPane.setMinimumSize(new Dimension(800, 100));
        this.netcdfVarTable.setFillsViewportHeight(true);
        JPanel netcdfPanel = new JPanel();
        netcdfPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Variables"));
        GroupLayout netcdfPanelLayout = new GroupLayout(netcdfPanel);
        netcdfPanel.setLayout(netcdfPanelLayout);
        netcdfPanelLayout.setAutoCreateGaps(true);
        netcdfPanelLayout.setHorizontalGroup(netcdfPanelLayout.createParallelGroup().addGroup(netcdfPanelLayout.createSequentialGroup().addComponent(this.convLabel).addComponent(this.convVariable).addGap(5).addGroup(netcdfPanelLayout.createParallelGroup().addGroup(netcdfPanelLayout.createSequentialGroup().addComponent(this.lonLabel).addComponent(this.lonVariable)).addGroup(netcdfPanelLayout.createSequentialGroup().addComponent(this.remapLonLabel).addComponent(this.reLonVariable))).addGap(5).addGroup(netcdfPanelLayout.createParallelGroup().addGroup(netcdfPanelLayout.createSequentialGroup().addComponent(this.latLabel).addComponent(this.latVariable)).addGroup(netcdfPanelLayout.createSequentialGroup().addComponent(this.remapLatLabel).addComponent(this.reLatVariable))).addGap(5).addComponent(this.timeLabel).addComponent(this.timeVariable)).addGroup(netcdfPanelLayout.createSequentialGroup().addComponent(netcdfVarTableScrollPane)));
        netcdfPanelLayout.setVerticalGroup(netcdfPanelLayout.createSequentialGroup().addGroup(netcdfPanelLayout.createParallelGroup().addComponent(this.convLabel).addComponent(this.convVariable).addGap(5).addGroup(netcdfPanelLayout.createSequentialGroup().addGroup(netcdfPanelLayout.createParallelGroup().addComponent(this.lonLabel).addComponent(this.lonVariable)).addGroup(netcdfPanelLayout.createParallelGroup().addComponent(this.remapLonLabel).addComponent(this.reLonVariable))).addGap(5).addGroup(netcdfPanelLayout.createSequentialGroup().addGroup(netcdfPanelLayout.createParallelGroup().addComponent(this.latLabel).addComponent(this.latVariable)).addGroup(netcdfPanelLayout.createParallelGroup().addComponent(this.remapLatLabel).addComponent(this.reLatVariable))).addGap(5).addComponent(this.timeLabel).addComponent(this.timeVariable)).addGroup(netcdfPanelLayout.createParallelGroup().addComponent(netcdfVarTableScrollPane)));
        this.aggregationMode = new JComboBox<String>(new String[]{"original timesteps", "hourly", "daily", "weekly", "monthly", "yearly"});
        this.buttonGroup.add(this.rb_sum);
        this.buttonGroup.add(this.rb_avg);
        this.buttonGroup.add(this.rb_min);
        this.buttonGroup.add(this.rb_max);
        JPanel aggrPanel = new JPanel();
        aggrPanel.add(this.rb_sum);
        aggrPanel.add(this.rb_avg);
        aggrPanel.add(this.rb_min);
        aggrPanel.add(this.rb_max);
        this.cbuttonGroup.add(this.c_none);
        this.cbuttonGroup.add(this.c_precip);
        this.cbuttonGroup.add(this.c_sunh);
        this.cbuttonGroup.add(this.c_temp);
        JPanel convPanel = new JPanel();
        convPanel.add(this.c_none);
        convPanel.add(this.c_precip);
        convPanel.add(this.c_sunh);
        convPanel.add(this.c_temp);
        JPanel aggregationPanel = new JPanel();
        GroupLayout aggregrationPanelLayout = new GroupLayout(aggregationPanel);
        aggregationPanel.setLayout(aggregrationPanelLayout);
        aggregationPanel.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "aggregation mode"));
        aggregrationPanelLayout.setAutoCreateGaps(true);
        aggregrationPanelLayout.setHorizontalGroup(aggregrationPanelLayout.createSequentialGroup().addComponent(this.aggregationMode).addGroup(aggregrationPanelLayout.createParallelGroup().addComponent(aggrPanel).addComponent(convPanel)).addGap(50).addGroup(aggregrationPanelLayout.createParallelGroup().addComponent(this.is360DayYear).addComponent(this.is365DayYear)));
        aggregrationPanelLayout.setVerticalGroup(aggregrationPanelLayout.createParallelGroup().addComponent(this.aggregationMode).addGroup(aggregrationPanelLayout.createSequentialGroup().addComponent(aggrPanel).addComponent(convPanel)).addGroup(aggregrationPanelLayout.createSequentialGroup().addComponent(this.is360DayYear).addComponent(this.is365DayYear)));
        JPanel coordinatePanel = new JPanel();
        GroupLayout coordinatePanelLayout = new GroupLayout(coordinatePanel);
        coordinatePanelLayout.setAutoCreateGaps(true);
        coordinatePanel.setLayout(coordinatePanelLayout);
        coordinatePanel.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "target coordinates"));
        Set codeSet = CRS.getSupportedCodes((String)"EPSG");
        this.srcCRS = new JComboBox();
        this.dstCRS = new JComboBox();
        this.srcCRS.addItem("WGS 84");
        this.srcCRS.addItem("UTM - Zone 23S (Dois Rios)");
        this.srcCRS.addItem("UTM - Zone 33N (Danube)");
        this.srcCRS.addItem("UTM - Zone 46N (Nam Co)");
        this.srcCRS.addItem("UTM - Zone 47N (Brahmaputra)");
        this.dstCRS.addItem("WGS 84");
        this.dstCRS.addItem("UTM - Zone 23S (Dois Rios)");
        this.dstCRS.addItem("UTM - Zone 33N (Danube)");
        this.dstCRS.addItem("UTM - Zone 46N (Nam Co)");
        this.dstCRS.addItem("UTM - Zone 47N (Brahmaputra)");
        for (String code : codeSet) {
            this.srcCRS.addItem(code);
            this.dstCRS.addItem(code);
        }
        this.srcCRS.setSelectedIndex(0);
        this.dstCRS.setSelectedIndex(0);
        this.srcCRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.controller.updateDataset();
            }
        });
        this.dstCRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.controller.updateDataset();
            }
        });
        JLabel sourceLabel = new JLabel("source CRS");
        JLabel targetLabel = new JLabel("target CRS");
        coordinatePanelLayout.setHorizontalGroup(coordinatePanelLayout.createSequentialGroup().addGroup(coordinatePanelLayout.createParallelGroup().addGroup(coordinatePanelLayout.createSequentialGroup().addComponent(sourceLabel).addComponent(this.srcCRS)).addGroup(coordinatePanelLayout.createSequentialGroup().addComponent(targetLabel).addComponent(this.dstCRS))).addComponent(this.transformers));
        coordinatePanelLayout.setVerticalGroup(coordinatePanelLayout.createParallelGroup().addGroup(coordinatePanelLayout.createSequentialGroup().addGroup(coordinatePanelLayout.createParallelGroup().addComponent(sourceLabel).addComponent(this.srcCRS)).addGroup(coordinatePanelLayout.createParallelGroup().addComponent(targetLabel).addComponent(this.dstCRS))).addComponent(this.transformers));
        JPanel panelNetCDFFileViewer = this.getConverterPanel();
        panelNetCDFFileViewer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Cells"));
        panelNetCDFFileViewer.validate();
        JPanel mainPanel = new JPanel();
        GroupLayout mainPanelLayout = new GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setAutoCreateGaps(true);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup().addGroup(mainPanelLayout.createSequentialGroup().addComponent(filePanel)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(netcdfPanel)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(panelNetCDFFileViewer)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup().addComponent(filePanel)).addGroup(mainPanelLayout.createParallelGroup().addComponent(netcdfPanel)).addGroup(mainPanelLayout.createParallelGroup().addComponent(panelNetCDFFileViewer)));
        JScrollPane scrollPane = new JScrollPane(mainPanel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        mainPanel.setPreferredSize(new Dimension(800, 750));
        this.fileInputFrame.setLayout(new BorderLayout());
        this.fileInputFrame.add((Component)scrollPane, "Center");
        this.fileInputFrame.setSize(new Dimension(1000, 800));
        this.fileInputFrame.invalidate();
        this.fileInputFrame.doLayout();
        this.fileInputFrame.setDefaultCloseOperation(1);
        this.fileInputFrame.setIconImages(icons);
        this.fileInputFrame.setTitle("CDITool: Data Extraction");
        this.updateStartButtonState();
        this.initGUIMethods();
    }

    public String getShapeFileName() {
        return new File(this.workspace, "input/local/gis/grids.shp").getAbsolutePath();
    }

    public void setWorkspace(File workspace) {
        this.workspace = workspace;
    }

    public void setOutput(File output) {
        this.controller.setOutputFile(output);
    }

    public void setFrameVisible(boolean visible) {
        this.fileInputFrame.setVisible(visible);
    }

    public void show(File workspace, File output, int unitConv) {
        this.bar.setString("0%");
        this.bar.setValue(0);
        this.workspace = workspace;
        if (unitConv == 0) {
            this.c_precip.setSelected(true);
        } else if (unitConv == 1) {
            this.c_temp.setSelected(true);
        }
        this.controller.setOutputFile(output);
        this.fileInputFrame.setVisible(true);
    }

    public void setRecentFileList(DefaultListModel model) {
        this.recentFileList.setModel(model);
    }

    public void setShapeFile(File shapeFile) {
        this.gisPanel.setShapeFile(shapeFile.getAbsolutePath());
    }

    private boolean updateStartButtonState() {
        boolean state = this.controller.readyToConvert();
        this.startButton.setEnabled(state);
        this.importSelectedCellsButton.setEnabled(state);
        this.exportSelectedCellsButton.setEnabled(state);
        return state;
    }

    public int getAggregationMode() {
        if (this.rb_sum.isSelected()) {
            return 0;
        }
        if (this.rb_avg.isSelected()) {
            return 1;
        }
        if (this.rb_min.isSelected()) {
            return 2;
        }
        if (this.rb_max.isSelected()) {
            return 3;
        }
        return -1;
    }

    public int getUnitConvMode() {
        if (this.c_none.isSelected()) {
            return 0;
        }
        if (this.c_precip.isSelected()) {
            return 1;
        }
        if (this.c_sunh.isSelected()) {
            return 3;
        }
        if (this.c_temp.isSelected()) {
            return 2;
        }
        return -1;
    }

    public int getAggregationTimePeriod() {
        return this.aggregationMode.getSelectedIndex();
    }

    public Point[] getSelectedCells() {
        return this.gisPanel.getSelectedCells();
    }

    public FeatureCollection getSelectedFeatures() {
        return this.gisPanel.getSelectedFeatures();
    }

    public String getDstProjectionName() {
        return this.resolveCRSName(this.dstCRS.getSelectedIndex());
    }

    public String getSrcProjectionName() {
        return this.resolveCRSName(this.srcCRS.getSelectedIndex());
    }

    public boolean is360DayYearSelected() {
        return this.is360DayYear.isSelected();
    }

    public boolean is365DayYearSelected() {
        return this.is365DayYear.isSelected();
    }

    public void setNetCDFVarTableModel(TableModel model) {
        this.netcdfVarTable.setModel(model);
    }

    public void setConversionVariables(ComboBoxModel model) {
        this.convVariable.setModel(model);
    }

    public Object getSelectedConversionVariable() {
        return this.convVariable.getModel().getSelectedItem();
    }

    public void setLatDimensionVariables(ComboBoxModel model) {
        this.latVariable.setModel(model);
    }

    public Object getSelectedLatVariable() {
        return this.latVariable.getSelectedItem();
    }

    public void setLonDimensionVariables(ComboBoxModel model) {
        this.lonVariable.setModel(model);
    }

    public Object getSelectedLonVariable() {
        return this.lonVariable.getSelectedItem();
    }

    public void setTimeDimensionVariables(ComboBoxModel model) {
        this.timeVariable.setModel(model);
    }

    public Object getSelectedTimeVariable() {
        return this.timeVariable.getSelectedItem();
    }

    public void setReLatDimensionVariables(ComboBoxModel model) {
        this.reLatVariable.setModel(model);
    }

    public Object getSelectedReLatVariable() {
        return this.reLatVariable.getModel().getSelectedItem();
    }

    public Object getSelectedReLonVariable() {
        return this.reLonVariable.getModel().getSelectedItem();
    }

    public void setRaster(double[][][] grid) {
        this.gisPanel.addRaster(grid, this.resolveCRSName(this.srcCRS.getSelectedIndex()));
        this.updateStartButtonState();
    }

    public void setReLonDimensionVariables(ComboBoxModel model) {
        this.reLonVariable.setModel(model);
    }

    public void setProgress(ConverterTask.Progress progress) {
        if (progress.isFailed) {
            this.bar.setValue(0);
            this.bar.setString(progress.message);
        } else {
            this.bar.setValue((int)progress.progress);
            this.bar.setString(progress.message);
        }
    }

    public RasterTransformer getSelectedTransformer() {
        return (RasterTransformer)this.transformers.getSelectedItem();
    }

    public boolean getXYSwitch() {
        return this.xySwitchBox.isSelected();
    }

    public void initVarCombos() {
        int i;
        int i2;
        this.convVariable.setSelectedIndex(this.convVariable.getItemCount() - 1);
        for (i2 = 0; i2 < this.lonVariable.getItemCount(); ++i2) {
            if (!this.lonVariable.getItemAt(i2).toString().equals("lon")) continue;
            this.lonVariable.setSelectedIndex(i2);
            break;
        }
        for (i2 = 0; i2 < this.latVariable.getItemCount(); ++i2) {
            if (!this.latVariable.getItemAt(i2).toString().equals("lat")) continue;
            this.latVariable.setSelectedIndex(i2);
            break;
        }
        String rlon = "lon";
        String rlat = "lat";
        for (i = 0; i < this.reLonVariable.getItemCount(); ++i) {
            if (!this.reLonVariable.getItemAt(i).equals("rlon")) continue;
            rlon = "rlon";
            break;
        }
        for (i = 0; i < this.reLatVariable.getItemCount(); ++i) {
            if (!this.reLatVariable.getItemAt(i).equals("rlat")) continue;
            rlat = "rlat";
            break;
        }
        this.reLonVariable.setSelectedItem(rlon);
        this.reLatVariable.setSelectedItem(rlat);
        this.timeVariable.setSelectedIndex(1);
    }

    private void initGUIMethods() {
        this.inputFileChooseBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dir = DatasetViewer.this.props.getProperty("recent_ncdf_dir", DatasetViewer.this.workspace.getAbsolutePath());
                DatasetViewer.this.chooser.setSelectedFile(new File(dir, "."));
                int returnVal = DatasetViewer.this.chooser.showOpenDialog(DatasetViewer.this.fileInputFrame);
                if (returnVal == 0) {
                    DatasetViewer.this.tmeanInputFileName.setText(DatasetViewer.this.chooser.getSelectedFile().getAbsolutePath());
                    File selectedInputFile = DatasetViewer.this.chooser.getSelectedFile();
                    DatasetViewer.this.props.setProperty("recent_ncdf_dir", selectedInputFile.getParent());
                    DatasetViewer.this.netcdfVarTable.setEnabled(false);
                    boolean success = DatasetViewer.this.controller.setInputFile(selectedInputFile);
                    if (success) {
                        DatasetViewer.this.netcdfVarTable.doLayout();
                        DatasetViewer.this.netcdfVarTable.invalidate();
                    }
                }
            }
        });
        this.outputFileChooseBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.fc_output.setDialogTitle("Choose a file");
                if (DatasetViewer.this.fc_output.showOpenDialog(null) != 0) {
                    return;
                }
                File outputFile = DatasetViewer.this.fc_output.getSelectedFile();
                DatasetViewer.this.outputFileName.setText(outputFile.getName());
                DatasetViewer.this.controller.setOutputFile(outputFile);
            }
        });
        this.recentFileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) != -1) {
                    String file = list.getModel().getElementAt(index).toString();
                    DatasetViewer.this.controller.setShapeFile(new File(file));
                }
            }
        });
        this.loadShapeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dir = DatasetViewer.this.props.getProperty("recent_shapefile_dir", DatasetViewer.this.workspace.getAbsolutePath());
                DatasetViewer.this.fc_shape.setDialogTitle("Choose a file");
                DatasetViewer.this.fc_shape.setSelectedFile(new File(dir, "."));
                if (DatasetViewer.this.fc_shape.showOpenDialog(null) != 0) {
                    return;
                }
                File shapeFileObj = DatasetViewer.this.fc_shape.getSelectedFile();
                DatasetViewer.this.props.setProperty("recent_shapefile_dir", shapeFileObj.getParent());
                DatasetViewer.this.controller.setShapeFile(shapeFileObj);
            }
        });
        this.exportSelectedCellsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setSelectedFile(new File(DatasetViewer.this.workspace, "."));
                fc.setDialogTitle("Choose a file");
                if (fc.showSaveDialog(DatasetViewer.this) != 0) {
                    return;
                }
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(fc.getSelectedFile()));
                    Point[] cells = DatasetViewer.this.gisPanel.getSelectedCells();
                    for (int i = 0; i < cells.length; ++i) {
                        writer.write(cells[i].x + ";" + cells[i].y + "\n");
                    }
                    writer.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    JOptionPane.showMessageDialog(DatasetViewer.this, ioe);
                }
            }
        });
        this.importSelectedCellsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setSelectedFile(new File(DatasetViewer.this.workspace, "."));
                fc.setDialogTitle("Choose a file");
                if (fc.showOpenDialog(DatasetViewer.this) != 0) {
                    return;
                }
                DatasetViewer.this.controller;
                Point[] selectedCells = DatasetController.readRasterCellFile(fc.getSelectedFile());
                DatasetViewer.this.gisPanel.setSelectedCells(selectedCells);
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JButton)e.getSource()).setEnabled(false);
                DatasetViewer.this.bar.setString("0%");
                DatasetViewer.this.bar.setValue(0);
                DatasetViewer.this.controller.startConversion();
                DatasetViewer.this.updateStartButtonState();
            }
        });
        ActionListener variableChangeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.controller.updateDataset();
            }
        };
        ActionListener mainVariableChangeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.controller.conversionDatasetSelected();
            }
        };
        ActionListener remappingChangeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.controller.reMapingSelected();
            }
        };
        this.convVariable.addActionListener(variableChangeListener);
        this.convVariable.addActionListener(mainVariableChangeListener);
        this.latVariable.addActionListener(variableChangeListener);
        this.reLatVariable.addActionListener(remappingChangeListener);
        this.reLonVariable.addActionListener(remappingChangeListener);
        this.lonVariable.addActionListener(variableChangeListener);
        this.timeVariable.addActionListener(variableChangeListener);
    }

    public static void printHelp() {
        System.out.println("NetCDFConverter netcdf [-p projection] [-t aggregationTime] [-a aggregationMode] [append] -srcpath -variable name -rastercell file -destfile");
        System.out.println("projection = EPSG:your code");
        System.out.println("aggregationTime = hourly|daily|weekly|monthly|yearly");
        System.out.println("aggregationMode = sum|avg|min|max");
        System.out.println("notice aggregation is only performd on timesteps within one file and NOT within multiple files");
    }

    public static Point[] readRasterCellFile(String file) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line, ";");
                if (tok.countTokens() != 2) {
                    System.out.println("error while parsing rastercell file in line" + line);
                }
                Point p = new Point();
                p.x = Integer.parseInt(tok.nextToken());
                p.y = Integer.parseInt(tok.nextToken());
                pointList.add(p);
            }
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("error, could not read raster cell file:" + ioe.toString());
            ioe.printStackTrace();
        }
        catch (NumberFormatException nfe) {
            System.out.println("error, could not parse raster cell file:" + nfe.toString());
            nfe.printStackTrace();
        }
        Point[] array = new Point[pointList.size()];
        array = pointList.toArray(array);
        return array;
    }

    private static NetcdfFile openNetCDFFile(String location, boolean addCoords, CancelTask task) {
        Object ncfile = null;
        try {
            ncfile = addCoords ? NetcdfDataset.acquireDataset((String)location, (CancelTask)task) : NetcdfDataset.acquireFile((String)location, (CancelTask)task);
            if (ncfile == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location);
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (null == message && ioe instanceof EOFException) {
                message = "Premature End of File";
            }
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ncfile = null;
        }
        catch (Exception e) {
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ncfile = null;
        }
        return ncfile;
    }

    private JPanel getConverterPanel() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        this.startButton = new JButton("Start Extraction");
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.bar.setMinimum(0);
        this.bar.setMaximum(1000);
        JLabel progressLabel = new JLabel("progress: ");
        try {
            this.gisPanel = new ShapeFileViewer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JScrollPane scrollPane = new JScrollPane(this.recentFileList);
        scrollPane.setHorizontalScrollBarPolicy(30);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.gisPanel).addGroup(layout.createParallelGroup().addComponent(this.loadShapeFileButton).addComponent(this.exportSelectedCellsButton).addComponent(this.importSelectedCellsButton).addComponent(this.xySwitchBox).addComponent(this.startButton).addComponent(this.bar))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.gisPanel).addGroup(layout.createSequentialGroup().addComponent(this.loadShapeFileButton).addComponent(this.exportSelectedCellsButton).addComponent(this.importSelectedCellsButton).addComponent(this.xySwitchBox).addComponent(this.startButton).addComponent(this.bar))));
        this.loadShapeFileButton.setMinimumSize(new Dimension(200, this.loadShapeFileButton.getSize().height));
        this.exportSelectedCellsButton.setMinimumSize(new Dimension(200, this.loadShapeFileButton.getSize().height));
        this.importSelectedCellsButton.setMinimumSize(new Dimension(200, this.loadShapeFileButton.getSize().height));
        this.startButton.setMinimumSize(new Dimension(200, this.loadShapeFileButton.getSize().height));
        this.bar.setMaximumSize(new Dimension(200, this.loadShapeFileButton.getSize().height));
        return panel;
    }

    String resolveCRSName(int index) {
        switch (index) {
            case 0: {
                return "EPSG:4326";
            }
            case 1: {
                return "EPSG:32723";
            }
            case 2: {
                return "EPSG:32633";
            }
            case 3: {
                return "EPSG:32646";
            }
            case 4: {
                return "EPSG:32647";
            }
        }
        return this.srcCRS.getModel().getElementAt(index).toString();
    }

    public static void main(String[] arg) {
        if (arg.length == 0) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatasetViewer viewer = new DatasetViewer();
                    viewer.initGUI(null, null);
                }
            });
        } else {
            DatasetController.main(arg);
        }
    }
}

