/*
 * Decompiled with CFR 0.152.
 */
package netcdfTool2;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import netcdfTool2.ConverterTask;
import netcdfTool2.DatasetViewer;
import netcdfTool2.NetCDFConverterTask;
import netcdfTool2.gis.RasterTransformer;
import netcdfTool2.gis.ShapeFileViewer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class DatasetController
extends JPanel {
    static final String VERSION_STRING = "2.0";
    private NetcdfFile ds;
    String shapeFile = null;
    ConverterTask task = null;
    Variable class_from;
    File outputFile = null;
    File selectedInputFile = null;
    String[] netcdfAttr = new String[]{"dataType", "description", "dimensions", "name", "shape", "units"};
    String[][] netcdfAttrData = new String[0][];
    String[] fileTyps = new String[]{"netcdf"};
    int currentFileIndex = 0;
    final int maxRecentFiles = 10;
    DefaultListModel recentFileListModel = null;
    DatasetViewer viewer = null;
    private boolean state = false;

    public DatasetController(DatasetViewer viewer) {
        this.viewer = viewer;
        viewer.setRecentFileList(this.readRecentFileList());
    }

    private DefaultListModel readRecentFileList() {
        Properties recentFiles = new Properties();
        try {
            recentFiles.load(new FileReader("files.lst"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.currentFileIndex = 0;
        for (int i = 0; i < 10; ++i) {
            String file = recentFiles.getProperty(Integer.toString(i % 10));
            if (file == null) continue;
            model.addElement(file);
        }
        this.recentFileListModel = model;
        return model;
    }

    private void swap(DefaultListModel model, int i, int j) {
        if (i == j) {
            return;
        }
        Object o = model.get(i);
        model.set(i, model.get(j));
        model.set(j, o);
    }

    private void addFileToRecentFileList(String file) {
        if (this.recentFileListModel.contains(file)) {
            int index = this.recentFileListModel.indexOf(file);
            this.swap(this.recentFileListModel, 0, index);
        } else {
            boolean canAdd;
            boolean bl = canAdd = this.recentFileListModel.size() < 10;
            if (canAdd) {
                this.recentFileListModel.addElement(file);
            }
            for (int i = this.recentFileListModel.size() - 1; i > 0; --i) {
                this.swap(this.recentFileListModel, i, i - 1);
            }
            if (!canAdd) {
                this.recentFileListModel.set(0, file);
            }
        }
        if (this.recentFileListModel.size() > 10) {
            System.out.println("error");
        }
    }

    private void saveRecentFileList() {
        Properties recentFiles = new Properties();
        int c = 0;
        for (int i = 0; i < this.recentFileListModel.size(); ++i) {
            if (this.recentFileListModel.get(i) == null) continue;
            recentFiles.setProperty(Integer.toString(c), this.recentFileListModel.get(i).toString());
            ++c;
        }
        try {
            recentFiles.store(new FileWriter("files.lst", false), "recent file list");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setShapeFile(File file) {
        this.viewer.setShapeFile(file);
        this.updateDataset();
        this.addFileToRecentFileList(this.shapeFile);
    }

    public void exportSelectedCells(ShapeFileViewer gisPanel, File outputFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        Point[] cells = gisPanel.getSelectedCells();
        for (int i = 0; i < cells.length; ++i) {
            writer.write(cells[i].x + ";" + cells[i].y + "\n");
        }
        writer.close();
    }

    public void startConversion() {
        ConverterTask.ConvertingOptions opt = new ConverterTask.ConvertingOptions();
        opt.aggregationMode = this.viewer.getAggregationMode();
        opt.unitConvMode = this.viewer.getUnitConvMode();
        opt.transformer = this.viewer.getSelectedTransformer();
        opt.aggregationTime = this.viewer.getAggregationTimePeriod();
        opt.cells = this.viewer.getSelectedCells();
        opt.outputFile = this.outputFile;
        opt.dstProjName = this.viewer.getDstProjectionName();
        opt.srcProjName = this.viewer.getSrcProjectionName();
        opt.is360DayYear = this.viewer.is360DayYearSelected();
        opt.is365DayYear = this.viewer.is365DayYearSelected();
        opt.shapeFileName = this.viewer.getShapeFileName();
        opt.selectedFeatures = this.viewer.getSelectedFeatures();
        opt.xySwitch = this.viewer.getXYSwitch();
        this.task.setOptions(opt);
        this.task.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof ConverterTask.Progress) {
                    ConverterTask.Progress progress = (ConverterTask.Progress)evt.getNewValue();
                    DatasetController.this.viewer.setProgress(progress);
                }
            }
        });
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatasetController.this.task.execute();
                }
            });
        }
        catch (Exception ie) {
            ie.printStackTrace();
        }
    }

    public boolean readyToConvert() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DatasetController.this.task instanceof NetCDFConverterTask) {
                        NetCDFConverterTask ndfTask = (NetCDFConverterTask)DatasetController.this.task;
                        DatasetController.this.state = ndfTask.readyToConvert();
                    }
                }
            });
        }
        catch (Exception ie) {
            ie.printStackTrace();
        }
        return this.state;
    }

    public void setOutputFile(File f) {
        this.outputFile = f;
    }

    public boolean setInputFile(final File f) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatasetController.this.ds = DatasetController.openNetCDFFile(f.getAbsolutePath(), false, null);
                    if (DatasetController.this.ds == null) {
                        DatasetController.this.state = false;
                    }
                    DefaultTableModel model = new DefaultTableModel(0, 6);
                    List varList = DatasetController.this.ds.getVariables();
                    for (int i = 0; i < varList.size(); ++i) {
                        Object[] attrData = new String[]{((Variable)varList.get(i)).getDataType().toString(), ((Variable)varList.get(i)).getDescription(), ((Variable)varList.get(i)).getDimensions().toString(), ((Variable)varList.get(i)).getShortName(), ((Variable)varList.get(i)).getRanges().toString(), ((Variable)varList.get(i)).getUnitsString()};
                        model.addRow(attrData);
                    }
                    model.setColumnIdentifiers(DatasetController.this.netcdfAttr);
                    DefaultComboBoxModel<Object> mainVarList = new DefaultComboBoxModel<Object>();
                    DefaultComboBoxModel<Object> latVarList = new DefaultComboBoxModel<Object>();
                    DefaultComboBoxModel<Object> lonVarList = new DefaultComboBoxModel<Object>();
                    DefaultComboBoxModel<String> relatVarList = new DefaultComboBoxModel<String>();
                    DefaultComboBoxModel<String> relonVarList = new DefaultComboBoxModel<String>();
                    DefaultComboBoxModel<Object> timeVarList = new DefaultComboBoxModel<Object>();
                    mainVarList.addElement("");
                    latVarList.addElement("");
                    relatVarList.addElement("");
                    relonVarList.addElement("");
                    lonVarList.addElement("");
                    timeVarList.addElement("");
                    for (int i = 0; i < varList.size(); ++i) {
                        mainVarList.addElement(new VariableWrapper((Variable)varList.get(i)));
                        latVarList.addElement(new VariableWrapper((Variable)varList.get(i)));
                        lonVarList.addElement(new VariableWrapper((Variable)varList.get(i)));
                        timeVarList.addElement(new VariableWrapper((Variable)varList.get(i)));
                    }
                    DatasetController.this.viewer.setNetCDFVarTableModel(model);
                    DatasetController.this.viewer.setConversionVariables(mainVarList);
                    DatasetController.this.viewer.setLatDimensionVariables(latVarList);
                    DatasetController.this.viewer.setLonDimensionVariables(lonVarList);
                    DatasetController.this.viewer.setReLatDimensionVariables(relatVarList);
                    DatasetController.this.viewer.setReLonDimensionVariables(relonVarList);
                    DatasetController.this.viewer.setTimeDimensionVariables(timeVarList);
                    DatasetController.this.task = new NetCDFConverterTask(DatasetController.this.ds);
                    DatasetController.this.updateDataset();
                    DatasetController.this.viewer.initVarCombos();
                    DatasetController.this.state = true;
                }
            });
        }
        catch (Exception ie) {
            ie.printStackTrace();
        }
        return this.state;
    }

    public void conversionDatasetSelected() {
        Variable convVar = ((VariableWrapper)this.viewer.getSelectedConversionVariable()).getVariable();
        DefaultComboBoxModel<String> relatVarList = new DefaultComboBoxModel<String>();
        DefaultComboBoxModel<String> relonVarList = new DefaultComboBoxModel<String>();
        for (Dimension d : convVar.getDimensions()) {
            relatVarList.addElement(d.getName());
            relonVarList.addElement(d.getName());
        }
        this.viewer.setReLatDimensionVariables(relatVarList);
        this.viewer.setReLonDimensionVariables(relonVarList);
    }

    public void reMapingSelected() {
        String relatVar = (String)this.viewer.getSelectedReLatVariable();
        String relonVar = (String)this.viewer.getSelectedReLonVariable();
        if (relatVar != null && relonVar != null && this.task instanceof NetCDFConverterTask) {
            NetCDFConverterTask ndfTask = (NetCDFConverterTask)this.task;
            ndfTask.setReLatDataset(relatVar);
            ndfTask.setReLonDataset(relonVar);
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DatasetController.this.task.readCoordinateSystem();
                        RasterTransformer transformer = DatasetController.this.viewer.getSelectedTransformer();
                        double[][][] grid = DatasetController.this.task.makeGrid(transformer);
                        if (grid != null) {
                            DatasetController.this.viewer.setRaster(grid);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateDataset() {
        if (this.task instanceof NetCDFConverterTask) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NetCDFConverterTask ndfTask = (NetCDFConverterTask)DatasetController.this.task;
                        if (DatasetController.this.viewer.getSelectedConversionVariable() instanceof String || DatasetController.this.viewer.getSelectedLatVariable() instanceof String || DatasetController.this.viewer.getSelectedLonVariable() instanceof String || DatasetController.this.viewer.getSelectedTimeVariable() instanceof String) {
                            return;
                        }
                        try {
                            Variable convVar = ((VariableWrapper)DatasetController.this.viewer.getSelectedConversionVariable()).getVariable();
                            Variable latVar = ((VariableWrapper)DatasetController.this.viewer.getSelectedLatVariable()).getVariable();
                            Variable lonVar = ((VariableWrapper)DatasetController.this.viewer.getSelectedLonVariable()).getVariable();
                            Variable timeVar = ((VariableWrapper)DatasetController.this.viewer.getSelectedTimeVariable()).getVariable();
                            if (convVar != null && latVar != null && lonVar != null && timeVar != null) {
                                ndfTask.setLatDataset(latVar);
                                ndfTask.setLonDataset(lonVar);
                                ndfTask.setTimeDataset(timeVar);
                                ndfTask.setConversionDataset(convVar);
                                try {
                                    DatasetController.this.task.readCoordinateSystem();
                                    RasterTransformer transformer = DatasetController.this.viewer.getSelectedTransformer();
                                    DatasetController.this.viewer.setRaster(DatasetController.this.task.makeGrid(transformer));
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (ClassCastException cce) {
                            cce.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void printHelp() {
        System.out.println("NetCDFConverter netcdf [-pdst projection -t aggregationTime -a aggregationMode -u unitConversion -rCoordinates coordinates] srcpath variablename latname lonname timename rastercellfile destfile");
        System.out.println("projection = EPSG:your code");
        System.out.println("aggregationTime = hourly|daily|weekly|monthly|yearly");
        System.out.println("aggregationMode = sum|avg|min|max");
        System.out.println("notice aggregation is only performd on timesteps within one file and NOT within multiple files");
    }

    public static Point[] readRasterCellFile(File file) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line, ";");
                if (tok.countTokens() != 2) {
                    System.out.println("error while parsing rastercell file in line" + line);
                }
                Point p = new Point();
                p.x = Integer.parseInt(tok.nextToken());
                p.y = Integer.parseInt(tok.nextToken());
                pointList.add(p);
            }
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("error, could not read raster cell file:" + ioe.toString());
            ioe.printStackTrace();
        }
        catch (NumberFormatException nfe) {
            System.out.println("error, could not parse raster cell file:" + nfe.toString());
            nfe.printStackTrace();
        }
        Point[] array = new Point[pointList.size()];
        array = pointList.toArray(array);
        return array;
    }

    private static NetcdfFile openNetCDFFile(String location, boolean addCoords, CancelTask task) {
        Object ncfile = null;
        try {
            ncfile = addCoords ? NetcdfDataset.acquireDataset((String)location, (CancelTask)task) : NetcdfDataset.acquireFile((String)location, (CancelTask)task);
            if (ncfile == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location);
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (null == message && ioe instanceof EOFException) {
                message = "Premature End of File";
            }
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ncfile = null;
        }
        catch (Exception e) {
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ncfile = null;
        }
        return ncfile;
    }

    public static void main(String[] arg) {
        String mode = arg[0];
        if (mode.equals("netcdf")) {
            int i;
            File[] allFiles;
            String sourceName;
            if (arg.length < 5) {
                System.out.println("error, not enough arguments");
                DatasetController.printHelp();
                return;
            }
            String dstProjectionName = "EPSG:4326";
            String srcProjectionName = "EPSG:4326";
            String reLatVarName = null;
            String reLonVarName = null;
            String datasetName = null;
            int aggregationTimeMode = 0;
            int aggregationMode = 1;
            int unitConvMode = 0;
            int startArg = 1;
            boolean append = false;
            boolean use360dayYear = false;
            boolean use365dayYear = false;
            while (arg[startArg].startsWith("-")) {
                String aggMode;
                if (arg[startArg].startsWith("-pdst")) {
                    dstProjectionName = arg[++startArg];
                    ++startArg;
                }
                if (arg[startArg].startsWith("-psrc")) {
                    srcProjectionName = arg[++startArg];
                    ++startArg;
                }
                if (arg[startArg].startsWith("-rCoordinates")) {
                    reLatVarName = arg[++startArg];
                    reLonVarName = arg[++startArg];
                    ++startArg;
                }
                if (arg[startArg].startsWith("-t")) {
                    String timeMode;
                    if ((timeMode = arg[++startArg]).equals("hourly")) {
                        aggregationTimeMode = 1;
                    }
                    if (timeMode.equals("daily")) {
                        aggregationTimeMode = 2;
                    }
                    if (timeMode.equals("weekly")) {
                        aggregationTimeMode = 3;
                    }
                    if (timeMode.equals("monthly")) {
                        aggregationTimeMode = 4;
                    }
                    if (timeMode.equals("yearly")) {
                        aggregationTimeMode = 5;
                    }
                    ++startArg;
                }
                if (arg[startArg].startsWith("-append")) {
                    append = true;
                    ++startArg;
                }
                if (arg[startArg].startsWith("-a")) {
                    if ((aggMode = arg[++startArg]).equals("sum")) {
                        aggregationMode = 0;
                    }
                    if (aggMode.equals("avg")) {
                        aggregationMode = 1;
                    }
                    if (aggMode.equals("min")) {
                        aggregationMode = 2;
                    }
                    if (aggMode.equals("max")) {
                        aggregationMode = 3;
                    }
                    ++startArg;
                }
                if (arg[startArg].startsWith("-u")) {
                    if ((aggMode = arg[++startArg]).equals("k2deg")) {
                        unitConvMode = 2;
                    }
                    if (aggMode.equals("sec2hrs")) {
                        unitConvMode = 3;
                    }
                    if (aggMode.equals("sec2TU")) {
                        unitConvMode = 1;
                    }
                    ++startArg;
                }
                if (arg[startArg].startsWith("-name")) {
                    datasetName = arg[++startArg];
                    ++startArg;
                }
                if (arg[startArg].startsWith("-360days")) {
                    use360dayYear = true;
                    ++startArg;
                }
                if (!arg[startArg].startsWith("-365days")) continue;
                use365dayYear = true;
                ++startArg;
            }
            File srcPath = new File(arg[startArg]);
            if (srcPath.getParentFile() == null) {
                srcPath = new File("./" + arg[startArg]);
            }
            if ((sourceName = srcPath.getName()).endsWith("*") && (allFiles = srcPath.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(sourceName.substring(0, sourceName.length() - 1));
                }
            })).length > 0) {
                srcPath = allFiles[0];
            }
            if (!srcPath.isDirectory() && !srcPath.isFile()) {
                System.out.println("error, source path does not exist");
                DatasetController.printHelp();
            }
            String variableName = arg[startArg + 1];
            String latVarName = arg[startArg + 2];
            String lonVarName = arg[startArg + 3];
            String timeVarName = arg[startArg + 4];
            Point[] selectedRasterCells = DatasetController.readRasterCellFile(new File(arg[startArg + 5]));
            File dstPath = new File(arg[startArg + 6]);
            Object[] files = null;
            files = srcPath.isDirectory() ? srcPath.listFiles() : new File[]{srcPath};
            Arrays.sort(files);
            int successfullyProcessedFiles = 0;
            String fileName = ((File)files[0]).getName();
            for (i = 1; i < files.length; ++i) {
                fileName = fileName + ";" + ((File)files[i]).getName();
            }
            for (i = 0; i < files.length; ++i) {
                NetcdfFile ds = DatasetController.openNetCDFFile(((File)files[i]).getPath(), false, null);
                if (ds == null) {
                    System.out.println("skip " + ((File)files[i]).getPath());
                    continue;
                }
                System.out.println("working on:" + ((File)files[i]).getPath());
                Variable var = ds.findVariable(variableName);
                Variable latVar = ds.findVariable(latVarName);
                Variable lonVar = ds.findVariable(lonVarName);
                Variable timeVar = ds.findVariable(timeVarName);
                NetCDFConverterTask task = new NetCDFConverterTask(ds);
                task.setConversionDataset(var);
                task.setTimeDataset(timeVar);
                task.setLatDataset(latVar);
                task.setLonDataset(lonVar);
                task.setReLatDataset(reLatVarName);
                task.setReLonDataset(reLonVarName);
                ConverterTask.ConvertingOptions opt = new ConverterTask.ConvertingOptions();
                opt.fileNames = fileName;
                opt.aggregationMode = aggregationMode;
                opt.unitConvMode = unitConvMode;
                if (datasetName != null) {
                    opt.datasetName = datasetName;
                }
                opt.aggregationTime = aggregationTimeMode;
                opt.cells = selectedRasterCells;
                opt.outputFile = dstPath;
                opt.dstProjName = dstProjectionName;
                opt.srcProjName = srcProjectionName;
                opt.appendMode = append | successfullyProcessedFiles != 0;
                opt.is360DayYear = use360dayYear;
                opt.is365DayYear = use365dayYear;
                task.setOptions(opt);
                if (!task.readyToConvert()) {
                    System.out.println("Error: Task is not ready to convert. Missing or wrong converting information was provided!");
                } else {
                    task.execute();
                }
                ++successfullyProcessedFiles;
            }
        } else {
            System.out.println("unrecognized mode" + mode);
        }
    }

    private class VariableWrapper {
        Variable v;

        VariableWrapper(Variable v) {
            this.v = v;
        }

        Variable getVariable() {
            return this.v;
        }

        public String toString() {
            return this.v.getShortName();
        }
    }
}

