/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.codehaus.jackson.io.IOContext;

abstract class BaseReader
extends Reader {
    protected static final int LAST_VALID_UNICODE_CHAR = 0x10FFFF;
    protected static final char NULL_CHAR = '\u0000';
    protected static final char NULL_BYTE = '\u0000';
    protected final IOContext mContext;
    protected InputStream mIn;
    protected byte[] mBuffer;
    protected int mPtr;
    protected int mLength;
    char[] mTmpBuf = null;

    protected BaseReader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n, int n2) {
        this.mContext = iOContext;
        this.mIn = inputStream;
        this.mBuffer = byArray;
        this.mPtr = n;
        this.mLength = n2;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.mIn;
        if (inputStream != null) {
            this.mIn = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mTmpBuf == null) {
            this.mTmpBuf = new char[1];
        }
        if (this.read(this.mTmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this.mTmpBuf[0];
    }

    public final void freeBuffers() {
        byte[] byArray = this.mBuffer;
        if (byArray != null) {
            this.mBuffer = null;
            this.mContext.releaseReadIOBuffer(byArray);
        }
    }

    protected void reportBounds(char[] cArray, int n, int n2) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n + "," + n2 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

