/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.firstperson;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.animation.AnimationController;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.animation.MoveToPositionAnimator;
import gov.nasa.worldwind.animation.RotateToAngleAnimator;
import gov.nasa.worldwind.awt.AbstractViewInputHandler;
import gov.nasa.worldwind.awt.BasicViewInputHandler;
import gov.nasa.worldwind.awt.KeyEventState;
import gov.nasa.worldwind.awt.ViewInputActionHandler;
import gov.nasa.worldwind.awt.ViewInputAttributes;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.ViewUtil;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;
import gov.nasa.worldwind.view.firstperson.FlyToFlyViewAnimator;
import gov.nasa.worldwind.view.firstperson.FlyViewLimits;
import gov.nasa.worldwind.view.orbit.OrbitViewPropertyAccessor;
import java.awt.event.KeyEvent;
import java.util.List;

public class FlyViewInputHandler
extends BasicViewInputHandler {
    AnimationController uiAnimControl = new AnimationController();
    AnimationController gotoAnimControl = new AnimationController();
    protected static final String VIEW_ANIM_HEADING = "ViewAnimHeading";
    protected static final String VIEW_ANIM_PITCH = "ViewAnimPitch";
    protected static final String VIEW_ANIM_ROLL = "ViewAnimRoll";
    protected static final String VIEW_ANIM_POSITION = "ViewAnimPosition";
    protected static final String VIEW_ANIM_PAN = "ViewAnimPan";
    protected static final String VIEW_ANIM_APP = "ViewAnimApp";
    protected static final String ACTION_RESET_PITCH = "ResetPitch";
    protected static final double DEFAULT_MOUSE_ROTATE_MIN_VALUE = 0.014;
    protected static final double DEFAULT_MOUSE_ROTATE_MAX_VALUE = 0.018;
    protected static final double DEFAULT_KEY_TRANSLATE_SMOOTHING_VALUE = 0.9;
    protected static final double DEFAULT_KEY_HORIZONTAL_TRANSLATE_MAX_VALUE = 1000000.0;
    protected static final double DEFAULT_KEY_HORIZONTAL_TRANSLATE_MIN_VALUE = 100.0;
    protected static final double DEFAULT_KEY_HORIZONTAL_TRANSLATE_MIN_VALUE_SLOW = 1.0;
    protected static final double DEFAULT_KEY_HORIZONTAL_TRANSLATE_MAX_VALUE_SLOW = 100000.0;
    protected static double DEFAULT_MOUSE_HORIZONTAL_TRANSLATE_MIN_VALUE = 5.0;
    protected static double DEFAULT_MOUSE_HORIZONTAL_TRANSLATE_MAX_VALUE = 50000.0;
    protected static final double DEFAULT_MOUSE_VERTICAL_TRANSLATE_MIN_VALUE = 1.0;
    protected static final double DEFAULT_MOUSE_VERTICAL_TRANSLATE_MAX_VALUE = 30000.0;
    protected static final double DEFAULT_KEY_VERTICAL_TRANSLATE_MIN_VALUE = 5.0;
    protected static final double DEFAULT_KEY_VERTICAL_TRANSLATE_MAX_VALUE = 5000.0;
    protected static final double DEFAULT_MOUSE_WHEEL_VERTICAL_TRANSLATE_VALUE_MIN_OSX = 10.0;
    protected static final double DEFAULT_MOUSE_WHEEL_VERTICAL_TRANSLATE_VALUE_MAX_OSX = 900000.0;
    protected static final double DEFAULT_MOUSE_WHEEL_VERTICAL_TRANSLATE_VALUE_MIN = 100.0;
    protected static final double DEFAULT_MOUSE_WHEEL_VERTICAL_TRANSLATE_VALUE_MAX = 100000.0;
    protected static final ViewInputAttributes.ActionAttributes.KeyAction DEFAULT_RESET_PITCH_KEY_ACT = new ViewInputAttributes.ActionAttributes.KeyAction(80, 0, 1);
    public static final ViewInputAttributes.ActionAttributes.KeyAction[] resetPitchEvents = new ViewInputAttributes.ActionAttributes.KeyAction[]{DEFAULT_RESET_PITCH_KEY_ACT};
    double speed = 10.0;

    public FlyViewInputHandler() {
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewHorizTrans", DEFAULT_MOUSE_HORIZONTAL_TRANSLATE_MIN_VALUE, DEFAULT_MOUSE_HORIZONTAL_TRANSLATE_MAX_VALUE);
        this.getAttributes().setActionTrigger("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewHorizTrans", ViewInputAttributes.ActionAttributes.ActionTrigger.ON_KEY_DOWN);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewRotateShift", 0.014, 0.018);
        this.getAttributes().setActionTrigger("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewRotateShift", ViewInputAttributes.ActionAttributes.ActionTrigger.ON_KEY_DOWN);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewRotate", 0.014, 0.018);
        this.getAttributes().setActionTrigger("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewRotate", ViewInputAttributes.ActionAttributes.ActionTrigger.ON_KEY_DOWN);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewVertTrans", 1.0, 30000.0);
        this.getAttributes().setActionTrigger("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewVertTrans", ViewInputAttributes.ActionAttributes.ActionTrigger.ON_KEY_DOWN);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewVertTransCtrl", 1.0, 30000.0);
        this.getAttributes().setActionTrigger("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewVertTransCtrl", ViewInputAttributes.ActionAttributes.ActionTrigger.ON_KEY_DOWN);
        RollActionListener rollActionListener = new RollActionListener();
        this.getAttributes().setActionListener("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewRollKeys", rollActionListener);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewHorizTransKeys", 100.0, 1000000.0);
        this.getAttributes().getActionAttributes("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewHorizTransKeys").setSmoothingValue(0.9);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewHorizTransSlow", 1.0, 100000.0);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewVertTransKeys", 5.0, 5000.0);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewVertTransKeysMeta", 5.0, 5000.0);
        this.getAttributes().setValues("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewVertTransKeysCTRL", 5.0, 5000.0);
        if (Configuration.isMacOS()) {
            this.getAttributes().setValues("gov.nasa.worldwind.DeviceMouseWheel", "gov.nasa.worldwind.ViewVertTrans", 10.0, 900000.0);
        } else {
            this.getAttributes().setValues("gov.nasa.worldwind.DeviceMouseWheel", "gov.nasa.worldwind.ViewVertTrans", 100.0, 100000.0);
        }
        this.getAttributes().addAction("gov.nasa.worldwind.DeviceKeyboard", 0, ACTION_RESET_PITCH, new ViewInputAttributes.ActionAttributes(resetPitchEvents, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_PRESS, 0, 0.1, 0.1, false, 0.1));
        ViewInputAttributes.ActionAttributes actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes(ACTION_RESET_PITCH);
        actionAttributes.setActionListener(new ResetPitchActionListener());
    }

    @Override
    protected void onMoveTo(Position position, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        Vec4 vec4;
        BasicFlyView basicFlyView = (BasicFlyView)this.getView();
        if (basicFlyView == null) {
            return;
        }
        double d = this.getScaleValueElevation(deviceAttributes, actionAttributes);
        if (!actionAttributes.isEnableSmoothing()) {
            d = 0.0;
        }
        if ((vec4 = basicFlyView.getCenterPoint()) == null) {
            vec4 = basicFlyView.getGlobe().computePointFromPosition(position);
        }
        Vec4 vec42 = basicFlyView.getEyePoint();
        double d2 = vec42.distanceTo3(vec4);
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Vec4 vec44 = basicFlyView.getGlobe().computePointFromPosition(position);
        Vec4 vec45 = vec44.add3(vec43.multiply3(d2));
        Position position2 = basicFlyView.getGlobe().computePositionFromPoint(vec45);
        ViewUtil.ViewState viewState = basicFlyView.getViewState(position2, position);
        this.stopAnimators();
        this.gotoAnimControl.put(VIEW_ANIM_HEADING, new RotateToAngleAnimator(basicFlyView.getHeading(), viewState.getHeading(), d, ViewPropertyAccessor.createHeadingAccessor(basicFlyView)));
        this.gotoAnimControl.put(VIEW_ANIM_PITCH, new RotateToAngleAnimator(basicFlyView.getPitch(), viewState.getPitch(), d, ViewPropertyAccessor.createPitchAccessor(basicFlyView)));
        double d3 = ((FlyViewLimits)basicFlyView.getViewPropertyLimits()).limitEyeElevation(position2, basicFlyView.getGlobe());
        if (d3 != position2.getElevation()) {
            position2 = new Position(position2, d3);
        }
        this.gotoAnimControl.put(VIEW_ANIM_POSITION, new MoveToPositionAnimator(basicFlyView.getEyePosition(), position2, d, ViewPropertyAccessor.createEyePositionAccessor(basicFlyView)));
        basicFlyView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicFlyView);
    }

    @Override
    protected void onMoveTo(Position position, ViewInputAttributes.ActionAttributes actionAttributes) {
    }

    @Override
    protected void onHorizontalTranslateAbs(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
    }

    @Override
    protected void onHorizontalTranslateRel(double d, double d2, double d3, double d4, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        Angle angle;
        Angle angle2;
        this.stopGoToAnimators();
        if (actionAttributes.getMouseActions() != null) {
            angle2 = Angle.fromDegrees(-d3 * this.getScaleValueElevation(deviceAttributes, actionAttributes));
            angle = Angle.fromDegrees(d4 * this.getScaleValueElevation(deviceAttributes, actionAttributes));
        } else {
            angle2 = Angle.fromDegrees(d * this.speed * this.getScaleValueElevation(deviceAttributes, actionAttributes));
            angle = Angle.fromDegrees(d2 * this.speed * this.getScaleValueElevation(deviceAttributes, actionAttributes));
        }
        this.onHorizontalTranslateRel(angle2, angle, actionAttributes);
    }

    @Override
    protected void onHorizontalTranslateRel(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (angle.equals(Angle.ZERO) && angle2.equals(Angle.ZERO)) {
            return;
        }
        if (view instanceof BasicFlyView) {
            Vec4 vec4 = view.getForwardVector();
            Vec4 vec42 = view.getUpVector();
            Vec4 vec43 = vec4.transformBy3(Matrix.fromAxisAngle(Angle.fromDegrees(90.0), vec42));
            vec4 = vec4.multiply3(angle.getDegrees());
            vec43 = vec43.multiply3(angle2.getDegrees());
            Vec4 vec44 = view.getEyePoint();
            vec44 = vec44.add3(vec4.add3(vec43));
            Position position = view.getGlobe().computePositionFromPoint(vec44);
            this.setEyePosition(this.uiAnimControl, view, position, actionAttributes);
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    @Override
    protected void onResetHeading(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        this.gotoAnimControl.put(VIEW_ANIM_HEADING, new RotateToAngleAnimator(view.getHeading(), Angle.ZERO, d, ViewPropertyAccessor.createHeadingAccessor(view)));
        view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
    }

    protected void onResetPitch(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        this.gotoAnimControl.put(VIEW_ANIM_PITCH, new RotateToAngleAnimator(view.getPitch(), Angle.POS90, d, ViewPropertyAccessor.createPitchAccessor(view)));
        view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
    }

    @Override
    protected void onResetHeadingPitchRoll(ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        double d = 0.95;
        this.gotoAnimControl.put(VIEW_ANIM_HEADING, new RotateToAngleAnimator(view.getHeading(), Angle.ZERO, d, ViewPropertyAccessor.createHeadingAccessor(view)));
        this.gotoAnimControl.put(VIEW_ANIM_PITCH, new RotateToAngleAnimator(view.getPitch(), Angle.POS90, d, ViewPropertyAccessor.createPitchAccessor(view)));
        this.gotoAnimControl.put(VIEW_ANIM_ROLL, new RotateToAngleAnimator(view.getPitch(), Angle.ZERO, d, ViewPropertyAccessor.createRollAccessor(view)));
        view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
    }

    @Override
    protected void onRotateView(double d, double d2, double d3, double d4, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        Angle angle = Angle.fromDegrees(d3 * this.getScaleValueElevation(deviceAttributes, actionAttributes));
        Angle angle2 = Angle.fromDegrees(d4 * this.getScaleValueElevation(deviceAttributes, actionAttributes));
        this.onRotateView(angle, angle2, actionAttributes);
    }

    @Override
    protected void onRotateView(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof BasicFlyView) {
            BasicFlyView basicFlyView = (BasicFlyView)view;
            this.setPitch(basicFlyView, this.uiAnimControl, basicFlyView.getPitch().add(angle2), actionAttributes);
            this.setHeading(basicFlyView, this.uiAnimControl, basicFlyView.getHeading().add(angle), actionAttributes);
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    protected void onRoll(double d, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        Angle angle = Angle.fromDegrees(d * this.getScaleValueElevation(deviceAttributes, actionAttributes));
        this.onRoll(angle, actionAttributes);
    }

    protected void onRoll(Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof BasicFlyView) {
            BasicFlyView basicFlyView = (BasicFlyView)view;
            this.setRoll(basicFlyView, this.uiAnimControl, basicFlyView.getRoll().add(angle), actionAttributes);
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    @Override
    protected void onVerticalTranslate(double d, double d2, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        this.stopGoToAnimators();
        double d3 = -(d2 * this.getScaleValueElevation(deviceAttributes, actionAttributes));
        View view = this.getView();
        Position position = view.getEyePosition();
        Position position2 = new Position(position, position.getElevation() + d3);
        this.setEyePosition(this.uiAnimControl, view, position2, actionAttributes);
        view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
    }

    @Override
    protected void onVerticalTranslate(double d, ViewInputAttributes.ActionAttributes actionAttributes) {
    }

    @Override
    public void apply() {
        super.apply();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.gotoAnimControl.stepAnimators()) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
        if (this.uiAnimControl.stepAnimators()) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    @Override
    protected void handleViewStopped() {
        this.stopAnimators();
    }

    protected void setHeading(View view, AnimationController animationController, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        RotateToAngleAnimator rotateToAngleAnimator = new RotateToAngleAnimator(view.getHeading(), angle, d, ViewPropertyAccessor.createHeadingAccessor(view));
        animationController.put(VIEW_ANIM_HEADING, rotateToAngleAnimator);
    }

    protected void setPitch(View view, AnimationController animationController, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        RotateToAngleAnimator rotateToAngleAnimator = new RotateToAngleAnimator(view.getPitch(), angle, d, ViewPropertyAccessor.createPitchAccessor(view));
        animationController.put(VIEW_ANIM_PITCH, rotateToAngleAnimator);
    }

    protected void setRoll(View view, AnimationController animationController, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        RotateToAngleAnimator rotateToAngleAnimator = new RotateToAngleAnimator(view.getRoll(), angle, d, ViewPropertyAccessor.createRollAccessor(view));
        animationController.put(VIEW_ANIM_ROLL, rotateToAngleAnimator);
    }

    protected void setEyePosition(AnimationController animationController, View view, Position position, ViewInputAttributes.ActionAttributes actionAttributes) {
        MoveToPositionAnimator moveToPositionAnimator = (MoveToPositionAnimator)animationController.get(VIEW_ANIM_POSITION);
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d != 0.0) {
            double d2 = ((FlyViewLimits)view.getViewPropertyLimits()).limitEyeElevation(position, view.getGlobe());
            if (d2 != position.getElevation()) {
                position = new Position(position, d2);
            }
            if (moveToPositionAnimator == null) {
                moveToPositionAnimator = new MoveToPositionAnimator(view.getEyePosition(), position, d, OrbitViewPropertyAccessor.createEyePositionAccessor(view));
                animationController.put(VIEW_ANIM_POSITION, moveToPositionAnimator);
            } else {
                moveToPositionAnimator.setEnd(position);
                moveToPositionAnimator.start();
            }
        }
        view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
    }

    @Override
    public void goTo(Position position, double d) {
        Globe globe = this.getView().getGlobe();
        BasicFlyView basicFlyView = (BasicFlyView)this.getView();
        Position position2 = new Position(position, globe.getElevation(position.getLatitude(), position.getLongitude()) + d);
        long l = AnimationSupport.getScaledTimeMillisecs(basicFlyView.getEyePosition(), position2, 4000L, 16000L);
        FlyToFlyViewAnimator flyToFlyViewAnimator = FlyToFlyViewAnimator.createFlyToFlyViewAnimator(basicFlyView, basicFlyView.getEyePosition(), position2, basicFlyView.getHeading(), Angle.ZERO, basicFlyView.getPitch(), Angle.ZERO, basicFlyView.getEyePosition().getElevation(), position2.getElevation(), l, 0);
        this.gotoAnimControl.put(VIEW_ANIM_PAN, flyToFlyViewAnimator);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
    }

    public void lookAt(Position position, long l) {
        Object object;
        Position position2;
        BasicFlyView basicFlyView = (BasicFlyView)this.getView();
        Vec4 vec4 = basicFlyView.getCenterPoint();
        if (vec4 == null) {
            basicFlyView.getGlobe().computePointFromPosition(position);
            double d = basicFlyView.getGlobe().getElevation(position.getLatitude(), position.getLongitude());
            position2 = new Position(position, d + 10000.0);
        } else {
            Vec4 vec42 = basicFlyView.getEyePoint();
            double d = vec42.distanceTo3(vec4);
            Vec4 vec43 = vec4.subtract3(vec42).normalize3();
            object = basicFlyView.getGlobe().computePointFromPosition(position);
            Vec4 vec44 = ((Vec4)object).add3(vec43.multiply3(-d));
            position2 = basicFlyView.getGlobe().computePositionFromPoint(vec44);
        }
        ViewUtil.ViewState viewState = basicFlyView.getViewState(position2, position);
        object = FlyToFlyViewAnimator.createFlyToFlyViewAnimator(basicFlyView, basicFlyView.getEyePosition(), position2, basicFlyView.getHeading(), viewState.getHeading(), basicFlyView.getPitch(), viewState.getPitch(), basicFlyView.getEyePosition().getElevation(), viewState.getPosition().getElevation(), l, 0);
        this.gotoAnimControl.put(VIEW_ANIM_PAN, object);
        this.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.getView());
        basicFlyView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, basicFlyView);
    }

    @Override
    public void stopAnimators() {
        this.stopGoToAnimators();
        this.stopUserInputAnimators();
    }

    @Override
    public boolean isAnimating() {
        return this.uiAnimControl.hasActiveAnimation() || this.gotoAnimControl.hasActiveAnimation();
    }

    @Override
    public void addAnimator(Animator animator) {
        this.gotoAnimControl.put(VIEW_ANIM_APP, animator);
    }

    protected void stopGoToAnimators() {
        this.gotoAnimControl.stopAnimations();
        this.gotoAnimControl.clear();
    }

    protected void stopUserInputAnimators() {
        this.uiAnimControl.stopAnimations();
        this.uiAnimControl.clear();
    }

    public class RollActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
            List list = actionAttributes.getKeyActions();
            double d = 0.0;
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (!keyEventState.isKeyDown(keyAction.keyCode)) continue;
                d += (double)keyAction.sign;
            }
            if (d == 0.0) {
                return false;
            }
            if (string == "GenerateEvents") {
                ViewInputAttributes.DeviceAttributes deviceAttributes = abstractViewInputHandler.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceKeyboard");
                FlyViewInputHandler.this.onRoll(d, deviceAttributes, actionAttributes);
            }
            return true;
        }
    }

    public class ResetPitchActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEvent keyEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            List list = actionAttributes.getKeyActions();
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (keyEvent.getKeyCode() != keyAction.keyCode) continue;
                FlyViewInputHandler.this.onResetPitch(actionAttributes);
                return true;
            }
            return false;
        }
    }
}

