/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.wizard;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.wizard.WizardController;
import gov.nasa.worldwind.util.wizard.WizardModel;
import gov.nasa.worldwind.util.wizard.WizardPanelDescriptor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard {
    private WizardModel model;
    private WizardController controller;
    private int returnCode;
    private PropertyEvents propertyEvents;
    private WindowEvents windowEvents;
    private JDialog dialog;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    static final String BACK_BUTTON_ACTION_COMMAND = "wizard.BackButtonActionCommand";
    static final String NEXT_BUTTON_ACTION_COMMAND = "wizard.NextButtonActionCommand";
    static final String CANCEL_BUTTON_ACTION_COMMAND = "wizard.CancelButtonActionCommand";
    static final String DIALOG_CLOSE_ACTION_COMMAND = "wizard.DialogCloseActionCommand";
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final int CLOSED_RETURN_CODE = -1;
    public static final FinishIdentifier FINISH = new FinishIdentifier();

    public Wizard() {
        this.dialog = new JDialog();
        this.init();
    }

    public Wizard(Dialog dialog) {
        if (dialog == null) {
            String string = "Dialog is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dialog = new JDialog(dialog);
        this.init();
    }

    public Wizard(Frame frame) {
        if (frame == null) {
            String string = "Frame is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dialog = new JDialog(frame);
        this.init();
    }

    public WizardPanelDescriptor getWizardPanel(Object object) {
        return this.model.getWizardPanel(object);
    }

    public void registerWizardPanel(Object object, WizardPanelDescriptor wizardPanelDescriptor) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (wizardPanelDescriptor == null || wizardPanelDescriptor.getPanelComponent() == null) {
            String string = "Panel or PanelComponent is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.cardPanel.add(wizardPanelDescriptor.getPanelComponent(), object);
        wizardPanelDescriptor.registerPanel(this);
        this.model.registerWizardPanel(object, wizardPanelDescriptor);
    }

    public WizardPanelDescriptor getCurrentPanel() {
        return this.model.getCurrentPanel();
    }

    public void setCurrentPanelDescriptor(Object object) {
        if (object == null) {
            this.close(2);
            return;
        }
        WizardPanelDescriptor wizardPanelDescriptor = this.model.getCurrentPanel();
        if (wizardPanelDescriptor != null) {
            wizardPanelDescriptor.aboutToHidePanel();
        }
        if (!this.model.setCurrentPanel(object)) {
            return;
        }
        WizardPanelDescriptor wizardPanelDescriptor2 = this.model.getCurrentPanel();
        if (wizardPanelDescriptor2 != null) {
            wizardPanelDescriptor2.aboutToDisplayPanel();
        }
        this.cardLayout.show(this.cardPanel, object.toString());
        if (wizardPanelDescriptor2 != null) {
            wizardPanelDescriptor2.displayingPanel();
        }
    }

    public WizardModel getModel() {
        return this.model;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public Window getOwner() {
        return this.dialog.getOwner();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public boolean isModal() {
        return this.dialog.isModal();
    }

    public void setModal(boolean bl) {
        this.dialog.setModal(bl);
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public void setTitle(String string) {
        this.dialog.setTitle(string);
    }

    public int showModalDialog() {
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        return this.returnCode;
    }

    void close(int n) {
        this.returnCode = n;
        WizardPanelDescriptor wizardPanelDescriptor = this.model.getCurrentPanel();
        if (wizardPanelDescriptor != null) {
            wizardPanelDescriptor.aboutToHidePanel();
        }
        this.dialog.dispose();
    }

    public boolean isBackButtonEnabled() {
        Boolean bl = this.model.isBackButtonEnabled();
        return bl != null ? bl : false;
    }

    public void setBackButtonEnabled(boolean bl) {
        this.model.setBackButtonEnabled(bl);
    }

    public boolean isNextButtonEnabled() {
        Boolean bl = this.model.isNextButtonEnabled();
        return bl != null ? bl : false;
    }

    public void setNextButtonEnabled(boolean bl) {
        this.model.setNextButtonEnabled(bl);
    }

    public boolean isCancelButtonEnabled() {
        Boolean bl = this.model.isCancelButtonEnabled();
        return bl != null ? bl : false;
    }

    public void setCancelButtonEnabled(boolean bl) {
        this.model.setCancelButtonEnabled(bl);
    }

    public void giveFocusToBackButton() {
        this.backButton.requestFocusInWindow();
    }

    public void giveFocusToNextButton() {
        this.nextButton.requestFocusInWindow();
    }

    public void giveFocusToCancelButton() {
        this.cancelButton.requestFocusInWindow();
    }

    private void init() {
        this.model = new WizardModel();
        this.controller = new WizardController(this);
        this.propertyEvents = new PropertyEvents();
        this.model.addPropertyChangeListener(this.propertyEvents);
        this.windowEvents = new WindowEvents();
        this.dialog.addWindowListener(this.windowEvents);
        this.makeComponents();
        this.layoutComponents();
        this.controller.resetButtonsToPanelRules();
    }

    private void makeComponents() {
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.controller);
        this.nextButton.addActionListener(this.controller);
        this.cancelButton.addActionListener(this.controller);
        this.dialog.getRootPane().setDefaultButton(this.nextButton);
    }

    private void layoutComponents() {
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.cardPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.cardPanel.setLayout(this.cardLayout);
        this.dialog.getContentPane().add((Component)this.cardPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, "North");
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(5, 10, 5, 10));
        box.add(this.backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this.cancelButton);
        jPanel.add((Component)box, "East");
        this.dialog.getContentPane().add((Component)jPanel, "South");
    }

    private void setButtonText(JButton jButton, Object object) {
        if (jButton != null) {
            jButton.setText(object != null ? object.toString() : null);
        }
    }

    private void setButtonEnabled(JButton jButton, Object object) {
        if (jButton != null) {
            jButton.setEnabled(object != null && Boolean.parseBoolean(object.toString()));
        }
    }

    private void setButtonIcon(JButton jButton, Object object) {
        if (jButton != null) {
            jButton.setIcon(object != null && object instanceof Icon ? (Icon)object : null);
        }
    }

    private class WindowEvents
    extends WindowAdapter {
        private WindowEvents() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (Wizard.this.controller != null) {
                Wizard.this.controller.actionPerformed(new ActionEvent(windowEvent.getSource(), windowEvent.getID(), Wizard.DIALOG_CLOSE_ACTION_COMMAND));
            }
        }
    }

    private class PropertyEvents
    implements PropertyChangeListener {
        private PropertyEvents() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string.equals("wizard.CurrentPanelDescriptor")) {
                    if (Wizard.this.controller != null) {
                        Wizard.this.controller.resetButtonsToPanelRules();
                    }
                } else if (string.equals("wizard.BackButtonText")) {
                    Wizard.this.setButtonText(Wizard.this.backButton, object);
                } else if (string.equals("wizard.NextButtonText")) {
                    Wizard.this.setButtonText(Wizard.this.nextButton, object);
                } else if (string.equals("wizard.CancelButtonText")) {
                    Wizard.this.setButtonText(Wizard.this.cancelButton, object);
                } else if (string.equals("wizard.BackButtonEnabled")) {
                    Wizard.this.setButtonEnabled(Wizard.this.backButton, object);
                } else if (string.equals("wizard.NextButtonEnabled")) {
                    Wizard.this.setButtonEnabled(Wizard.this.nextButton, object);
                } else if (string.equals("wizard.CancelButtonEnabled")) {
                    Wizard.this.setButtonEnabled(Wizard.this.cancelButton, object);
                } else if (string.equals("wizard.BackButtonIcon")) {
                    Wizard.this.setButtonIcon(Wizard.this.backButton, object);
                } else if (string.equals("wizard.NextButtonIcon")) {
                    Wizard.this.setButtonIcon(Wizard.this.nextButton, object);
                } else if (string.equals("wizard.CancelButtonIcon")) {
                    Wizard.this.setButtonIcon(Wizard.this.cancelButton, object);
                }
            }
        }
    }

    static class FinishIdentifier {
        public static final String IDENTIFIER = "wizard.FinishIdentifier";

        FinishIdentifier() {
        }
    }
}

