/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.BarycentricQuadrilateral;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.awt.Dimension;
import java.util.logging.Level;

public class ImageInterpolator {
    protected final Dimension gridSize;
    protected final Cell root;
    protected final float[] xs;
    protected final float[] ys;
    protected final int cellSize;
    protected final BasicMemoryCache kidCache = new BasicMemoryCache(750000L, 1000000L);

    public ImageInterpolator(Dimension dimension, float[] fArray, float[] fArray2, int n, int n2) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (dimension.width < 2 || dimension.height < 2) {
            String string = Logging.getMessage("generic.DimensionsTooSmall");
            Logging.logger().log(Level.SEVERE, string, new Object[]{dimension.width, dimension.height});
            throw new IllegalStateException(string);
        }
        if (fArray == null || fArray2 == null || fArray.length < 4 || fArray2.length < 4) {
            String string = Logging.getMessage("Grid.ArraysInvalid");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("Grid.DepthInvalid");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("Grid.CellSizeInvalid");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.gridSize = dimension;
        this.cellSize = n2;
        this.xs = fArray;
        this.ys = fArray2;
        this.root = this.makeRootCell(0, this.gridSize.width - 1, 0, this.gridSize.height - 1);
        this.root.build(n, this.cellSize);
        this.root.computeBounds(this.gridSize, this.xs, this.ys);
    }

    protected Cell makeRootCell(int n, int n2, int n3, int n4) {
        return new Cell(n, n2, n3, n4);
    }

    public ContainingCell findContainingCell(float f, float f2) {
        return this.findContainingCell(this.root, f, f2);
    }

    protected ContainingCell findContainingCell(Cell cell, float f, float f2) {
        Cell[] cellArray;
        if (!cell.intersects(f, f2)) {
            return null;
        }
        if (cell.m1 - cell.m0 <= this.cellSize && cell.n1 - cell.n0 <= this.cellSize) {
            return this.checkContainment(f, f2, cell);
        }
        Cell[] cellArray2 = cellArray = cell.children != null ? cell.children : (Cell[])this.kidCache.getObject(cell);
        if (cellArray == null) {
            for (Cell cell2 : cellArray = cell.split(cell.m0, cell.m1, cell.n0, cell.n1)) {
                cell2.computeExtremesFromLocations(this.gridSize, this.xs, this.ys);
            }
            if (cell.children == null) {
                this.kidCache.add(cell, cellArray, 4L * cellArray[0].getSizeInBytes());
            }
        }
        for (Cell cell2 : cellArray) {
            ContainingCell containingCell = this.findContainingCell(cell2, f, f2);
            if (containingCell == null) continue;
            return containingCell;
        }
        return null;
    }

    protected ContainingCell checkContainment(float f, float f2, Cell cell) {
        double[] dArray = this.computeBilinearCoordinates(f, f2, cell);
        return dArray != null && dArray[0] <= 1.0 && dArray[1] <= 1.0 && dArray[0] >= 0.0 && dArray[1] >= 0.0 ? new ContainingCell(cell, dArray, this.getFieldIndices(cell)) : null;
    }

    protected double[] computeBilinearCoordinates(float f, float f2, Cell cell) {
        int n = this.index(cell.m0, cell.n0);
        int n2 = this.index(cell.m1, cell.n0);
        int n3 = this.index(cell.m1, cell.n1);
        int n4 = this.index(cell.m0, cell.n1);
        return BarycentricQuadrilateral.invertBilinear(new Vec4(f, f2, 0.0), new Vec4(this.xs[n], this.ys[n], 0.0), new Vec4(this.xs[n2], this.ys[n2], 0.0), new Vec4(this.xs[n3], this.ys[n3], 0.0), new Vec4(this.xs[n4], this.ys[n4], 0.0));
    }

    protected int[] getFieldIndices(Cell cell) {
        return new int[]{this.index(cell.m0, cell.n0), this.index(cell.m1, cell.n0), this.index(cell.m1, cell.n1), this.index(cell.m0, cell.n1)};
    }

    private int index(int n, int n2) {
        return n2 * this.gridSize.width + n;
    }

    public static class ContainingCell {
        public final int m0;
        public final int m1;
        public final int n0;
        public final int n1;
        public final float minx;
        public final float maxx;
        public final float miny;
        public final float maxy;
        public final double[] uv;
        public final int[] fieldIndices;

        private ContainingCell(Cell cell, double[] dArray, int[] nArray) {
            this.uv = dArray;
            this.m0 = cell.m0;
            this.m1 = cell.m1;
            this.n0 = cell.n0;
            this.n1 = cell.n1;
            this.minx = cell.minx;
            this.maxx = cell.maxx;
            this.miny = cell.miny;
            this.maxy = cell.maxy;
            this.fieldIndices = nArray;
        }
    }

    protected static class Cell
    implements Cacheable {
        protected final int m0;
        protected final int m1;
        protected final int n0;
        protected final int n1;
        protected float minx;
        protected float maxx;
        protected float miny;
        protected float maxy;
        protected Cell[] children;

        public Cell(int n, int n2, int n3, int n4) {
            this.m0 = n;
            this.m1 = n2;
            this.n0 = n3;
            this.n1 = n4;
        }

        protected Cell makeChildCell(int n, int n2, int n3, int n4) {
            return new Cell(n, n2, n3, n4);
        }

        @Override
        public long getSizeInBytes() {
            return 52L;
        }

        public void build(int n, int n2) {
            if (n == 0) {
                return;
            }
            if (this.m1 - this.m0 <= n2 && this.n1 - this.n0 <= n2) {
                return;
            }
            for (Cell cell : this.children = this.split(this.m0, this.m1, this.n0, this.n1)) {
                cell.build(n - 1, n2);
            }
        }

        public Cell[] split(int n, int n2, int n3, int n4) {
            int n5 = n2 - n > 1 ? n + (n2 - n) / 2 : n + 1;
            int n6 = n4 - n3 > 1 ? n3 + (n4 - n3) / 2 : n3 + 1;
            int n7 = n2 - n > 1 ? n5 : n;
            int n8 = n4 - n3 > 1 ? n6 : n3;
            return new Cell[]{this.makeChildCell(n, n5, n3, n6), this.makeChildCell(n7, n2, n3, n6), this.makeChildCell(n, n5, n8, n4), this.makeChildCell(n7, n2, n8, n4)};
        }

        public boolean intersects(float f, float f2) {
            return f >= this.minx && f <= this.maxx && f2 >= this.miny && f2 <= this.maxy;
        }

        public void computeBounds(Dimension dimension, float[] fArray, float[] fArray2) {
            if (this.children != null) {
                for (Cell cell : this.children) {
                    cell.computeBounds(dimension, fArray, fArray2);
                }
                this.computeExtremesFromChildren();
            } else {
                this.computeExtremesFromLocations(dimension, fArray, fArray2);
            }
        }

        protected void computeExtremesFromLocations(Dimension dimension, float[] fArray, float[] fArray2) {
            this.minx = Float.MAX_VALUE;
            this.maxx = -3.4028235E38f;
            this.miny = Float.MAX_VALUE;
            this.maxy = -3.4028235E38f;
            for (int i = this.n0; i <= this.n1; ++i) {
                for (int j = this.m0; j <= this.m1; ++j) {
                    int n = i * dimension.width + j;
                    float f = fArray[n];
                    float f2 = fArray2[n];
                    if (f < this.minx) {
                        this.minx = f;
                    }
                    if (f > this.maxx) {
                        this.maxx = f;
                    }
                    if (f2 < this.miny) {
                        this.miny = f2;
                    }
                    if (!(f2 > this.maxy)) continue;
                    this.maxy = f2;
                }
            }
        }

        protected void computeExtremesFromChildren() {
            this.minx = Float.MAX_VALUE;
            this.maxx = -3.4028235E38f;
            this.miny = Float.MAX_VALUE;
            this.maxy = -3.4028235E38f;
            if (this.children == null) {
                return;
            }
            for (Cell cell : this.children) {
                if (cell.minx < this.minx) {
                    this.minx = cell.minx;
                }
                if (cell.maxx > this.maxx) {
                    this.maxx = cell.maxx;
                }
                if (cell.miny < this.miny) {
                    this.miny = cell.miny;
                }
                if (!(cell.maxy > this.maxy)) continue;
                this.maxy = cell.maxy;
            }
        }
    }
}

