/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.cache.FileStoreFilter;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWXML;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataConfigurationFilter
implements FileFilter,
FileStoreFilter {
    @Override
    public boolean accept(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.acceptFilePath(file.getPath())) {
            return false;
        }
        Document document = null;
        try {
            document = WWXML.openDocumentFile(file.getPath(), this.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document != null && document.getDocumentElement() != null && this.accept(document);
    }

    public boolean accept(URL uRL) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Document document = null;
        try {
            document = WWXML.openDocumentURL(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document != null && document.getDocumentElement() != null && this.accept(document);
    }

    public boolean accept(InputStream inputStream) {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Document document = null;
        try {
            document = WWXML.openDocumentStream(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document != null && document.getDocumentElement() != null && this.accept(document);
    }

    @Override
    public boolean accept(FileStore fileStore, String string) {
        if (fileStore == null) {
            String string2 = Logging.getMessage("nullValue.FileStoreIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        URL uRL = fileStore.findFile(string, true);
        if (uRL == null) {
            return false;
        }
        File file = WWIO.convertURLToFile(uRL);
        if (file != null) {
            return this.accept(file);
        }
        return this.accept(uRL);
    }

    public boolean accept(Document document) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (document.getDocumentElement() == null) {
            String string = Logging.getMessage("nullValue.DocumentElementIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.accept(document.getDocumentElement());
    }

    public boolean accept(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return DataConfigurationUtils.isDataConfig(element);
    }

    protected boolean acceptFilePath(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.toLowerCase().endsWith(".xml");
    }
}

