/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MinimumSafeDistanceZones
extends AbstractMilStd2525TacticalGraphic
implements PreRenderable {
    public static final Angle DEFAULT_LABEL_ANGLE = Angle.fromDegrees(60.0);
    protected Iterable<? extends Position> positions;
    protected List<SurfaceCircle> rings;
    protected Angle labelAngle = DEFAULT_LABEL_ANGLE;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-M-NM---------");
    }

    public MinimumSafeDistanceZones(String string) {
        super(string);
    }

    public Angle getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.labelAngle = angle;
    }

    public Position getPosition() {
        return this.getReferencePosition();
    }

    public void setPosition(Position position) {
        this.moveTo(position);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            for (int i = 0; i < 3; ++i) {
                iterator.next();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.positions = iterable;
        this.rings = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    @Override
    public Position getReferencePosition() {
        Iterator<? extends Position> iterator;
        if (this.positions != null && (iterator = this.positions.iterator()).hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        if (this.rings == null) {
            this.createShapes(drawContext);
        }
        this.determineActiveAttributes();
        for (SurfaceCircle surfaceCircle : this.rings) {
            surfaceCircle.preRender(drawContext);
        }
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        for (SurfaceCircle surfaceCircle : this.rings) {
            surfaceCircle.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.rings == null) {
            return;
        }
        for (SurfaceCircle surfaceCircle : this.rings) {
            surfaceCircle.setDelegateOwner(object);
        }
    }

    protected void createShapes(DrawContext drawContext) {
        if (this.positions == null) {
            return;
        }
        this.rings = new ArrayList<SurfaceCircle>();
        Iterator<? extends Position> iterator = this.positions.iterator();
        Position position = iterator.next();
        double d = drawContext.getGlobe().getRadius();
        while (iterator.hasNext()) {
            SurfaceCircle surfaceCircle = this.createCircle();
            surfaceCircle.setCenter(position);
            Position position2 = iterator.next();
            Angle angle = LatLon.greatCircleDistance(position, position2);
            double d2 = angle.radians * d;
            surfaceCircle.setRadius(d2);
            this.rings.add(surfaceCircle);
        }
    }

    @Override
    protected void createLabels() {
        for (int i = 1; i <= this.rings.size(); ++i) {
            this.addLabel(String.valueOf(i));
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        double d = drawContext.getGlobe().getRadius();
        Angle angle = this.getLabelAngle();
        int n = 0;
        for (SurfaceCircle surfaceCircle : this.rings) {
            double d2 = surfaceCircle.getRadius();
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle.radians, d2 / d);
            ((TacticalGraphicLabel)this.labels.get(n)).setPosition(new Position(latLon, 0.0));
            ++n;
        }
    }

    protected SurfaceCircle createCircle() {
        SurfaceCircle surfaceCircle = new SurfaceCircle();
        surfaceCircle.setDelegateOwner(this.getActiveDelegateOwner());
        surfaceCircle.setAttributes(this.getActiveShapeAttributes());
        return surfaceCircle;
    }
}

