/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.symbology.AbstractIconRetriever;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525Util;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.MissingResourceException;

public class MilStd2525PointGraphicRetriever
extends AbstractIconRetriever {
    protected static final String PATH_SUFFIX = ".png";
    protected static final String DIR_ICON_TACGRP = "icons/tacgrp";
    protected static final String DIR_ICON_METOC = "icons/metoc";
    protected static final String DIR_ICON_EMS = "icons/ems";
    protected static final String DIR_FILL_TACGRP = "fills/tacgrp";

    public MilStd2525PointGraphicRetriever(String string) {
        super(string);
    }

    @Override
    public BufferedImage createIcon(String string, AVList aVList) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.SymbolCodeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        SymbolCode symbolCode = new SymbolCode(string);
        String string3 = this.composeFilename(symbolCode);
        BufferedImage bufferedImage = this.readImage(string3);
        if (bufferedImage == null) {
            String string4 = Logging.getMessage("Symbology.SymbolIconNotFound", symbolCode);
            Logging.logger().severe(string4);
            throw new MissingResourceException(string4, BufferedImage.class.getName(), string3);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 3);
        this.drawImage(bufferedImage, bufferedImage2);
        Color color = this.getColorFromParams(aVList);
        if (!"W".equalsIgnoreCase(symbolCode.getScheme())) {
            if (color == null) {
                color = this.getColorForStandardIdentity(symbolCode);
            }
            this.multiply(bufferedImage2, color);
            if (this.mustDrawFill(symbolCode)) {
                bufferedImage2 = this.composeFilledImage(bufferedImage2, symbolCode);
            }
        } else if (color != null) {
            this.replaceColor(bufferedImage2, color);
        }
        return bufferedImage2;
    }

    protected BufferedImage composeFilledImage(BufferedImage bufferedImage, SymbolCode symbolCode) {
        String string = this.composeFillPath(symbolCode);
        BufferedImage bufferedImage2 = this.readImage(string);
        if (bufferedImage2 == null) {
            String string2 = Logging.getMessage("Symbology.SymbolIconNotFound", symbolCode);
            Logging.logger().severe(string2);
            throw new MissingResourceException(string2, BufferedImage.class.getName(), string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 3);
        this.drawImage(bufferedImage2, bufferedImage3);
        this.drawImage(bufferedImage, bufferedImage3);
        return bufferedImage3;
    }

    protected boolean mustDrawFill(SymbolCode symbolCode) {
        String string = symbolCode.toMaskedString();
        return "G-M-NZ---------".equalsIgnoreCase(string) || "G-M-NEB--------".equalsIgnoreCase(string) || "G-M-NEC--------".equalsIgnoreCase(string);
    }

    protected Color getColorFromParams(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.Color");
        return object instanceof Color ? (Color)object : null;
    }

    protected Color getColorForStandardIdentity(SymbolCode symbolCode) {
        return MilStd2525Util.getDefaultGraphicMaterial(symbolCode).getDiffuse();
    }

    protected String composeFillPath(SymbolCode symbolCode) {
        return this.composeFilenameTacticalGraphic(symbolCode, DIR_FILL_TACGRP);
    }

    protected String composeFilename(SymbolCode symbolCode) {
        String string = symbolCode.getScheme();
        if ("G".equalsIgnoreCase(string)) {
            return this.composeFilenameTacticalGraphic(symbolCode, DIR_ICON_TACGRP);
        }
        if ("W".equalsIgnoreCase(string)) {
            return this.composeFilenameMetoc(symbolCode);
        }
        if ("E".equalsIgnoreCase(string)) {
            return this.composeFilenameEms(symbolCode);
        }
        return null;
    }

    protected String composeFilenameTacticalGraphic(SymbolCode symbolCode, String string) {
        char c;
        String string2 = symbolCode.getScheme();
        String string3 = symbolCode.getCategory();
        String string4 = symbolCode.getFunctionId();
        char c2 = c = "P".equalsIgnoreCase(symbolCode.getStatus()) ? (char)'p' : 'a';
        if (string4 == null) {
            string4 = "------";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("/").append(string2.toLowerCase()).append('-').append(string3.toLowerCase()).append(c).append(string4.toLowerCase()).append("-----").append(PATH_SUFFIX);
        return stringBuilder.toString();
    }

    protected String composeFilenameMetoc(SymbolCode symbolCode) {
        String string = symbolCode.getScheme();
        String string2 = symbolCode.getCategory();
        String string3 = symbolCode.getStaticDynamic();
        String string4 = symbolCode.getFunctionId();
        String string5 = symbolCode.getGraphicType();
        if (string4 == null) {
            string4 = "------";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DIR_ICON_METOC).append("/").append(string).append(string2).append(string3).append(string4).append(string5).append("--").append(PATH_SUFFIX);
        return stringBuilder.toString().toLowerCase();
    }

    protected String composeFilenameEms(SymbolCode symbolCode) {
        char c;
        String string = symbolCode.getScheme();
        String string2 = symbolCode.getCategory();
        String string3 = symbolCode.getFunctionId();
        char c2 = c = "P".equalsIgnoreCase(symbolCode.getStatus()) ? (char)'p' : 'a';
        if (string3 == null) {
            string3 = "------";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DIR_ICON_EMS).append("/").append(string.toLowerCase()).append('-').append(string2.toLowerCase()).append(c).append(string3.toLowerCase()).append("-----").append(PATH_SUFFIX);
        return stringBuilder.toString();
    }
}

