/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.AbstractBalloon;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.DrawContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public abstract class AbstractAnnotationBalloon
extends AbstractBalloon {
    public AbstractAnnotationBalloon(String string) {
        super(string);
    }

    @Override
    public Rectangle getBounds(DrawContext drawContext) {
        return this.getAnnotation().getBounds(drawContext);
    }

    protected abstract Annotation createAnnotation();

    protected abstract Annotation getAnnotation();

    protected abstract void computePosition(DrawContext var1);

    @Override
    public void render(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        this.determineActiveAttributes();
        this.applyAttributesToAnnotation();
        this.computePosition(drawContext);
        this.computeOffsets(drawContext);
        this.getAnnotation().render(drawContext);
    }

    protected void applyAttributesToAnnotation() {
        Annotation annotation = this.getAnnotation();
        Object object = this.getDelegateOwner();
        annotation.setDelegateOwner(object != null ? object : this);
        annotation.setAlwaysOnTop(this.isAlwaysOnTop());
        annotation.setPickEnabled(this.isPickEnabled());
        String string = this.getDecodedText();
        if (string != null) {
            annotation.setText(string);
        }
        annotation.setMinActiveAltitude(this.getMinActiveAltitude());
        annotation.setMaxActiveAltitude(this.getMaxActiveAltitude());
        AnnotationAttributes annotationAttributes = annotation.getAttributes();
        annotationAttributes.setHighlighted(this.isHighlighted());
        annotationAttributes.setVisible(this.isVisible());
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        if (balloonAttributes != null) {
            double d;
            Color color;
            annotationAttributes.setTextColor(balloonAttributes.getTextColor());
            annotationAttributes.setBorderWidth(balloonAttributes.getOutlineWidth());
            annotationAttributes.setBorderStippleFactor(balloonAttributes.getOutlineStippleFactor());
            annotationAttributes.setBorderStipplePattern(balloonAttributes.getOutlineStipplePattern());
            annotationAttributes.setCornerRadius(balloonAttributes.getCornerRadius());
            annotationAttributes.setLeader(balloonAttributes.getLeaderShape());
            annotationAttributes.setLeaderGapWidth(balloonAttributes.getLeaderWidth());
            annotationAttributes.setFont(balloonAttributes.getFont());
            annotationAttributes.setFrameShape(balloonAttributes.getBalloonShape());
            annotationAttributes.setInsets(balloonAttributes.getInsets());
            annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
            annotationAttributes.setAntiAliasHint(balloonAttributes.isEnableAntialiasing() ? 4354 : 4353);
            annotationAttributes.setImageSource(balloonAttributes.getImageSource());
            annotationAttributes.setImageOffset(balloonAttributes.getImageOffset());
            annotationAttributes.setImageOpacity(balloonAttributes.getImageOpacity());
            annotationAttributes.setImageRepeat(balloonAttributes.getImageRepeat());
            annotationAttributes.setImageScale(balloonAttributes.getImageScale());
            if (balloonAttributes.isDrawInterior() && balloonAttributes.getInteriorOpacity() > 0.0) {
                color = balloonAttributes.getInteriorMaterial().getDiffuse();
                d = balloonAttributes.getInteriorOpacity();
                annotationAttributes.setBackgroundColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
            } else {
                annotationAttributes.setBackgroundColor(new Color(0, 0, 0, 0));
            }
            if (balloonAttributes.isDrawOutline() && balloonAttributes.getOutlineOpacity() > 0.0) {
                color = balloonAttributes.getOutlineMaterial().getDiffuse();
                d = balloonAttributes.getOutlineOpacity();
                annotationAttributes.setBorderColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
            } else {
                annotationAttributes.setBorderColor(new Color(0, 0, 0, 0));
            }
        }
        annotation.setAttributes(annotationAttributes);
    }

    protected void computeOffsets(DrawContext drawContext) {
        Annotation annotation = this.getAnnotation();
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        AnnotationAttributes annotationAttributes = annotation.getAttributes();
        if (balloonAttributes != null) {
            Dimension dimension = annotation.getPreferredSize(drawContext);
            Rectangle rectangle = drawContext.getView().getViewport();
            Dimension dimension2 = balloonAttributes.getSize().compute(dimension.width, dimension.height, rectangle.width, rectangle.height);
            Point2D.Double double_ = balloonAttributes.getOffset().computeOffset(dimension2.width, dimension2.height, 1.0, 1.0);
            annotationAttributes.setSize(dimension2);
            annotationAttributes.setDrawOffset(new Point((int)(-double_.x) + dimension2.width / 2, (int)(-double_.y)));
        }
    }
}

