/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.ogc.OGCAddress;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OGCContactInformation
extends AbstractXMLEventParser {
    protected QName CONTACT_POSITION;
    protected QName CONTACT_VOICE_TELEPHONE;
    protected QName CONTACT_FACSIMILE_TELEPHONE;
    protected QName CONTACT_ELECTRONIC_MAIL_ADDRESS;
    protected QName CONTACT_PERSON_PRIMARY;
    protected QName CONTACT_ADDRESS;
    protected QName CONTACT_PERSON;
    protected QName CONTACT_ORGANIZATION;
    protected String personPrimary;
    protected String organization;
    protected String position;
    protected String voiceTelephone;
    protected String facsimileTelephone;
    protected String electronicMailAddress;
    protected OGCAddress contactAddress;

    public OGCContactInformation(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.CONTACT_POSITION = new QName(this.getNamespaceURI(), "ContactPosition");
        this.CONTACT_VOICE_TELEPHONE = new QName(this.getNamespaceURI(), "ContactVoiceTelephone");
        this.CONTACT_FACSIMILE_TELEPHONE = new QName(this.getNamespaceURI(), "ContactFacsimileTelephone");
        this.CONTACT_ELECTRONIC_MAIL_ADDRESS = new QName(this.getNamespaceURI(), "ContactElectronicMailAddress");
        this.CONTACT_PERSON_PRIMARY = new QName(this.getNamespaceURI(), "ContactPersonPrimary");
        this.CONTACT_ADDRESS = new QName(this.getNamespaceURI(), "ContactAddress");
        this.CONTACT_PERSON = new QName(this.getNamespaceURI(), "ContactPerson");
        this.CONTACT_ORGANIZATION = new QName(this.getNamespaceURI(), "ContactOrganization");
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        OGCAddress oGCAddress = null;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_ADDRESS)) {
            oGCAddress = new OGCAddress(this.getNamespaceURI());
        }
        return xMLEventParserContext.allocate(xMLEvent, oGCAddress);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_POSITION)) {
            this.setPosition(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_VOICE_TELEPHONE)) {
            this.setVoiceTelephone(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_FACSIMILE_TELEPHONE)) {
            this.setFacsimileTelephone(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_ELECTRONIC_MAIL_ADDRESS)) {
            this.setElectronicMailAddress(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_PERSON_PRIMARY)) {
            String[] stringArray = this.parseContactPersonPrimary(xMLEventParserContext, xMLEvent);
            this.setPersonPrimary(stringArray[0]);
            this.setOrganization(stringArray[1]);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_ADDRESS) && (xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent)) != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OGCAddress) {
            this.setContactAddress((OGCAddress)object);
        }
    }

    protected String[] parseContactPersonPrimary(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) throws XMLStreamException {
        String[] stringArray = new String[2];
        XMLEvent xMLEvent2 = xMLEventParserContext.nextEvent();
        while (xMLEvent2 != null) {
            if (xMLEventParserContext.isEndElement(xMLEvent2, xMLEvent)) {
                return stringArray;
            }
            if (xMLEventParserContext.isStartElement(xMLEvent2, this.CONTACT_PERSON)) {
                stringArray[0] = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent2, new Object[0]);
            } else if (xMLEventParserContext.isStartElement(xMLEvent2, this.CONTACT_ORGANIZATION)) {
                stringArray[1] = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent2, new Object[0]);
            }
            xMLEvent2 = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    public String getPersonPrimary() {
        return this.personPrimary;
    }

    protected void setPersonPrimary(String string) {
        this.personPrimary = string;
    }

    public String getOrganization() {
        return this.organization;
    }

    protected void setOrganization(String string) {
        this.organization = string;
    }

    public String getPosition() {
        return this.position;
    }

    protected void setPosition(String string) {
        this.position = string;
    }

    public String getVoiceTelephone() {
        return this.voiceTelephone;
    }

    protected void setVoiceTelephone(String string) {
        this.voiceTelephone = string;
    }

    public String getFacsimileTelephone() {
        return this.facsimileTelephone;
    }

    protected void setFacsimileTelephone(String string) {
        this.facsimileTelephone = string;
    }

    public String getElectronicMailAddress() {
        return this.electronicMailAddress;
    }

    protected void setElectronicMailAddress(String string) {
        this.electronicMailAddress = string;
    }

    public OGCAddress getContactAddress() {
        return this.contactAddress;
    }

    protected void setContactAddress(OGCAddress oGCAddress) {
        this.contactAddress = oGCAddress;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PersonPrimary: ").append(this.personPrimary != null ? this.personPrimary : "none").append("\n");
        stringBuilder.append("Organization: ").append(this.organization != null ? this.organization : "none").append("\n");
        stringBuilder.append("Position: ").append(this.position != null ? this.position : "none").append("\n");
        stringBuilder.append("VoiceTelephone: ").append(this.voiceTelephone != null ? this.voiceTelephone : "none").append("\n");
        stringBuilder.append("FacsimileTelephone: ").append(this.facsimileTelephone != null ? this.facsimileTelephone : "none").append("\n");
        stringBuilder.append("ElectronicMailAddress: ").append(this.electronicMailAddress != null ? this.electronicMailAddress : "none").append("\n");
        stringBuilder.append(this.contactAddress != null ? this.contactAddress : "none");
        return stringBuilder.toString();
    }
}

