/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

import gov.nasa.worldwind.util.Logging;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class FileChooserPanel
extends JPanel {
    private JLabel title;
    private JLabel description;
    private JFormattedTextField fileField;
    private JButton chooseButton;
    private JFileChooser fileChooser;

    public FileChooserPanel() {
        this.makeComponents();
        this.layoutComponents();
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String string) {
        this.title.setText(string);
    }

    public String getDescription() {
        return this.description.getText();
    }

    public void setDescription(String string) {
        this.description.setText(string);
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setFileChooser(JFileChooser jFileChooser) {
        if (jFileChooser == null) {
            String string = "JFileChooser is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.fileChooser = jFileChooser;
    }

    public File getSelectedFile() {
        return this.getValueAsFile(this.fileField.getValue());
    }

    private File getValueAsFile(Object object) {
        if (object != null) {
            if (object instanceof File) {
                return (File)object;
            }
            return new File(object.toString());
        }
        return null;
    }

    public void promptForNewSelection() {
        this.onChooseClicked();
    }

    private void onChooseClicked() {
        int n = this.fileChooser.showDialog(this, "Choose");
        if (n == 0 && this.fileChooser.getSelectedFile() != null) {
            this.fileField.setValue(this.fileChooser.getSelectedFile());
        }
    }

    private void onFileFieldChanged(Object object) {
        File file = this.getValueAsFile(object);
        this.firePropertyChange("selectedFile", null, file);
    }

    private void makeComponents() {
        this.title = new JLabel(" ");
        this.title.setBackground(Color.gray);
        this.title.setOpaque(true);
        this.description = new JLabel();
        this.fileField = new JFormattedTextField((Object)"Click 'Choose...'");
        Font font = this.fileField.getFont();
        if (!font.isBold()) {
            font = new Font(font.getName(), 1 | font.getStyle(), font.getSize());
        }
        this.fileField.setFont(font);
        Dimension dimension = this.fileField.getPreferredSize();
        Dimension dimension2 = this.fileField.getMaximumSize();
        this.fileField.setMaximumSize(new Dimension(dimension2.width, dimension.height));
        this.fileField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent != null) {
                    FileChooserPanel.this.onFileFieldChanged(propertyChangeEvent.getNewValue());
                }
            }
        });
        this.chooseButton = new JButton("Choose...");
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserPanel.this.onChooseClicked();
            }
        });
        this.fileChooser = new JFileChooser();
        this.fileChooser.setDialogTitle("Choose Folder to Search");
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(false);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(this.title.getBackground());
        this.title.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.title, "West");
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, "South");
        this.add((Component)jPanel, "North");
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.description.setAlignmentX(0.0f);
        box.add(this.description);
        box.add(Box.createVerticalStrut(10));
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        box2.add(this.fileField);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.chooseButton);
        box.add(box2);
        box.add(Box.createVerticalStrut(Short.MAX_VALUE));
        this.add((Component)box, "Center");
    }
}

