/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.wvt;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;

public class WaveletCodec {
    private final int type;
    private final int resolutionX;
    private final int resolutionY;
    private byte[][] xform;
    public static final int TYPE_BYTE_GRAY = 1735549305;
    public static final int TYPE_3BYTE_BGR = 1919377952;
    public static final int TYPE_4BYTE_ARGB = 1634887522;
    public static final String WVT_EXT = ".wvt";

    private WaveletCodec(int n, int n2, int n3) {
        if (!WaveletCodec.isTypeValid(n)) {
            String string = "Invalid type: " + n;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.type = n;
        this.resolutionX = n2;
        this.resolutionY = n3;
    }

    public final int getType() {
        return this.type;
    }

    public final int getResolutionX() {
        return this.resolutionX;
    }

    public final int getResolutionY() {
        return this.resolutionY;
    }

    public BufferedImage reconstruct(int n) throws IllegalArgumentException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.xform.length;
        int[][] nArray = new int[n7][this.resolutionX * this.resolutionY];
        byte[][] byArray = new byte[n7][this.resolutionX * this.resolutionY];
        int n8 = n / 2 * (n / 2);
        int[][] nArray2 = new int[n7][n8];
        int[][] nArray3 = new int[n7][n8];
        int[][] nArray4 = new int[n7][n8];
        int[][] nArray5 = new int[n7][n8];
        for (n6 = 0; n6 < n7; ++n6) {
            nArray[n6][0] = 0xFF & this.xform[n6][0];
        }
        n6 = 1;
        int n9 = 1;
        while ((n5 = n6 * n6) < n * n) {
            int n10;
            n4 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = 0;
                while (n2 < n6) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        nArray2[n10][n4] = nArray[n10][n3 * n + n2];
                    }
                    ++n2;
                    ++n4;
                }
            }
            n3 = 0;
            while (n3 < n5) {
                for (n2 = 0; n2 < n7; ++n2) {
                    nArray5[n2][n3] = this.xform[n2][n9];
                }
                ++n3;
                ++n9;
            }
            n3 = 0;
            while (n3 < n5) {
                for (n2 = 0; n2 < n7; ++n2) {
                    nArray4[n2][n3] = this.xform[n2][n9];
                }
                ++n3;
                ++n9;
            }
            n3 = 0;
            while (n3 < n5) {
                for (n2 = 0; n2 < n7; ++n2) {
                    nArray3[n2][n3] = this.xform[n2][n9];
                }
                ++n3;
                ++n9;
            }
            n4 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = 0;
                while (n2 < n6) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        int n11 = nArray2[n10][n4] + nArray5[n10][n4] + nArray4[n10][n4] + nArray3[n10][n4];
                        int n12 = nArray2[n10][n4] - nArray5[n10][n4] + nArray4[n10][n4] - nArray3[n10][n4];
                        int n13 = nArray2[n10][n4] + nArray5[n10][n4] - nArray4[n10][n4] - nArray3[n10][n4];
                        int n14 = nArray2[n10][n4] - nArray5[n10][n4] - nArray4[n10][n4] + nArray3[n10][n4];
                        nArray[n10][2 * n3 * n + n2 * 2] = n11;
                        nArray[n10][2 * n3 * n + n2 * 2 + 1] = n12;
                        nArray[n10][2 * n3 * n + n + n2 * 2] = n13;
                        nArray[n10][2 * n3 * n + n + n2 * 2 + 1] = n14;
                    }
                    ++n2;
                    ++n4;
                }
            }
            if ((n6 *= 2) < n) continue;
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < n7; ++n3) {
                    byArray[n3][n5 * n + n4] = (byte)Math.max(0, Math.min(255, nArray[n3][n5 * n + n4]));
                }
            }
        }
        BandedSampleModel bandedSampleModel = new BandedSampleModel(0, n, n, n7);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray[0].length);
        WritableRaster writableRaster = Raster.createWritableRaster(bandedSampleModel, dataBufferByte, new Point(0, 0));
        n2 = WaveletCodec.getBufferedImageType(this);
        BufferedImage bufferedImage = new BufferedImage(n, n, n2);
        bufferedImage.getRaster().setRect(writableRaster);
        return bufferedImage;
    }

    public static ByteBuffer save(WaveletCodec waveletCodec) throws IOException {
        if (waveletCodec == null) {
            String string = "WaveletCodec is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 16;
        for (int i = 0; i < waveletCodec.xform.length; ++i) {
            n += waveletCodec.xform[i].length * 8 / 8;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putInt(waveletCodec.resolutionX);
        byteBuffer.putInt(waveletCodec.resolutionY);
        byteBuffer.putInt(waveletCodec.type);
        byteBuffer.putInt(waveletCodec.xform.length);
        for (int i = 0; i < waveletCodec.xform.length; ++i) {
            byteBuffer.put(waveletCodec.xform[i], 0, waveletCodec.xform[i].length);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private static boolean isTypeValid(int n) {
        return n == 1735549305 || n == 1919377952 || n == 1634887522;
    }

    private static int getBufferedImageType(WaveletCodec waveletCodec) {
        if (waveletCodec == null) {
            String string = "WaveletCodec is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        switch (waveletCodec.type) {
            case 1735549305: {
                n = 10;
                break;
            }
            case 1919377952: {
                n = 5;
                break;
            }
            case 1634887522: {
                n = 6;
            }
        }
        return n;
    }

    private static int getWaveletType(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = "BufferedImage is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        switch (bufferedImage.getType()) {
            case 10: {
                n = 1735549305;
                break;
            }
            case 5: {
                n = 1919377952;
                break;
            }
            case 6: {
                n = 1634887522;
            }
        }
        return n;
    }

    public static WaveletCodec load(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        if (!WaveletCodec.isTypeValid(n3)) {
            throw new IllegalArgumentException("WaveletCodec.loadFully(): invalid encoding type");
        }
        int n4 = byteBuffer.getInt();
        byte[][] byArray = new byte[n4][n * n2];
        for (int i = 0; i < n4; ++i) {
            byteBuffer.get(byArray[i], 0, byArray[i].length);
        }
        WaveletCodec waveletCodec = new WaveletCodec(n3, n, n2);
        waveletCodec.xform = byArray;
        return waveletCodec;
    }

    public static WaveletCodec loadPartial(ByteBuffer byteBuffer, int n) throws IOException {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        if (n > n2 || n > n3) {
            throw new IllegalArgumentException("WaveletCodec.loadPartially(): input resolution greater than encoded image");
        }
        int n4 = byteBuffer.getInt();
        if (!WaveletCodec.isTypeValid(n4)) {
            throw new IllegalArgumentException("WaveletCodec.loadPartially(): invalid encoding type");
        }
        int n5 = byteBuffer.getInt();
        byte[][] byArray = new byte[n5][n * n];
        for (int i = 0; i < n5; ++i) {
            byteBuffer.position(16 + i * (n2 * n3));
            byteBuffer.get(byArray[i], 0, byArray[i].length);
        }
        WaveletCodec waveletCodec = new WaveletCodec(n4, n2, n3);
        waveletCodec.xform = byArray;
        return waveletCodec;
    }

    public static WaveletCodec encode(BufferedImage bufferedImage) throws IllegalArgumentException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bufferedImage == null) {
            throw new IllegalArgumentException("WaveletCodec.encode: null image");
        }
        int n7 = bufferedImage.getWidth();
        int n8 = bufferedImage.getHeight();
        if (!WWMath.isPowerOfTwo(n7) || !WWMath.isPowerOfTwo(n8)) {
            throw new IllegalArgumentException("Image dimensions are not a power of 2");
        }
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int n9 = sampleModel.getNumBands();
        if (n9 != 1 && n9 != 3 && n9 != 4 || sampleModel.getDataType() != 0) {
            throw new IllegalArgumentException("Image is not of BYTE type, or not recognized as grayscale, RGB, or ARGB");
        }
        int n10 = WaveletCodec.getWaveletType(bufferedImage);
        if (!WaveletCodec.isTypeValid(n10)) {
            throw new IllegalArgumentException("Image is not recognized as grayscale, RGB, or ARGB");
        }
        int n11 = n7 * n8;
        WritableRaster writableRaster = bufferedImage.getRaster();
        float[][] fArray = new float[n9][n11];
        for (int i = 0; i < n9; ++i) {
            writableRaster.getSamples(0, 0, n7, n8, i, fArray[i]);
        }
        float[][] fArray2 = new float[n9][n11];
        int n12 = 0;
        int n13 = n7;
        int n14 = n8;
        block1: while (true) {
            float f;
            ++n12;
            if (n13 <= 0 && n14 <= 0) break;
            int n15 = n13 / 2;
            n6 = n14 / 2;
            for (n5 = 0; n5 < n14; ++n5) {
                n4 = n5 * n8;
                for (n3 = 0; n3 < n15; ++n3) {
                    n2 = n4 + n3 * 2;
                    n = n4 + n3 * 2 + 1;
                    for (int i = 0; i < n9; ++i) {
                        f = (fArray[i][n2] + fArray[i][n]) / 2.0f;
                        float f2 = fArray[i][n2] - f;
                        fArray2[i][n4 + n3] = f;
                        fArray2[i][n4 + n3 + n15] = f2;
                    }
                }
            }
            for (n5 = 0; n5 < n9; ++n5) {
                System.arraycopy(fArray2[n5], 0, fArray[n5], 0, fArray2[n5].length);
            }
            for (n5 = 0; n5 < n13; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    n3 = n5 + n4 * 2 * n8;
                    n2 = n5 + (n4 * 2 + 1) * n8;
                    for (n = 0; n < n9; ++n) {
                        float f3 = (fArray[n][n3] + fArray[n][n2]) / 2.0f;
                        f = fArray[n][n3] - f3;
                        fArray2[n][n5 + n4 * n8] = f3;
                        fArray2[n][n5 + (n4 + n6) * n8] = f;
                    }
                }
            }
            n13 /= 2;
            n14 /= 2;
            n5 = 0;
            while (true) {
                if (n5 >= n9) continue block1;
                System.arraycopy(fArray2[n5], 0, fArray[n5], 0, fArray2[n5].length);
                ++n5;
            }
            break;
        }
        WaveletCodec waveletCodec = new WaveletCodec(n10, n7, n8);
        waveletCodec.xform = new byte[n9][n11];
        for (n6 = 0; n6 < n9; ++n6) {
            waveletCodec.xform[n6][0] = (byte)Math.min(255, Math.max(0, Math.round(fArray[n6][0])));
        }
        n5 = 1;
        for (n6 = 1; n6 < n7; n6 *= 2) {
            for (n4 = 0; n4 < 3; ++n4) {
                n3 = n4 % 2 == 0 ? n6 : 0;
                n2 = n4 > 0 ? n6 * n7 : 0;
                for (n = 0; n < n6; ++n) {
                    int n16 = 0;
                    while (n16 < n6) {
                        int n17 = n2 + n3 + n * n7 + n16;
                        for (int i = 0; i < n9; ++i) {
                            waveletCodec.xform[i][n5] = (byte)Math.max(-128, Math.min(127, Math.round(fArray[i][n17])));
                        }
                        ++n16;
                        ++n5;
                    }
                }
            }
        }
        return waveletCodec;
    }
}

