/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFFeatureType;
import gov.nasa.worldwind.formats.vpf.VPFSymbol;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.formats.vpf.VPFSymbolKey;
import gov.nasa.worldwind.util.Logging;
import java.util.Comparator;

public class VPFSymbolComparator
implements Comparator<VPFSymbol> {
    @Override
    public int compare(VPFSymbol vPFSymbol, VPFSymbol vPFSymbol2) {
        VPFSymbolKey vPFSymbolKey;
        int n;
        double d;
        if (vPFSymbol == null || vPFSymbol2 == null) {
            String string = Logging.getMessage("nullValue.SymbolIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        VPFSymbolAttributes vPFSymbolAttributes = vPFSymbol.getAttributes();
        VPFSymbolAttributes vPFSymbolAttributes2 = vPFSymbol2.getAttributes();
        if (vPFSymbolAttributes == null && vPFSymbolAttributes2 == null) {
            return 0;
        }
        if (vPFSymbolAttributes == null || vPFSymbolAttributes2 == null) {
            return vPFSymbolAttributes != null ? -1 : 1;
        }
        double d2 = vPFSymbol.getAttributes().getDisplayPriority();
        int n2 = d2 < (d = vPFSymbol2.getAttributes().getDisplayPriority()) ? -1 : (n = d2 > d ? 1 : 0);
        if (n != 0) {
            return n;
        }
        d2 = this.getFeatureTypePriority(vPFSymbol.getAttributes().getFeatureType());
        int n3 = d2 < (d = (double)this.getFeatureTypePriority(vPFSymbol2.getAttributes().getFeatureType())) ? -1 : (n = d2 > d ? 1 : 0);
        if (n != 0) {
            return n;
        }
        VPFSymbolKey vPFSymbolKey2 = vPFSymbol.getAttributes().getSymbolKey();
        n = vPFSymbolKey2.compareTo(vPFSymbolKey = vPFSymbol2.getAttributes().getSymbolKey());
        if (n != 0) {
            return n;
        }
        return 0;
    }

    protected int getFeatureTypePriority(VPFFeatureType vPFFeatureType) {
        switch (vPFFeatureType) {
            case POINT: {
                return 3;
            }
            case LINE: {
                return 2;
            }
            case AREA: {
                return 1;
            }
        }
        return 0;
    }
}

