/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFDatabase;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileFilter;

public class VPFDatabaseFilter
implements FileFilter {
    @Override
    public boolean accept(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.acceptFilePath(file)) {
            return false;
        }
        try {
            return VPFDatabase.isDatabase(file.getPath());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean acceptFilePath(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return file.getName().equalsIgnoreCase("dht");
    }
}

