/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;

public class VPFBoundingBox {
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;

    public VPFBoundingBox(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.ymin = d2;
        this.xmax = d3;
        this.ymax = d4;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmax() {
        return this.ymax;
    }

    public Sector toSector() {
        return Sector.fromDegrees(this.ymin, this.ymax, this.xmin, this.xmax);
    }

    public VPFBoundingBox union(VPFBoundingBox vPFBoundingBox) {
        if (vPFBoundingBox == null) {
            String string = Logging.getMessage("nullValue.BoundingBoxIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new VPFBoundingBox(this.xmin < vPFBoundingBox.xmin ? this.xmin : vPFBoundingBox.xmin, this.ymin < vPFBoundingBox.ymin ? this.ymin : vPFBoundingBox.ymin, this.xmax > vPFBoundingBox.xmax ? this.xmax : vPFBoundingBox.xmax, this.ymax > vPFBoundingBox.ymax ? this.ymax : vPFBoundingBox.ymax);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("xmin=").append(this.xmin).append(", ");
        stringBuilder.append("ymin=").append(this.ymin).append(", ");
        stringBuilder.append("xmax=").append(this.xmax).append(", ");
        stringBuilder.append("ymax=").append(this.ymax);
        return stringBuilder.toString();
    }

    public static VPFBoundingBox fromVecBuffer(VecBuffer vecBuffer) {
        if (vecBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vecBuffer.getCoordsPerVec() < 2) {
            String string = Logging.getMessage("generic.BufferIncompatible", vecBuffer);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        int n = vecBuffer.getSize();
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            vecBuffer.get(i, dArray);
            if (d > dArray[0]) {
                d = dArray[0];
            }
            if (d3 < dArray[0]) {
                d3 = dArray[0];
            }
            if (d2 > dArray[1]) {
                d2 = dArray[1];
            }
            if (!(d4 < dArray[1])) continue;
            d4 = dArray[1];
        }
        return new VPFBoundingBox(d, d2, d3, d4);
    }
}

