/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.shapefile.DBaseRecord;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.CompoundVecBuffer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class ShapefileRecord {
    protected Shapefile shapeFile;
    protected int recordNumber;
    protected int contentLengthInBytes;
    protected String shapeType;
    protected DBaseRecord attributes;
    protected int numberOfParts;
    protected int numberOfPoints;
    protected int firstPartNumber;
    protected boolean normalizePoints;
    protected static final int RECORD_HEADER_LENGTH = 8;
    protected static List<String> measureTypes = new ArrayList<String>(Arrays.asList("gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePointM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePointZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPointM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPointZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolylineM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolylineZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygonM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygonZ"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapefileRecord(Shapefile shapefile, ByteBuffer byteBuffer) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = byteBuffer.position();
        try {
            this.readFromBuffer(shapefile, byteBuffer);
        }
        finally {
            byteBuffer.position(n + this.contentLengthInBytes + 8);
        }
    }

    public Shapefile getShapeFile() {
        return this.shapeFile;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public DBaseRecord getAttributes() {
        return this.attributes;
    }

    public void setAttributes(DBaseRecord dBaseRecord) {
        this.attributes = dBaseRecord;
    }

    public int getNumberOfParts() {
        return this.numberOfParts;
    }

    public int getFirstPartNumber() {
        return this.firstPartNumber;
    }

    public int getLastPartNumber() {
        return this.firstPartNumber + this.numberOfParts - 1;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public int getNumberOfPoints(int n) {
        if (n < 0 || n >= this.getNumberOfParts()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.getFirstPartNumber() + n;
        return this.getShapeFile().getPointBuffer().subBufferSize(n2);
    }

    public VecBuffer getPointBuffer(int n) {
        if (n < 0 || n >= this.getNumberOfParts()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.getFirstPartNumber() + n;
        return this.getShapeFile().getPointBuffer().subBuffer(n2);
    }

    public CompoundVecBuffer getCompoundPointBuffer() {
        return this.getShapeFile().getPointBuffer().slice(this.getFirstPartNumber(), this.getLastPartNumber());
    }

    protected abstract void doReadFromBuffer(Shapefile var1, ByteBuffer var2);

    protected void readFromBuffer(Shapefile shapefile, ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.recordNumber = byteBuffer.getInt();
        this.contentLengthInBytes = byteBuffer.getInt() * 2;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        String string = shapefile.getShapeType(n);
        this.validateShapeType(shapefile, string);
        this.shapeType = string;
        this.shapeFile = shapefile;
        this.doReadFromBuffer(shapefile, byteBuffer);
    }

    protected void validateShapeType(Shapefile shapefile, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!string.equals(shapefile.getShapeType()) && !string.equals("gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeNull")) {
            String string3 = Logging.getMessage("SHP.UnsupportedShapeType", string);
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3);
        }
    }

    protected boolean isMeasureType() {
        return Shapefile.isMeasureType(this.getShapeType());
    }

    protected boolean isZType() {
        return Shapefile.isZType(this.getShapeType());
    }

    public boolean isNormalizePoints() {
        return this.normalizePoints;
    }

    public void setNormalizePoints(boolean bl) {
        this.normalizePoints = bl;
    }

    public void exportAsXML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        if (xMLStreamWriter == null) {
            String string = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        xMLStreamWriter.writeStartElement("Record");
        xMLStreamWriter.writeAttribute("id", Integer.toString(this.getRecordNumber()));
        xMLStreamWriter.writeAttribute("shape", this.getShapeType().substring(this.getShapeType().lastIndexOf("Shape") + 5));
        xMLStreamWriter.writeAttribute("parts", Integer.toString(this.getNumberOfParts()));
        xMLStreamWriter.writeAttribute("points", Integer.toString(this.getNumberOfPoints()));
        xMLStreamWriter.writeCharacters("\n");
        for (Map.Entry<String, Object> object : this.getAttributes().getEntries()) {
            xMLStreamWriter.writeStartElement("Attribute");
            xMLStreamWriter.writeAttribute("name", object.getKey() != null ? object.getKey().toString() : "");
            xMLStreamWriter.writeAttribute("value", object.getValue() != null ? object.getValue().toString() : "");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
        }
        if (this.getNumberOfParts() > 0) {
            VecBuffer vecBuffer = this.getPointBuffer(0);
            for (LatLon latLon : vecBuffer.getLocations()) {
                xMLStreamWriter.writeStartElement("Point");
                xMLStreamWriter.writeAttribute("x", Double.toString(latLon.getLatitude().degrees));
                xMLStreamWriter.writeAttribute("y", Double.toString(latLon.getLongitude().degrees));
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeCharacters("\n");
            }
        }
        xMLStreamWriter.writeEndElement();
    }

    public void exportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
    }

    public void printInfo(boolean bl) {
        System.out.printf("%d, %s: %d parts, %d points", this.getRecordNumber(), this.getShapeType(), this.getNumberOfParts(), this.getNumberOfPoints());
        for (Map.Entry<String, Object> entry : this.getAttributes().getEntries()) {
            if (entry.getKey() != null) {
                System.out.printf(", %s", entry.getKey());
            }
            if (entry.getValue() == null) continue;
            System.out.printf(", %s", entry.getValue());
        }
        System.out.println();
        System.out.print("\tAttributes: ");
        for (Map.Entry<String, Object> entry : this.getAttributes().getEntries()) {
            System.out.printf("%s = %s, ", entry.getKey(), entry.getValue());
        }
        System.out.println();
        if (!bl) {
            return;
        }
        VecBuffer vecBuffer = this.getPointBuffer(0);
        for (LatLon latLon : vecBuffer.getLocations()) {
            System.out.printf("\t%f, %f\n", latLon.getLatitude().degrees, latLon.getLongitude().degrees);
        }
    }
}

