/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

public class NITFSUtil {
    private static final int PAGE_SIZE = 4096;

    public static String getString(ByteBuffer byteBuffer, int n, int n2) {
        String string = "";
        if (null != byteBuffer && byteBuffer.capacity() >= n + n2) {
            byte[] byArray = new byte[n2];
            byteBuffer.position(n);
            byteBuffer.get(byArray, 0, n2);
            string = new String(byArray).trim();
        }
        return string;
    }

    public static String getString(ByteBuffer byteBuffer, int n) {
        String string = "";
        if (null != byteBuffer && byteBuffer.remaining() >= n) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            string = new String(byArray).trim();
        }
        return string;
    }

    public static int getNumeric(ByteBuffer byteBuffer, int n) {
        String string = "";
        if (null != byteBuffer && byteBuffer.remaining() >= n) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            string = new String(byArray);
        }
        return Integer.parseInt(string);
    }

    public static short getShortNumeric(ByteBuffer byteBuffer, int n) {
        String string = "";
        if (null != byteBuffer && byteBuffer.remaining() >= n) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            string = new String(byArray);
        }
        return (short)(0xFFFF & Integer.parseInt(string));
    }

    public static boolean getBoolean(ByteBuffer byteBuffer) {
        return 0 != byteBuffer.get();
    }

    public static short getByteAsShort(ByteBuffer byteBuffer) {
        return (short)(0xFF & byteBuffer.get());
    }

    public static int getUShort(ByteBuffer byteBuffer) {
        return 0xFFFF & byteBuffer.getShort();
    }

    public static long getUInt(ByteBuffer byteBuffer) {
        return 0xFFFFFFFFL & (long)byteBuffer.getInt();
    }

    public static String getBitString(ByteBuffer byteBuffer, int n) {
        String string = "";
        int n2 = (int)Math.ceil((double)n / 8.0);
        if (null != byteBuffer && byteBuffer.remaining() >= n2) {
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray, 0, n2);
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                int n3 = 1 << 8 - i % 8 - 1;
                cArray[i] = (n3 & byArray[i / 8]) == 0 ? 48 : 49;
            }
            string = new String(cArray);
        }
        return string;
    }

    public static ByteBuffer readEntireFile(File file) throws IOException {
        return NITFSUtil.readFileToBuffer(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer readFileToBuffer(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            int n = 0;
            while (n >= 0 && byteBuffer.hasRemaining()) {
                n = fileChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            fileInputStream.close();
        }
    }

    private static ByteBuffer readFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        ReadableByteChannel readableByteChannel = Channels.newChannel(fileInputStream);
        int n = 0;
        while (n >= 0) {
            n = readableByteChannel.read(byteBuffer);
            if (n <= 0 || byteBuffer.hasRemaining()) continue;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.limit() + 4096);
            byteBuffer2.put((ByteBuffer)byteBuffer.rewind());
            byteBuffer = byteBuffer2;
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    private static ByteBuffer memoryMapFile(File file) throws IOException {
        long l;
        FileChannel fileChannel = new RandomAccessFile(file, "r").getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l = fileChannel.size());
        if (!mappedByteBuffer.isLoaded()) {
            mappedByteBuffer.load();
        }
        fileChannel.close();
        return mappedByteBuffer;
    }
}

