/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.Color24;
import gov.nasa.worldwind.formats.dds.DXTDecompressor;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;

public class DXT1Decompressor
implements DXTDecompressor {
    public static final int DXT1_BLOCK_SIZE = 4;

    @Override
    public BufferedImage decompress(ByteBuffer byteBuffer, int n, int n2) throws IOException, IllegalArgumentException {
        if (null == byteBuffer) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 0 || n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidImageSize", n, n2);
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        return this.decodeDxt1Buffer(byteBuffer, n, n2);
    }

    protected BufferedImage decodeDxt1Buffer(ByteBuffer byteBuffer, int n, int n2) throws IllegalArgumentException, IOException {
        if (null == byteBuffer) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 4 || n2 < 4) {
            String string = Logging.getMessage("generic.InvalidImageSize", n, n2);
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        try {
            if (byteBuffer.order() != ByteOrder.LITTLE_ENDIAN) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int n3 = n / 4;
            int n4 = n2 / 4;
            int[] nArray = new int[4 * n];
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    short s = byteBuffer.getShort();
                    short s2 = byteBuffer.getShort();
                    int n5 = byteBuffer.getInt();
                    Color24[] color24Array = Color24.expandLookupTable(s, s2);
                    for (int k = 15; k >= 0; --k) {
                        int n6 = k / 4;
                        int n7 = k % 4;
                        int n8 = n6 * n + (j * 4 + n7);
                        int n9 = n5 >>> k * 2 & 3;
                        nArray[n8] = color24Array[n9].getPixel888();
                    }
                }
                bufferedImage.setRGB(0, i * 4, n, 4, nArray, 0, n);
            }
            return bufferedImage;
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            string = null == string ? throwable.getCause().getMessage() : string;
            Logging.logger().log(Level.FINEST, string, throwable);
            return null;
        }
    }
}

