/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.AbstractDataRasterWriter;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DDSRasterWriter
extends AbstractDataRasterWriter {
    protected static final String[] ddsMimeTypes = new String[]{"image/dds"};
    protected static final String[] ddsSuffixes = new String[]{"dds"};

    public DDSRasterWriter() {
        super(ddsMimeTypes, ddsSuffixes);
    }

    @Override
    protected boolean doCanWrite(DataRaster dataRaster, String string, File file) {
        return dataRaster != null && dataRaster instanceof BufferedImageRaster;
    }

    @Override
    protected void doWrite(DataRaster dataRaster, String string, File file) throws IOException {
        BufferedImageRaster bufferedImageRaster = (BufferedImageRaster)dataRaster;
        BufferedImage bufferedImage = bufferedImageRaster.getBufferedImage();
        ByteBuffer byteBuffer = DDSCompressor.compressImage(bufferedImage);
        boolean bl = false;
        WWIO.saveBuffer(byteBuffer, file, bl);
    }
}

