/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet.ascii;

import java.io.PrintWriter;
import java.util.Enumeration;
import opendap.dap.DStructure;
import opendap.servlet.ascii.toASCII;

public class asciiStructure
extends DStructure
implements toASCII {
    private static boolean _Debug = false;

    public asciiStructure() {
        this(null);
    }

    public asciiStructure(String n) {
        super(n);
    }

    @Override
    public void toASCII(PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        if (_Debug) {
            System.out.println("asciiStructure.toASCII(" + addName + ",'" + rootName + "')  getName(): " + this.getEncodedName());
        }
        rootName = rootName != null ? rootName + "." + this.getEncodedName() : this.getEncodedName();
        boolean firstPass = true;
        Enumeration e = this.getVariables();
        while (e.hasMoreElements()) {
            toASCII ta = (toASCII)e.nextElement();
            if (!newLine && !firstPass) {
                pw.print(", ");
            }
            ta.toASCII(pw, addName, rootName, newLine);
            firstPass = false;
        }
        if (newLine) {
            pw.print("\n");
        }
    }

    @Override
    public String toASCIIAddRootName(PrintWriter pw, boolean addName, String rootName) {
        if (addName) {
            rootName = this.toASCIIFlatName(rootName);
            pw.print(rootName);
        }
        return rootName;
    }

    @Override
    public String toASCIIFlatName(String rootName) {
        String s = "";
        boolean firstPass = true;
        Enumeration e = this.getVariables();
        while (e.hasMoreElements()) {
            toASCII ta = (toASCII)e.nextElement();
            if (!firstPass) {
                s = s + ", ";
            }
            s = s + ta.toASCIIFlatName(rootName);
            firstPass = false;
        }
        return s;
    }
}

