/*
 * Decompiled with CFR 0.152.
 */
package indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="TemperatureIndices", author="Sven Kralisch Christian Fischer", description="Calculates standard temperature indices for CCIndex")
public class TemperatureIndices
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily min temperatur", unit="\u00b0C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily mean temperatur", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily max temperatur", unit="\u00b0C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hot day")
    public Attribute.Double isHotDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="number of hot days without interruption")
    public Attribute.Double successiveHotDays;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hot period (more than 5 hot days) has just started")
    public Attribute.Double isBeginningOfHotPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if hot period (more than 5 hot days)")
    public Attribute.Double isWarmSpell;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for hot days", defaultValue="30", unit="\u00b0C")
    public Attribute.Double hotDayThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tropical night")
    public Attribute.Double isTR;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if summer day")
    public Attribute.Double isSU;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if day is attractive for tourists (temp > 15 and < 30) and less than 0.5 mm rain TODO")
    public Attribute.Double isTouristDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if frost day")
    public Attribute.Double isFD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="threshold for permanent frost day", defaultValue="-5", unit="\u00b0C")
    public Attribute.Double coldDayThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="number of frost days without interruption")
    public Attribute.Double successiveColdDays;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if frost period has just started")
    public Attribute.Double isBeginningOfColdPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if frost period")
    public Attribute.Double isColdSpell;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if ice day")
    public Attribute.Double isID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="1 if tmin is/was below 0\u00b0C")
    public Attribute.Double isTempBelowZero;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if frost/no frost has been changed")
    public Attribute.Double isFrostDefrostChange;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates cooling degree days")
    public Attribute.Double coolingDegreeDays;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="cooling degree days threshold", defaultValue="18")
    public Attribute.Double coolingDegreeDaysTheshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates heating degree days")
    public Attribute.Double heatingDegreeDays;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="heating degree days threshold", defaultValue="15")
    public Attribute.Double heatingDegreeDaysTheshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates heating degree days")
    public Attribute.Double growingDegreeDays;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="heating degree days threshold", defaultValue="8")
    public Attribute.Double growingDegreeDaysTheshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmin below 2\u00b0C")
    public Attribute.Double isTNlt2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmin below -2\u00b0C")
    public Attribute.Double isTNltm2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmin below -20\u00b0C")
    public Attribute.Double isTNltm20;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmax above median threshold")
    public Attribute.Double isTXgt50p;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="median tmax")
    public Attribute.Double medianTxThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmax below 10th percentile")
    public Attribute.Double isTXlt10p;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="10p tmax")
    public Attribute.Double TX10pThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmax above 90th percentile")
    public Attribute.Double isTXgt90p;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="90p tmax")
    public Attribute.Double TX90pThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmin below 10th percentile")
    public Attribute.Double isTNlt10p;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="10p tmin")
    public Attribute.Double TN10pThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmin above 90th percentile")
    public Attribute.Double isTNgt90p;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="90p tmin")
    public Attribute.Double TN90pThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmean at least 5\u00b0C")
    public Attribute.Double isTMge5;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmean less than 5\u00b0C")
    public Attribute.Double isTMlt5;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmean at least 10\u00b0C")
    public Attribute.Double isTMge10;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmean less than 10\u00b0C")
    public Attribute.Double isTMlt10;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmax at least 30\u00b0C")
    public Attribute.Double isTXge30;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if tmax at least 35\u00b0C")
    public Attribute.Double isTXge35;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily temperature range")
    public Attribute.Double DTR;

    public void run() {
        this.isFrostDefrostChange.setValue(0.0);
        this.isHotDay.setValue(0.0);
        this.isWarmSpell.setValue(0.0);
        this.isBeginningOfHotPeriod.setValue(0.0);
        this.isSU.setValue(0.0);
        this.isTR.setValue(0.0);
        this.isFD.setValue(0.0);
        this.isColdSpell.setValue(0.0);
        this.isBeginningOfColdPeriod.setValue(0.0);
        this.isID.setValue(0.0);
        this.heatingDegreeDays.setValue(0.0);
        this.isTouristDay.setValue(0.0);
        this.isTNlt2.setValue(0.0);
        this.isTNltm2.setValue(0.0);
        this.isTNltm20.setValue(0.0);
        this.isTMge5.setValue(0.0);
        this.isTMlt5.setValue(0.0);
        this.isTMge10.setValue(0.0);
        this.isTMlt10.setValue(0.0);
        this.isTXge30.setValue(0.0);
        this.isTXge35.setValue(0.0);
        if (this.isTempBelowZero.getValue() == 1.0 && this.tmin.getValue() > 0.0) {
            this.isFrostDefrostChange.setValue(1.0);
        }
        if (this.tmin.getValue() < 0.0) {
            this.isTempBelowZero.setValue(1.0);
            this.isFD.setValue(1.0);
        } else {
            this.isTempBelowZero.setValue(0.0);
        }
        if (this.tmin.getValue() < 2.0) {
            this.isTNlt2.setValue(1.0);
        }
        if (this.tmin.getValue() < -2.0) {
            this.isTNltm2.setValue(1.0);
        }
        if (this.tmin.getValue() < -20.0) {
            this.isTNltm20.setValue(1.0);
        }
        if (this.tmax.getValue() > 25.0) {
            this.isSU.setValue(1.0);
        }
        if (this.tmin.getValue() > 20.0) {
            this.isTR.setValue(1.0);
        }
        if (this.tmax.getValue() < 0.0) {
            this.isID.setValue(1.0);
        }
        if (this.tmean.getValue() >= 5.0) {
            this.isTMge5.setValue(1.0);
        }
        if (this.tmean.getValue() < 5.0) {
            this.isTMlt5.setValue(1.0);
        }
        if (this.tmean.getValue() >= 10.0) {
            this.isTMge10.setValue(1.0);
        }
        if (this.tmean.getValue() < 10.0) {
            this.isTMlt10.setValue(1.0);
        }
        if (this.tmax.getValue() >= 30.0) {
            this.isTXge30.setValue(1.0);
        }
        if (this.tmax.getValue() >= 35.0) {
            this.isTXge35.setValue(1.0);
        }
        if (this.tmax.getValue() > this.medianTxThreshold.getValue()) {
            this.isTXgt50p.setValue(1.0);
        } else {
            this.isTXgt50p.setValue(0.0);
        }
        if (this.tmax.getValue() < this.TX10pThreshold.getValue()) {
            this.isTXlt10p.setValue(1.0);
        } else {
            this.isTXlt10p.setValue(0.0);
        }
        if (this.tmax.getValue() > this.TX90pThreshold.getValue()) {
            this.isTXgt90p.setValue(1.0);
        } else {
            this.isTXgt90p.setValue(0.0);
        }
        if (this.tmin.getValue() < this.TN10pThreshold.getValue()) {
            this.isTNlt10p.setValue(1.0);
        } else {
            this.isTNlt10p.setValue(0.0);
        }
        if (this.tmin.getValue() > this.TN90pThreshold.getValue()) {
            this.isTNgt90p.setValue(1.0);
        } else {
            this.isTNgt90p.setValue(0.0);
        }
        this.DTR.setValue(this.tmax.getValue() - this.tmin.getValue());
        if (this.tmax.getValue() >= this.hotDayThreshold.getValue()) {
            this.isHotDay.setValue(1.0);
            this.successiveHotDays.setValue(this.successiveHotDays.getValue() + 1.0);
            if (this.successiveHotDays.getValue() == 6.0) {
                this.isWarmSpell.setValue(6.0);
                this.isBeginningOfHotPeriod.setValue(1.0);
            } else if (this.successiveHotDays.getValue() > 6.0) {
                this.isWarmSpell.setValue(1.0);
            }
        } else {
            this.successiveHotDays.setValue(0.0);
        }
        if (this.tmin.getValue() <= this.coldDayThreshold.getValue()) {
            this.successiveColdDays.setValue(this.successiveColdDays.getValue() + 1.0);
            if (this.successiveColdDays.getValue() == 6.0) {
                this.isColdSpell.setValue(6.0);
                this.isBeginningOfColdPeriod.setValue(1.0);
            } else if (this.successiveColdDays.getValue() > 6.0) {
                this.isColdSpell.setValue(1.0);
            }
        } else {
            this.successiveColdDays.setValue(0.0);
        }
        if (this.tmin.getValue() > this.tmean.getValue()) {
            System.out.println("Oops, tmin (" + this.tmin + ") is larger than tmean (" + this.tmean + ")");
        }
        this.coolingDegreeDays.setValue(Math.max(this.tmean.getValue() - this.coolingDegreeDaysTheshold.getValue(), 0.0));
        this.heatingDegreeDays.setValue(Math.max(this.heatingDegreeDaysTheshold.getValue() - this.tmean.getValue(), 0.0));
        this.growingDegreeDays.setValue(Math.max(this.tmean.getValue() - this.growingDegreeDaysTheshold.getValue(), 0.0));
    }
}

