/*
 * Decompiled with CFR 0.152.
 */
package indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

@JAMSComponentDescription(title="PercentileCalc", author="Sven Kralisch", description="Calculates defined percentiles of a data array", date="2022-01-16", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class PercentileCalc
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The list to store the values")
    public Attribute.Object list;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Percentile tresholds")
    public Attribute.Integer[] percentileTreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Percentile values")
    public Attribute.Double[] percentileValue;

    public void run() {
        ArrayList l = (ArrayList)this.list.getValue();
        Collections.sort(l);
        double n = l.size();
        int i = 0;
        int c = 0;
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            if ((double)c / n >= (double)this.percentileTreshold[i].getValue() / 100.0) {
                this.percentileValue[i].setValue(d);
                if (++i == this.percentileTreshold.length) break;
            }
            ++c;
        }
    }
}

