/*
 * Decompiled with CFR 0.152.
 */
package cci;

import cci.CCIFrame;
import cci.CmdLine;
import jams.JAMS;
import jams.JAMSLogging;
import jams.JAMSProperties;
import jams.SystemProperties;
import jams.io.ParameterProcessor;
import jams.io.XMLProcessor;
import jams.logging.MsgBoxLogHandler;
import jams.logging.NotificationLogHandler;
import jams.model.JAMSFullModelState;
import jams.model.Model;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.tools.FileTools;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import jams.tools.XMLTools;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CCIndex {
    public static final String APP_TITLE = "CDITool";
    public static final String PROP_WORKSPACE_DIR = "workspacedir";
    public static final String PROP_MODEL_FILE = "ccindexmodelfile";
    public static final String PROP_TEMPLATE_DIR = "ccindextemplatedir";
    protected JAMSProperties jamsProperties;
    static final Logger logger = Logger.getLogger(CCIndex.class.getName());
    private static ResourceBundle resources = ResourceBundle.getBundle("resources/i18n/CCIndexBundle");

    public CCIndex(CmdLine cmdLine) {
        block33: {
            this.jamsProperties = JAMSProperties.createProperties();
            String fileName = null;
            try {
                if (cmdLine.getConfigFileName() != null) {
                    fileName = cmdLine.getConfigFileName();
                    JAMS.initBaseDir(fileName);
                    this.jamsProperties.load(fileName);
                } else {
                    JAMS.initBaseDir();
                    File file = new File(JAMS.getBaseDir(), "default.jap");
                    if (file.exists()) {
                        fileName = file.getAbsolutePath();
                        this.jamsProperties.load(fileName);
                    } else {
                        fileName = file.getAbsolutePath();
                        this.jamsProperties.save(fileName);
                    }
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, JAMS.i18n("Error_while_loading_config_from") + fileName, ioe);
            }
            JAMSTools.configureLocaleEncoding(this.jamsProperties);
            if (cmdLine.isNogui() || GraphicsEnvironment.isHeadless()) {
                this.jamsProperties.setProperty("guiconfig", "false");
                this.jamsProperties.setProperty("windowenable", "false");
                this.jamsProperties.setProperty("errordlg", "false");
            }
            boolean guiConfig = Boolean.parseBoolean(this.jamsProperties.getProperty("guiconfig", "false"));
            String modelFileName = cmdLine.getModelFileName();
            if (modelFileName != null) {
                modelFileName = new File(modelFileName).getAbsolutePath();
            }
            String floatFormat = this.jamsProperties.getProperty("floatformat", "%f");
            JAMS.setFloatFormat(floatFormat);
            if (modelFileName == null) {
                if (guiConfig) {
                    this.startGUI();
                } else {
                    logger.severe(JAMS.i18n("You_must_provide_a_model_file_name_(see_JAMS_--help)_when_disabling_GUI_config!"));
                    System.exit(-1);
                }
            } else {
                boolean vm64;
                boolean os64 = JAMSTools.is64Bit();
                if (os64 != (vm64 = System.getProperty("os.arch").endsWith("64"))) {
                    String osArch = os64 ? "64 bit" : "32 bit";
                    String vmArch = vm64 ? "64 bit" : "32 bit";
                    logger.warning(String.format("Architectures of OS (%s) and Java VM (%s) used with JAMS seem to differ.\nYou should update your Java VM to a matching version to avoid strange model behaviour.\nContinue anyway?", osArch, vmArch));
                }
                String cmdLineParameterValues = cmdLine.getParameterValues();
                if (guiConfig) {
                    try {
                        Properties props = null;
                        if (cmdLine.getJmpFileName() != null) {
                            props = new Properties();
                            FileInputStream fis = new FileInputStream(new File(cmdLine.getJmpFileName()));
                            props.load(fis);
                            fis.close();
                        }
                        this.startGUI(modelFileName, cmdLineParameterValues, props);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                } else {
                    File file = new File(modelFileName);
                    if (!file.exists()) {
                        logger.severe(JAMS.i18n("Model_file_") + modelFileName + JAMS.i18n("_could_not_be_found_-_exiting!"));
                        System.exit(-1);
                    }
                    String info = "";
                    String newModelFilename = XMLProcessor.modelDocConverter(modelFileName);
                    if (!newModelFilename.equalsIgnoreCase(modelFileName)) {
                        info = JAMS.i18n("The_model_definition_in_") + modelFileName + JAMS.i18n("_has_been_adapted_in_order_to_meet_changes_in_the_JAMS_model_specification.The_new_definition_has_been_stored_in_") + newModelFilename + JAMS.i18n("_while_your_original_file_was_left_untouched.");
                        modelFileName = newModelFilename;
                    }
                    JAMSRuntime runtime = null;
                    try {
                        String snapshotFileName;
                        String xmlString = FileTools.fileToString(modelFileName);
                        String[] args = StringTools.toArray(cmdLineParameterValues, ";");
                        if (args != null) {
                            for (int i = 0; i < args.length; ++i) {
                                xmlString = xmlString.replaceAll("%" + i + "%", args[i]);
                            }
                        }
                        Document modelDoc = XMLTools.getDocumentFromString(xmlString);
                        String jmpFileName = cmdLine.getJmpFileName();
                        if (jmpFileName != null) {
                            modelDoc = ParameterProcessor.loadParams(modelDoc, new File(jmpFileName));
                        }
                        String defaultWorkspacePath = null;
                        if (Boolean.parseBoolean(this.jamsProperties.getProperty("defaultworkspace")) && !StringTools.isEmptyString(modelFileName)) {
                            defaultWorkspacePath = new File(modelFileName).getParent();
                        }
                        runtime = new StandardRuntime(this.jamsProperties);
                        runtime.loadModel(modelDoc, defaultWorkspacePath, modelFileName);
                        if (!info.equals("")) {
                            runtime.println(info);
                        }
                        if ((snapshotFileName = cmdLine.getSnapshotFileName()) != null) {
                            File snapshotFile = new File(snapshotFileName);
                            if (!snapshotFile.exists()) break block33;
                            JAMSFullModelState state = new JAMSFullModelState(snapshotFile);
                            Model model = state.getModel();
                            try {
                                model.getRuntime().resume(state.getSmallModelState());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JAMSTools.handle(e);
                            }
                            Runtime.getRuntime().gc();
                            System.exit(0);
                            break block33;
                        }
                        runtime.runModel();
                    }
                    catch (IOException ioe) {
                        logger.severe(JAMS.i18n("The_model_definition_file_") + modelFileName + JAMS.i18n("_could_not_be_loaded,_because:_") + ioe.toString());
                    }
                    catch (SAXException se) {
                        logger.severe(JAMS.i18n("The_model_definition_file_") + modelFileName + JAMS.i18n("_contained_errors!"));
                    }
                    catch (Exception ex) {
                        if (runtime != null) {
                            runtime.handle(ex);
                        }
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        }
    }

    private void setLaF() {
        String desiredLookAndFeel = this.jamsProperties.getProperty("lookandfeel");
        try {
            boolean successful = false;
            if (desiredLookAndFeel != null) {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    System.out.println(info.getName());
                    if (!desiredLookAndFeel.equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    successful = true;
                    break;
                }
            }
            if (!successful) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception lnfe) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception ex) {
                JAMSTools.handle(ex);
            }
        }
    }

    protected void startGUI() {
        this.setLaF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CCIFrame(null, (SystemProperties)CCIndex.this.jamsProperties).setVisible(true);
            }
        });
    }

    protected void startGUI(final String modelFileName, final String cmdLineParameterValues, final Properties jmpParameters) {
        this.setLaF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CCIFrame(null, CCIndex.this.jamsProperties, modelFileName, cmdLineParameterValues, jmpParameters).setVisible(true);
            }
        });
    }

    public static void registerLogger(JAMSLogging.LogOption option, Logger log) {
        switch (option) {
            case CollectAndShow: {
                log.addHandler(NotificationLogHandler.getInstance());
                log.setUseParentHandlers(false);
                break;
            }
            case Show: {
                log.addHandler(MsgBoxLogHandler.getInstance());
                log.setUseParentHandlers(true);
            }
        }
    }

    public static void unregisterLogger(JAMSLogging.LogOption option, Logger log) {
        if (option == null) {
            log.removeHandler(NotificationLogHandler.getInstance());
            log.removeHandler(MsgBoxLogHandler.getInstance());
        } else {
            switch (option) {
                case CollectAndShow: {
                    log.removeHandler(NotificationLogHandler.getInstance());
                    break;
                }
                case Show: {
                    log.removeHandler(MsgBoxLogHandler.getInstance());
                }
            }
        }
        log.setUseParentHandlers(true);
    }

    public static ResourceBundle getResources() {
        return resources;
    }

    public static void setResources(ResourceBundle aResources) {
        resources = aResources;
    }

    public static String i18n(String key) {
        if (CCIndex.getResources().containsKey(key)) {
            return CCIndex.getResources().getString(key);
        }
        Logger.getLogger(CCIndex.class.getName()).log(Level.INFO, "Could not find i18n key \"" + key + "\", using the key as result!");
        return key;
    }

    public static void main(String[] args) {
        new CCIndex(new CmdLine(args, APP_TITLE));
    }
}

