/*
 * Decompiled with CFR 0.152.
 */
package cci;

import cci.AboutDlg;
import cci.CCILauncher;
import cci.CCIndex;
import ccindex.explorer.JAMSExplorer;
import jams.JAMS;
import jams.JAMSFileFilter;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.gui.LogViewDlg;
import jams.gui.PropertyDlg;
import jams.gui.RuntimeManagerPanel;
import jams.gui.tools.GUIHelper;
import jams.io.ParameterProcessor;
import jams.io.XMLProcessor;
import jams.tools.FileTools;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import jams.tools.XMLTools;
import jams.workspace.InvalidWorkspaceException;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CCIFrame
extends CCILauncher {
    private JMenuBar mainMenu;
    private JMenu logsMenu;
    private JMenu modelMenu;
    private JMenu recentMenu;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JFileChooser jfcModel;
    private JFileChooser jfcDir;
    private JFileChooser jfcParam;
    private JDialog rtManagerDlg;
    private PropertyDlg propertyDlg;
    private LogViewDlg infoDlg = new LogViewDlg((Frame)this, 400, 400, JAMS.i18n("Info_Log"));
    private LogViewDlg errorDlg = new LogViewDlg((Frame)this, 400, 400, JAMS.i18n("Error_Log"));
    private String modelFilename;
    private File workspace;
    private Action editPrefsAction;
    private Action newModelAction;
    private Action loadModelAction;
    private Action saveModelAction;
    private Action exitAction;
    private Action aboutAction;
    private Action rtManagerAction;
    private Action infoLogAction;
    private Action errorLogAction;
    private Action onlineAction;
    private Action explorerAction;
    private Action browserAction;
    private static JAMSExplorer theExplorer;

    public CCIFrame(Frame parent, SystemProperties properties) {
        super((Window)parent, properties);
        String vmArch;
        String osArch;
        int result;
        boolean os64 = JAMSTools.is64Bit();
        boolean vm64 = System.getProperty("os.arch").endsWith("64");
        if (os64 != vm64 && (result = GUIHelper.showYesNoDlg(null, String.format("Architectures of OS (%s) and Java VM (%s) used with JAMS seem to differ.\nYou should update your Java VM to a matching version to avoid strange model behaviour.\nContinue anyway?", osArch = os64 ? "64 bit" : "32 bit", vmArch = vm64 ? "64 bit" : "32 bit"), "Warning")) == 1) {
            System.exit(0);
        }
        JAMSLogging.getInstance().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                List<Logger> loggers = JAMSLogging.getLoggers();
                Logger logger = (Logger)arg;
                JAMSLogging.LogOption option = JAMSLogging.getLogOption(logger);
                if (loggers.contains(logger)) {
                    CCIndex.registerLogger(option, logger);
                } else {
                    CCIndex.unregisterLogger(option, logger);
                }
            }
        });
    }

    public CCIFrame(Frame parent, SystemProperties properties, String modelFilename, String cmdLineArgs, Properties jmpParameters) {
        this(parent, properties);
        this.loadModelDefinition(modelFilename, StringTools.toArray(cmdLineArgs, ";"), jmpParameters);
        this.loadPath = new File(modelFilename);
    }

    protected void createNewModel(String fileName, String[] args, Properties jmpParameters) {
        File sourceDir = new File(this.getProperties().getProperty("ccindextemplatedir"));
        File destDir = new File(fileName);
        try {
            int result;
            if (!destDir.exists() && (result = GUIHelper.showYesNoDlg(this, CCIndex.i18n("create_new_directory"), null)) == 0) {
                FileUtils.forceMkdir(destDir);
            }
            if (!destDir.isDirectory()) {
                GUIHelper.showErrorDlg(this, CCIndex.i18n("error_empty_directory_needed"));
                return;
            }
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(destDir.getAbsolutePath(), new String[0]));
            if (dirStream.iterator().hasNext()) {
                GUIHelper.showErrorDlg(this, CCIndex.i18n("error_empty_directory_needed"));
                return;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CCIFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            FileUtils.copyDirectory(sourceDir, destDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadModelDefinition(new File(destDir, this.getProperties().getProperty("ccindexmodelfile")).getAbsolutePath(), args, jmpParameters);
    }

    protected void loadModelDefinition(String fileName, String[] args, Properties jmpParameters) {
        if (!this.closeModel()) {
            return;
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                GUIHelper.showErrorDlg(this, JAMS.i18n("Model_file_") + fileName + JAMS.i18n("_could_not_be_found!"), JAMS.i18n("File_Open_Error"));
                return;
            }
            this.loadPath = file;
            String newFilename = XMLProcessor.modelDocConverter(fileName);
            if (!newFilename.equalsIgnoreCase(fileName)) {
                fileName = newFilename;
                GUIHelper.showInfoDlg(this, JAMS.i18n("The_model_definition_in_") + fileName + JAMS.i18n("_has_been_adapted_in_order_to_meet_changes_in_the_JAMS_model_specification.The_new_definition_has_been_stored_in_") + newFilename + JAMS.i18n("_while_your_original_file_was_left_untouched."), JAMS.i18n("Info"));
            }
            String xmlString = FileTools.fileToString(fileName);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    xmlString = xmlString.replaceAll("%" + i + "%", args[i]);
                }
            }
            this.modelDocument = XMLTools.getDocumentFromString(xmlString);
            if (jmpParameters != null) {
                this.modelDocument = ParameterProcessor.loadParams(this.modelDocument, jmpParameters);
            }
            ParameterProcessor.preProcess(this.modelDocument);
            this.initialModelDocString = XMLTools.getStringFromDocument(this.modelDocument);
        }
        catch (IOException ioe) {
            GUIHelper.showErrorDlg(this, JAMS.i18n("The_specified_model_configuration_file_") + fileName + JAMS.i18n("_could_not_be_found!"), JAMS.i18n("Error"));
        }
        catch (SAXException se) {
            if (se instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)se;
                GUIHelper.showErrorDlg(this, JAMS.i18n("The_specified_model_configuration_file_") + fileName + JAMS.i18n("_contains_errors!") + "\n[Fatal Error] :" + spe.getLineNumber() + ":" + spe.getColumnNumber() + ":" + spe.getMessage(), JAMS.i18n("Error"));
            }
            GUIHelper.showErrorDlg(this, JAMS.i18n("The_specified_model_configuration_file_") + fileName + JAMS.i18n("_contains_errors!"), JAMS.i18n("Error"));
        }
        this.modelFilename = fileName;
        this.workspace = new File(this.modelFilename).getParentFile();
        this.fillAttributes(this.getModelDocument());
        this.fillTabbedPane(this.getModelDocument());
        this.fillNetCDFPane(this.workspace);
        this.saveModelAction.setEnabled(true);
        this.modelMenu.setEnabled(true);
        this.explorerAction.setEnabled(true);
        this.getRunModelAction().setEnabled(true);
        JAMSTools.addToRecentFiles(this.getProperties(), "recentfiles", fileName);
        this.updateRecentMenu();
    }

    @Override
    protected void init() throws HeadlessException, DOMException, NumberFormatException {
        super.init();
        this.getRunModelAction().setEnabled(false);
        this.editPrefsAction = new AbstractAction(JAMS.i18n("Edit_Preferences...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.propertyDlg.setProperties(CCIFrame.this.getProperties());
                CCIFrame.this.propertyDlg.setVisible(true);
                if (CCIFrame.this.propertyDlg.getResult() == 1) {
                    CCIFrame.this.propertyDlg.validateProperties();
                }
            }
        };
        this.newModelAction = new AbstractAction(CCIndex.i18n("New_Run")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringTools.isEmptyString(CCIFrame.this.modelFilename)) {
                    CCIFrame.this.jfcDir.setSelectedFile(new File(CCIFrame.this.modelFilename));
                } else {
                    CCIFrame.this.jfcDir.setSelectedFile(new File(""));
                }
                if (CCIFrame.this.jfcDir.showOpenDialog(CCIFrame.this) == 0) {
                    CCIFrame.this.state = null;
                    CCIFrame.this.createNewModel(CCIFrame.this.jfcDir.getSelectedFile().getAbsolutePath(), null, null);
                }
            }
        };
        this.loadModelAction = new AbstractAction(CCIndex.i18n("Load_Run")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringTools.isEmptyString(CCIFrame.this.modelFilename)) {
                    CCIFrame.this.jfcModel.setSelectedFile(new File(CCIFrame.this.modelFilename));
                } else {
                    CCIFrame.this.jfcModel.setSelectedFile(new File(""));
                }
                if (CCIFrame.this.jfcModel.showOpenDialog(CCIFrame.this) == 0) {
                    CCIFrame.this.state = null;
                    CCIFrame.this.loadModelDefinition(CCIFrame.this.jfcModel.getSelectedFile().getAbsolutePath(), null, null);
                }
            }
        };
        this.saveModelAction = new AbstractAction(CCIndex.i18n("Save_Run")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.saveModel();
            }
        };
        this.saveModelAction.setEnabled(false);
        this.exitAction = new AbstractAction(JAMS.i18n("Exit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.exit();
            }
        };
        this.aboutAction = new AbstractAction(JAMS.i18n("About")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDlg(CCIFrame.this).setVisible(true);
            }
        };
        this.onlineAction = new AbstractAction(JAMS.i18n("JAMS_online...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.openURL(JAMS.i18n("JAMS_URL"));
            }
        };
        this.rtManagerAction = new AbstractAction(JAMS.i18n("Show_Runtime_Manager...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.rtManagerDlg.setVisible(true);
            }
        };
        this.infoLogAction = new AbstractAction(JAMS.i18n("Info_Log...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.getInfoDlg().setVisible(true);
            }
        };
        this.errorLogAction = new AbstractAction(JAMS.i18n("Error_Log...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.getErrorDlg().setVisible(true);
            }
        };
        this.explorerAction = new AbstractAction(CCIndex.i18n("Data_Explorer")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.openExplorer();
            }
        };
        this.browserAction = new AbstractAction(JAMS.i18n("Browse_WS_Dir")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.browseWSDir();
            }
        };
        this.propertyDlg = new PropertyDlg((Frame)this, this.getProperties());
        this.jfcModel = GUIHelper.getJFileChooser(JAMSFileFilter.getModelFilter());
        this.jfcModel.setFileSelectionMode(0);
        this.jfcModel.setCurrentDirectory(new File(JAMS.getBaseDir(), this.getProperties().getProperty("workspacedir")));
        this.jfcDir = new JFileChooser();
        this.jfcDir.setFileSelectionMode(1);
        this.jfcDir.setCurrentDirectory(new File(JAMS.getBaseDir(), this.getProperties().getProperty("workspacedir")));
        this.jfcParam = GUIHelper.getJFileChooser(JAMSFileFilter.getParameterFilter());
        this.jfcParam.setFileSelectionMode(0);
        this.jfcParam.setCurrentDirectory(JAMS.getBaseDir());
        this.rtManagerDlg = new JDialog((Frame)this, JAMS.i18n("Runtime_Manager"));
        this.rtManagerDlg.setDefaultCloseOperation(1);
        this.rtManagerDlg.setLocationByPlatform(true);
        RuntimeManagerPanel rtManagerPanel = new RuntimeManagerPanel();
        this.rtManagerDlg.getContentPane().add(rtManagerPanel);
        this.rtManagerDlg.pack();
        JButton closeButton = new JButton(JAMS.i18n("Close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCIFrame.this.rtManagerDlg.setVisible(false);
            }
        });
        rtManagerPanel.getButtonPanel().add(closeButton);
        this.mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu(JAMS.i18n("File"));
        JMenuItem newItem = new JMenuItem(this.newModelAction);
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        fileMenu.add(newItem);
        JMenuItem loadItem = new JMenuItem(this.loadModelAction);
        loadItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(loadItem);
        this.recentMenu = new JMenu(CCIndex.i18n("Recent_Runs"));
        this.updateRecentMenu();
        fileMenu.add(this.recentMenu);
        this.saveItem = new JMenuItem(this.saveModelAction);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(this.saveItem);
        fileMenu.add(new JSeparator());
        JMenuItem editOptionsItem = new JMenuItem(this.editPrefsAction);
        editOptionsItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        fileMenu.add(editOptionsItem);
        fileMenu.add(new JSeparator());
        JMenuItem exitItem = new JMenuItem(this.exitAction);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        fileMenu.add(exitItem);
        this.getMainMenu().add(fileMenu);
        this.modelMenu = new JMenu(CCIndex.i18n("Analysis"));
        this.modelMenu.setEnabled(false);
        this.mainMenu.add(this.modelMenu);
        Action runModelAction = this.getRunModelAction();
        runModelAction.putValue("Name", CCIndex.i18n("Start_analysis"));
        JMenuItem runModelItem = new JMenuItem(runModelAction);
        runModelItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.modelMenu.add(runModelItem);
        JMenuItem explorerItem = new JMenuItem(this.explorerAction);
        explorerItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.modelMenu.add(explorerItem);
        JMenuItem fileBrowserItem = new JMenuItem(this.browserAction);
        fileBrowserItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.modelMenu.add(fileBrowserItem);
        this.modelMenu.add(new JSeparator());
        JMenuItem rtManagerItem = new JMenuItem(this.rtManagerAction);
        this.modelMenu.add(rtManagerItem);
        this.logsMenu = new JMenu(JAMS.i18n("Logs"));
        JMenuItem infoLogItem = new JMenuItem(this.infoLogAction);
        this.getLogsMenu().add(infoLogItem);
        JMenuItem errorLogItem = new JMenuItem(this.errorLogAction);
        this.getLogsMenu().add(errorLogItem);
        this.getMainMenu().add(this.getLogsMenu());
        JMenu helpMenu = new JMenu(JAMS.i18n("Help"));
        JMenuItem onlineItem = new JMenuItem(this.onlineAction);
        helpMenu.add(onlineItem);
        JMenuItem aboutItem = new JMenuItem(this.aboutAction);
        helpMenu.add(aboutItem);
        this.getMainMenu().add(helpMenu);
        this.setJMenuBar(this.getMainMenu());
        JButton modelNewButton = new JButton(this.newModelAction);
        modelNewButton.setText("");
        modelNewButton.setToolTipText(CCIndex.i18n("New_Run"));
        modelNewButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelNew.png")));
        this.getToolBar().add((Component)modelNewButton, 0);
        JButton loadButton = new JButton(this.loadModelAction);
        loadButton.setText("");
        loadButton.setToolTipText(CCIndex.i18n("Load_Run"));
        loadButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelOpen.png")));
        this.getToolBar().add((Component)loadButton, 1);
        JButton saveButton = new JButton(this.saveModelAction);
        saveButton.setText("");
        saveButton.setToolTipText(CCIndex.i18n("Save_Run"));
        saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelSave.png")));
        this.getToolBar().add((Component)saveButton, 2);
        JButton prefsButton = new JButton(this.editPrefsAction);
        prefsButton.setText("");
        prefsButton.setToolTipText(JAMS.i18n("Edit_Preferences..."));
        prefsButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Preferences.png")));
        this.getToolBar().add((Component)prefsButton, 3);
        this.getToolBar().add((Component)new JToolBar.Separator(null), 3);
        JButton explorerButton = new JButton(this.explorerAction);
        explorerButton.setText("");
        explorerButton.setToolTipText(JAMS.i18n("JADE"));
        explorerButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Layers_small.png")));
        this.explorerAction.setEnabled(false);
        this.getToolBar().add(explorerButton);
        this.getToolBar().addSeparator();
        JButton infoLogButton = new JButton(this.infoLogAction);
        infoLogButton.setText("");
        infoLogButton.setToolTipText(JAMS.i18n("Show_Info_Log..."));
        infoLogButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/InfoLog.png")));
        this.getToolBar().add(infoLogButton);
        JButton errorLogButton = new JButton(this.errorLogAction);
        errorLogButton.setText("");
        errorLogButton.setToolTipText(JAMS.i18n("Show_Error_Log..."));
        errorLogButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ErrorLog.png")));
        this.getToolBar().add(errorLogButton);
        JButton exitButton = new JButton(this.exitAction);
        exitButton.setText("");
        exitButton.setToolTipText(JAMS.i18n("Exit"));
        exitButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/system-shutdown.png")));
        this.getToolBar().add(exitButton);
    }

    public void loadParams(File paramsFile) {
        try {
            ParameterProcessor.loadParams(this.getModelDocument(), paramsFile);
            this.loadModelDefinition(this.getModelDocument());
        }
        catch (Exception ex) {
            GUIHelper.showErrorDlg(this, JAMS.i18n("File_") + paramsFile.getName() + JAMS.i18n("_could_not_be_loaded."), JAMS.i18n("File_Open_Error"));
        }
    }

    public void saveParams(File paramsFile) {
        try {
            ParameterProcessor.saveParams(this.getModelDocument(), paramsFile, this.getProperties().getProperty("username"), this.modelFilename);
        }
        catch (Exception ex) {
            GUIHelper.showErrorDlg(this, JAMS.i18n("File_") + paramsFile.getName() + JAMS.i18n("_could_not_be_saved."), JAMS.i18n("File_saving_error"));
        }
    }

    @Override
    protected void processInfoLog(String logText) {
        this.getInfoDlg().appendText(logText);
    }

    @Override
    protected void processErrorLog(String logText) {
        this.getErrorDlg().appendText(logText);
    }

    @Override
    protected void exit() {
        if (!this.closeModel()) {
            return;
        }
        try {
            this.getProperties().save();
        }
        catch (IOException ioe) {
            JAMSTools.handle(ioe);
        }
        super.exit();
        System.exit(0);
    }

    private boolean closeModel() {
        int result;
        this.state = null;
        if (this.getModelDocument() == null) {
            return true;
        }
        if (!this.verifyInputs(false) && (result = GUIHelper.showYesNoDlg(this, JAMS.i18n("Found_invalid_parameter_values_which_won't_be_saved._Proceed_anyway?"), JAMS.i18n("Invalid_parameter_values"))) == 1) {
            return false;
        }
        this.updateProperties();
        if (this.getModelDocument() != null) {
            String modelDocString = XMLTools.getStringFromDocument(this.getModelDocument());
            if (!this.getInitialModelDocString().equals(modelDocString)) {
                int result2 = GUIHelper.showYesNoCancelDlg(this, JAMS.i18n("Save_modifications_in_") + this.modelFilename + JAMS.i18n("_?"), JAMS.i18n("JAMS_Launcher:_unsaved_modifications"));
                if (result2 == 2) {
                    return false;
                }
                if (result2 == 0) {
                    this.saveModel();
                }
            }
        }
        this.writeModelConfig();
        return true;
    }

    private void saveModel() {
        this.updateProperties();
        try {
            XMLTools.writeXmlFile(this.getModelDocument(), this.modelFilename);
            this.initialModelDocString = XMLTools.getStringFromDocument(this.modelDocument);
            this.fillAttributes(this.getModelDocument());
        }
        catch (IOException ioe) {
            GUIHelper.showErrorDlg(this, JAMS.i18n("Error_saving_configuration_to_") + this.modelFilename, JAMS.i18n("Error"));
            return;
        }
    }

    @Override
    protected void fillAttributes(Document doc) {
        Element root = doc.getDocumentElement();
        this.setTitle("CDITool [" + this.modelFilename + "]");
        this.setHelpBaseUrl(root.getAttribute("helpbaseurl"));
    }

    private void browseWSDir() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        Document modelDoc = this.getModelDocument();
        File workspaceFile = new File(XMLProcessor.getWorkspacePath(modelDoc));
        if (!workspaceFile.isDirectory()) {
            if (this.loadPath != null) {
                workspaceFile = this.loadPath.getParentFile();
            } else {
                GUIHelper.showErrorDlg(this, "\"" + workspaceFile + "\"" + JAMS.i18n("Invalid_Workspace"), JAMS.i18n("Error"));
                return;
            }
        }
        try {
            URI workspaceURI = workspaceFile.toURI();
            Desktop.getDesktop().browse(workspaceURI);
        }
        catch (IOException ex) {
            GUIHelper.showErrorDlg(this, "\"" + workspaceFile + "\"" + JAMS.i18n("Invalid_Workspace"), JAMS.i18n("Error"));
        }
    }

    private void openExplorer() {
        if (!this.verifyInputs()) {
            return;
        }
        this.updateProperties();
        Document modelDoc = this.getModelDocument();
        File workspaceFile = new File(XMLProcessor.getWorkspacePath(modelDoc));
        if (!workspaceFile.isDirectory()) {
            if (this.loadPath != null) {
                workspaceFile = this.loadPath.getParentFile();
            } else {
                GUIHelper.showErrorDlg(this, "\"" + workspaceFile + "\"" + JAMS.i18n("Invalid_Workspace"), JAMS.i18n("Error"));
                return;
            }
        }
        try {
            if (theExplorer == null) {
                theExplorer = new JAMSExplorer(null, false);
            }
            theExplorer.getExplorerFrame().setIconImages(CCILauncher.getAppIcons());
            if (theExplorer.getWorkspace() == null || !theExplorer.getWorkspace().getDirectory().equals(workspaceFile)) {
                theExplorer.getExplorerFrame().open(workspaceFile);
            }
            theExplorer.getExplorerFrame().setVisible(true);
        }
        catch (NoClassDefFoundError ncdfe) {
            ncdfe.printStackTrace();
            GUIHelper.showInfoDlg(this, JAMS.i18n("ExplorerDisabled"), JAMS.i18n("Info"));
        }
        catch (InvalidWorkspaceException ex) {
            GUIHelper.showErrorDlg(this, "\"" + workspaceFile + "\"" + JAMS.i18n("Invalid_Workspace"), JAMS.i18n("Error"));
        }
    }

    public JMenuBar getMainMenu() {
        return this.mainMenu;
    }

    protected JMenu getLogsMenu() {
        return this.logsMenu;
    }

    protected LogViewDlg getInfoDlg() {
        return this.infoDlg;
    }

    protected LogViewDlg getErrorDlg() {
        return this.errorDlg;
    }

    private void updateRecentMenu() {
        String[] recentFiles;
        this.recentMenu.removeAll();
        for (String fileName : recentFiles = JAMSTools.getRecentFiles(this.getProperties(), "recentfiles")) {
            AbstractAction openAction = new AbstractAction(fileName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CCIFrame.this.loadModelDefinition(this.getValue("Name").toString(), null, null);
                }
            };
            JMenuItem recentItem = new JMenuItem(openAction);
            this.recentMenu.add(recentItem);
        }
    }
}

