/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.stores;

import jams.tools.StringTools;
import jams.tools.XMLTools;
import jams.workspace.DefaultDataSet;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jams.workspace.stores.GeoDataStore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShapeFileDataStore
extends GeoDataStore {
    private String fileName = null;
    private URI uri = null;
    private String keyColumn = null;
    private File shapeFile;

    public ShapeFileDataStore(JAMSWorkspace ws, String id, Document doc) throws URISyntaxException {
        super(ws);
        Element keyElement;
        String wkUri = null;
        String wkFileName = null;
        String wkKeyColumn = null;
        Element sourceElement = (Element)doc.getElementsByTagName("source").item(0);
        if (sourceElement != null) {
            wkUri = this.getNodeValue(sourceElement, "uri");
            wkFileName = this.getNodeValue(sourceElement, "filename");
        }
        if ((keyElement = (Element)doc.getElementsByTagName("key").item(0)) != null) {
            wkKeyColumn = keyElement.getTextContent();
        }
        this.init(id, wkUri, wkFileName, wkKeyColumn);
    }

    public ShapeFileDataStore(JAMSWorkspace ws, String id, String uriString, String fileName, String keyColumn) throws URISyntaxException {
        super(ws);
        this.init(id, uriString, fileName, keyColumn);
    }

    private void init(String id, String uriString, String fileName, String keyColumn) throws URISyntaxException {
        this.id = id;
        if (!StringTools.isEmptyString(uriString)) {
            this.uri = new URI(uriString);
            this.shapeFile = new File(this.uri);
        }
        if (!(this.shapeFile != null && this.shapeFile.exists() || StringTools.isEmptyString(fileName))) {
            this.shapeFile = new File(this.ws.getLocalInputDirectory(), fileName);
        }
        if (this.shapeFile == null) {
            this.shapeFile = new File(this.ws.getLocalInputDirectory(), id + ".shp");
        }
        if (this.shapeFile.exists()) {
            this.ws.getRuntime().println("Trying to use shape file from " + this.shapeFile.toString() + " ..");
            this.uri = this.shapeFile.toURI();
            this.fileName = this.shapeFile.getName();
            if (keyColumn != null) {
                this.keyColumn = keyColumn;
            }
        } else {
            this.ws.getRuntime().println("No shape file found for shape datastore \"" + id + "\" ..");
        }
    }

    public Document getDocument() throws Exception {
        String xmlString = "<shapefiledatastore>";
        xmlString = xmlString + "<source>";
        xmlString = xmlString + "<uri>";
        String uriString = this.uri.toASCIIString();
        if (!StringTools.isEmptyString(uriString)) {
            xmlString = xmlString + uriString;
        }
        xmlString = xmlString + "</uri>";
        xmlString = xmlString + "<filename>";
        if (!StringTools.isEmptyString(this.fileName)) {
            xmlString = xmlString + this.fileName;
        }
        xmlString = xmlString + "</filename>";
        xmlString = xmlString + "</source>";
        xmlString = xmlString + "<key>";
        if (!StringTools.isEmptyString(this.keyColumn)) {
            xmlString = xmlString + this.keyColumn;
        }
        xmlString = xmlString + "</key>";
        xmlString = xmlString + "</shapefiledatastore>";
        return XMLTools.getDocumentFromString(xmlString);
    }

    public boolean hasNext() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DefaultDataSet getNext() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws IOException {
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getShapeFile() {
        return this.shapeFile;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setWorkspace(Workspace ws) throws IOException {
        this.close();
    }
}

