/*
 * Decompiled with CFR 0.152.
 */
package jams.tools;

import jams.JAMS;
import jams.SystemProperties;
import jams.data.Attribute;
import jams.model.Component;
import jams.tools.FileTools;
import jams.tools.StringTools;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class JAMSTools {
    private static List<Image> jamsIcons;

    public static Field getField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() == null) {
                throw e;
            }
            return JAMSTools.getField(clazz.getSuperclass(), name);
        }
    }

    public static void setAttribute(Component component, String attribName, Object value) throws SecurityException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException {
        Class<?> componentClazz = component.getClass();
        Class<?> attribClazz = value.getClass();
        String methodName = StringTools.getSetterName(attribName);
        Method m = componentClazz.getDeclaredMethod(methodName, attribClazz);
        m.invoke((Object)component, value);
    }

    public static Object setField(Component component, Field field, Object value) throws SecurityException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException {
        Object data;
        if (field.getModifiers() == 1) {
            field.set(component, value);
            data = field.get(component);
        } else {
            String attribName = field.getName();
            JAMSTools.setAttribute(component, attribName, value);
            data = JAMSTools.getAttribute(component, attribName);
        }
        return data;
    }

    public static Object getAttribute(Component component, String attribName) throws IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Class<?> componentClazz = component.getClass();
        String methodName = StringTools.getGetterName(attribName);
        Method m = componentClazz.getDeclaredMethod(methodName, new Class[0]);
        Object data = m.invoke((Object)component, new Object[0]);
        return data;
    }

    public static void handle(Throwable t) {
        JAMSTools.handle(t, true);
    }

    public static void handle(Throwable t, boolean proceed) {
        t.printStackTrace();
        if (!proceed) {
            System.exit(-1);
        }
    }

    public static void configureLocaleEncoding(SystemProperties properties) {
        String charset;
        String forcedLocale = properties.getProperty("forcelocale");
        if (!StringTools.isEmptyString(forcedLocale)) {
            if (forcedLocale.contains("_")) {
                StringTokenizer tok = new StringTokenizer(forcedLocale, "_");
                Locale.setDefault(new Locale(tok.nextToken(), tok.nextToken()));
            } else {
                Locale.setDefault(new Locale(forcedLocale));
            }
            JAMS.setResources(ResourceBundle.getBundle("resources/i18n/JAMSBundle"));
        }
        if (!StringTools.isEmptyString(charset = properties.getProperty("charset"))) {
            JAMS.setCharset(charset);
        }
    }

    public static int[] convertJAMSArrayToArray(Attribute.Integer[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i].getValue();
        }
        return out;
    }

    public static String[] convertJAMSArrayToArray(Attribute.String[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i].getValue();
        }
        return out;
    }

    public static double[] convertJAMSArrayToArray(Attribute.Double[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i].getValue();
        }
        return out;
    }

    public static boolean cloneInto(Object dst, Object src, Class clazz) {
        Field[] fields;
        if (!clazz.isInstance(dst) || !clazz.isInstance(src)) {
            return false;
        }
        if (clazz.getSuperclass() != null) {
            JAMSTools.cloneInto(dst, src, clazz.getSuperclass());
        }
        for (Field f : fields = clazz.getDeclaredFields()) {
            try {
                f.setAccessible(true);
                if (Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                f.set(dst, f.get(src));
                f.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static String CreateAbsoluteFileName(String dirName, String fileName) {
        return FileTools.createAbsoluteFileName(dirName, fileName);
    }

    public static void addToRecentFiles(SystemProperties p, String key, String fileName) {
        File f = new File(fileName);
        if (f.exists()) {
            try {
                fileName = f.getCanonicalPath();
            }
            catch (IOException ioe) {
                fileName = f.getAbsolutePath();
            }
        }
        int maxFiles = Integer.parseInt(p.getProperty("maxrecentfiles"));
        ArrayList<String> recentFileNames = new ArrayList<String>();
        String s = p.getProperty(key);
        if (s != null) {
            String[] recentArray = s.split("\\|");
            recentFileNames.addAll(Arrays.asList(recentArray));
        }
        if (recentFileNames.contains(fileName)) {
            recentFileNames.remove(fileName);
        }
        if (recentFileNames.size() == maxFiles) {
            recentFileNames.remove(maxFiles - 1);
        }
        String resultString = fileName;
        for (String recentFileName : recentFileNames) {
            resultString = resultString + "|" + recentFileName;
        }
        p.setProperty(key, resultString);
    }

    public static String[] getRecentFiles(SystemProperties p, String key) {
        String s = p.getProperty(key);
        if (s != null) {
            return s.split("\\|");
        }
        return new String[0];
    }

    public static List<Image> getJAMSIcons() {
        if (jamsIcons == null) {
            jamsIcons = new ArrayList<Image>();
            jamsIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon.png")).getImage().getScaledInstance(16, 16, 4));
            jamsIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon.png")).getImage().getScaledInstance(32, 32, 4));
            jamsIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon.png")).getImage().getScaledInstance(48, 48, 4));
            jamsIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon.png")).getImage().getScaledInstance(256, 256, 4));
        }
        return jamsIcons;
    }

    public static boolean is64Bit() {
        boolean is64bit = false;
        is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").indexOf("64") != -1;
        return is64bit;
    }
}

