/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMS;
import jams.JAMSException;
import jams.meta.ComponentField;
import jams.meta.ContextDescriptor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;

public class ContextAttribute {
    private String name = "";
    private String value = "";
    private Class type = null;
    private ContextDescriptor context;
    private HashSet<ComponentField> fields = new HashSet();

    public ContextAttribute(String name, Class type, ContextDescriptor context) {
        this.name = name;
        this.type = type;
        this.context = context;
    }

    private void renameContextAttribute(String newName) {
        HashMap<String, ContextAttribute> attributes = this.getContext().getDynamicAttributes();
        if (attributes.get(newName) != null) {
            throw new JAMSException(MessageFormat.format(JAMS.i18n("Context_attribute_does_already_exist"), newName), JAMS.i18n("Error_renaming_context_attribute"));
        }
        attributes.remove(this.name);
        this.name = newName;
        attributes.put(newName, this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.renameContextAttribute(name);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public ContextDescriptor getContext() {
        return this.context;
    }

    public String toString() {
        return this.name;
    }

    public HashSet<ComponentField> getFields() {
        return this.fields;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }
}

