/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import ucar.nc2.util.net.EasySSLProtocolSocketFactory;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPMethod;

public class HTTPSession {
    static int DFALTTHREADCOUNT = 50;
    static int DFALTTIMEOUT = 300000;
    public static int SC_NOT_FOUND = 404;
    public static int SC_UNAUTHORIZED = 401;
    public static int SC_OK = 200;
    public static String CONNECTION_TIMEOUT = "http.connection.timeout";
    public static String SO_TIMEOUT = "http.socket.timeout";
    public static String USER_AGENT = "http.useragent";
    public static String PROTOCOL_VERSION = "http.protocol.version";
    public static String VIRTUAL_HOST = "http.virtual-host";
    public static String USE_EXPECT_CONTINUE = "http.protocol.expect-continue";
    public static String STRICT_TRANSFER_ENCODING = "http.protocol.strict-transfer-encoding";
    public static String HTTP_ELEMENT_CHARSET = "http.protocol.element-charset";
    public static String HTTP_CONTENT_CHARSET = "http.protocol.content-charset";
    public static String HTTP_CONNECTION = "<undefined>";
    public static String HTTP_PROXY_HOST = "<undefined>";
    public static String HTTP_REQ_SENT = "<undefined>";
    public static String HTTP_REQUEST = "<undefined>";
    public static String HTTP_RESPONSE = "<undefined>";
    public static String HTTP_TARGET_HOST = "<undefined>";
    public static String ORIGIN_SERVER = "<undefined>";
    public static String WAIT_FOR_CONTINUE = "<undefined>";
    protected static MultiThreadedHttpConnectionManager connmgr;
    protected static CredentialsProvider globalProvider;
    protected static String globalAgent;
    protected static int threadcount;
    protected static int globalSoTimeout;
    protected static String globalsimpleproxyhost;
    protected static int globalsimpleproxyport;
    protected static List<HTTPSession> sessionList;
    protected HttpClient sessionClient = null;
    protected HttpState sessionState = null;
    protected CredentialsProvider sessionProvider;
    protected String sessionAgent = "/NetcdfJava/HttpClient4";
    protected List<HTTPMethod> methodList = new Vector<HTTPMethod>();
    HttpState context = null;
    boolean closed = false;
    String useragent = null;
    HashMap<String, Object> globalmethodparams = new HashMap();
    String identifier = "Session";
    protected Authenticator globalAuthenticator = null;

    public static synchronized CredentialsProvider getGlobalCredentialsProvider() {
        return globalProvider;
    }

    public static synchronized void setGlobalCredentialsProvider(CredentialsProvider p) {
        globalProvider = p;
    }

    public static synchronized void setGlobalUserAgent(String _userAgent) {
        globalAgent = _userAgent;
    }

    public static String getGlobalUserAgent() {
        return globalAgent;
    }

    public static void setGlobalConnectionTimeout(long timeout) {
        connmgr.getParams().setConnectionTimeout((int)timeout);
    }

    @Deprecated
    public static void setConnectionManagerTimeout(long timeout) {
        HTTPSession.setGlobalConnectionTimeout(timeout);
    }

    public static void setGlobalSoTimeout(int timeout) {
        globalSoTimeout = timeout;
    }

    public static void setGlobalThreadCount(int nthreads) {
        connmgr.getParams().setMaxTotalConnections(nthreads);
        connmgr.getParams().setDefaultMaxConnectionsPerHost(nthreads);
    }

    public static int getGlobalThreadCount() {
        return connmgr.getParams().getMaxTotalConnections();
    }

    private static synchronized void kill() {
        for (HTTPSession session : sessionList) {
            session.close();
        }
        sessionList.clear();
        connmgr.shutdown();
        connmgr = new MultiThreadedHttpConnectionManager();
        HTTPSession.setGlobalThreadCount(DFALTTHREADCOUNT);
    }

    public HTTPSession() throws HTTPException {
        this("Session");
    }

    public HTTPSession(String id) throws HTTPException {
        this.identifier = id;
        try {
            this.sessionClient = new HttpClient(new HttpClientParams(), connmgr);
            if (globalSoTimeout > 0) {
                this.setSoTimeout(globalSoTimeout);
            }
            this.setProxy();
            if (globalProvider != null) {
                this.sessionClient.getParams().setParameter("http.authentication.credential-provider", globalProvider);
            }
            if (this.useragent != null) {
                this.sessionClient.getParams().setParameter(USER_AGENT, this.useragent);
            } else {
                this.sessionClient.getParams().setParameter(USER_AGENT, globalAgent);
            }
            sessionList.add(this);
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.sessionProvider = provider;
        if (this.sessionClient != null && provider != null) {
            this.sessionClient.getParams().setParameter("http.authentication.credential-provider", provider);
        }
    }

    public void setUserAgent(String agent) {
        this.useragent = agent;
        if (this.useragent != null) {
            this.sessionClient.getParams().setParameter(USER_AGENT, this.useragent);
        }
    }

    public void setSoTimeout(int timeout) {
        this.sessionClient.getParams().setSoTimeout(timeout);
    }

    public void setGlobalMethodParameter(String name, Object value) {
        this.globalmethodparams.put(name, value);
    }

    public synchronized void close() {
        this.closed = true;
        if (this.methodList != null) {
            for (HTTPMethod m : this.methodList) {
                m.close();
                this.removeMethod(m);
            }
        }
    }

    public HTTPMethod newMethodGet(String uri) throws HTTPException {
        return this.newMethod(Methods.Get, uri);
    }

    public HTTPMethod newMethodHead(String uri) throws HTTPException {
        return this.newMethod(Methods.Head, uri);
    }

    public HTTPMethod newMethodPut(String uri) throws HTTPException {
        return this.newMethod(Methods.Put, uri);
    }

    public HTTPMethod newMethodPost(String uri) throws HTTPException {
        return this.newMethod(Methods.Post, uri);
    }

    public HTTPMethod newMethodOptions(String uri) throws HTTPException {
        return this.newMethod(Methods.Options, uri);
    }

    public HTTPMethod newMethod(Methods m, String uri) throws HTTPException {
        assert (!this.closed) : "Attempt to use a closed session";
        HTTPMethod method = new HTTPMethod(m, uri, this);
        this.addMethod(method);
        return method;
    }

    public String getCookiePolicy() {
        return this.sessionClient == null ? null : this.sessionClient.getParams().getCookiePolicy();
    }

    public Cookie[] getCookies() {
        if (this.sessionClient == null) {
            return null;
        }
        Cookie[] cookies = this.sessionClient.getState().getCookies();
        return cookies;
    }

    protected synchronized void addMethod(HTTPMethod m) {
        if (!this.methodList.contains(m)) {
            this.methodList.add(m);
        }
    }

    protected synchronized void removeMethod(HTTPMethod m) {
        if (!this.closed) {
            this.methodList.remove(m);
        }
    }

    public void setContext(HttpState cxt) {
        this.context = cxt;
    }

    public HttpState getContext() {
        return this.context;
    }

    public void clearState() {
        this.sessionClient.getState().clearCookies();
        this.sessionClient.getState().clearCredentials();
    }

    public void setProxy() {
        if (this.sessionClient == null) {
            return;
        }
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host != null && (host = host.trim()).length() == 0) {
            host = null;
        }
        int portno = 0;
        if (port != null && (port = port.trim()).length() > 0) {
            portno = Integer.parseInt(port);
        }
        if (host != null && portno > 0) {
            this.sessionClient.getHostConfiguration().setProxy(host, portno);
        }
    }

    public void setGlobalAuthenticator(String user, String password) {
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        if (user != null && (user = user.trim()).length() == 0) {
            user = null;
        }
        if (user != null && password != null) {
            final PasswordAuthentication pa = new PasswordAuthentication(user, password.toCharArray());
            this.globalAuthenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return pa;
                }
            };
            Authenticator.setDefault(this.globalAuthenticator);
        }
    }

    static void setGlobalSimpleProxy() {
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host != null && port != null) {
            if ((host = host.trim()).length() == 0) {
                host = null;
            }
            int portno = 0;
            if (port != null && (port = port.trim()).length() > 0) {
                try {
                    portno = Integer.parseInt(port);
                }
                catch (NumberFormatException nfe) {
                    portno = 0;
                }
            }
            HTTPSession.setGlobalSimpleProxy(host, portno);
        }
    }

    void setSimpleProxy() {
        if (globalsimpleproxyhost == null) {
            return;
        }
        this.setSimpleProxy(globalsimpleproxyhost, globalsimpleproxyport);
    }

    public static synchronized void setGlobalSimpleProxy(String proxyhost, int proxyport) {
        globalsimpleproxyhost = proxyhost;
        globalsimpleproxyport = proxyport;
    }

    public void setSimpleProxy(String host, int port) {
        if (this.sessionClient == null) {
            return;
        }
        this.sessionClient.getHostConfiguration().setProxy(host, port);
    }

    static {
        globalAgent = "/NetcdfJava/HttpClient3";
        threadcount = DFALTTHREADCOUNT;
        globalSoTimeout = DFALTTIMEOUT;
        globalsimpleproxyhost = null;
        globalsimpleproxyport = 0;
        globalProvider = null;
        connmgr = new MultiThreadedHttpConnectionManager();
        HTTPSession.setGlobalThreadCount(DFALTTHREADCOUNT);
        Protocol.registerProtocol("https", new Protocol("https", new EasySSLProtocolSocketFactory(), 443));
        sessionList = new ArrayList<HTTPSession>();
        HTTPSession.setGlobalConnectionTimeout(DFALTTIMEOUT);
        HTTPSession.setGlobalSoTimeout(DFALTTIMEOUT);
        HTTPSession.setGlobalSimpleProxy();
    }

    static enum Methods {
        Get("get"),
        Head("head"),
        Put("put"),
        Post("post"),
        Options("options");

        private final String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

