/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins.waterml2;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.tools.XMLTools;
import jams.workspace.DataReader;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.Workspace;
import jams.workspace.datatypes.CalendarValue;
import jams.workspace.datatypes.DoubleValue;
import jams.workspace.datatypes.LongValue;
import jams.workspace.datatypes.StringValue;
import jams.workspace.plugins.waterml2.Common;
import jams.workspace.plugins.waterml2.FeatureCollection;
import jams.workspace.plugins.waterml2.ObservationMember;
import jams.workspace.plugins.waterml2.TimeValuePair;
import jams.workspace.plugins.waterml2.WaterML2Exception;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WaterML2Reader
implements DataReader {
    private DefaultDataSet[] currentData = null;
    private int iterator = 0;
    private Document wml2Doc;
    private FeatureCollection result = null;
    private String requestedTimeseriesObservation;
    private String sosURL;
    private transient DefaultHttpClient httpclient;
    private TimeValuePair[] data;
    private long ID;
    private String offering_name;
    private double x;
    private double y;
    private double z;
    private String unit;
    private String parameter = "";

    public DataReader.ReaderType getReaderType() {
        return DataReader.ReaderType.ContentAndMetadataReader;
    }

    private static String htmlResponseToString(HttpResponse response) throws Exception {
        String html;
        HttpEntity entity = response.getEntity();
        BufferedReader buf = new BufferedReader(new InputStreamReader(entity.getContent()));
        String page = "";
        while ((html = buf.readLine()) != null) {
            page = page + html + "\n";
        }
        return page;
    }

    public void setWorkspace(Workspace ws) {
    }

    private static String sendGetRequest(DefaultHttpClient client, HttpGet httpget) throws Exception {
        httpget.setHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; de; rv:1.9.1.8) Gecko/20100202 Firefox/3.5.8 (.NET CLR 3.5.30729)");
        CloseableHttpResponse response = null;
        int retry = 0;
        String result = "";
        System.out.println("Sending Get Request ... ");
        do {
            response = client.execute((HttpUriRequest)httpget);
            result = WaterML2Reader.htmlResponseToString((HttpResponse)response);
            if (retry++ < 3) continue;
            System.out.println("Retried to connect server three times, but was not successful!");
            return null;
        } while (response.getStatusLine().getStatusCode() > 300);
        return result;
    }

    public int init() {
        this.httpclient = new DefaultHttpClient();
        HttpGet sosGET = new HttpGet(this.getSosURL());
        String sosResponse = null;
        try {
            sosResponse = WaterML2Reader.sendGetRequest(this.httpclient, sosGET);
            this.wml2Doc = XMLTools.getDocumentFromString((String)sosResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error while accessing web-service:" + this.getSosURL() + "\nerror:" + e.toString());
        }
        NodeList nodeList = this.wml2Doc.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().matches(".*FeatureCollection")) continue;
            try {
                this.result = new FeatureCollection(node);
                continue;
            }
            catch (WaterML2Exception wex) {
                System.out.println(wex.exception);
                return 0;
            }
        }
        if (this.result == null) {
            return 0;
        }
        if (this.result.observations == null) {
            return 0;
        }
        for (ObservationMember m : this.result.observations) {
            if (m.tsObservation == null) {
                return 0;
            }
            if (m.tsObservation.getId().compareTo(this.requestedTimeseriesObservation) != 0) continue;
            this.data = m.tsObservation.getResult().timeserie.getData();
            this.offering_name = m.tsObservation.getName();
            this.ID = 1L;
            this.x = m.tsObservation.getLocation().point.x;
            this.y = m.tsObservation.getLocation().point.y;
            this.z = m.tsObservation.getLocation().point.h;
            for (TimeValuePair entry : this.data) {
                System.out.println(Common.WML2_TIME_FORMAT.format(entry.time.getTime()) + "\t" + entry.value + " " + entry.unit);
                this.unit = entry.getUnit();
            }
            return this.data.length;
        }
        this.iterator = 0;
        return 0;
    }

    public int numberOfColumns() {
        return 2;
    }

    public int cleanup() {
        return 0;
    }

    private boolean hasNext() {
        return this.iterator < this.data.length;
    }

    private TimeValuePair next() {
        return this.data[this.iterator++];
    }

    public DefaultDataSet getMetadata(int index) {
        DefaultDataSet data = new DefaultDataSet(7);
        data.setData(0, (DataValue)new LongValue(this.ID));
        data.setData(1, (DataValue)new StringValue(this.offering_name));
        data.setData(2, (DataValue)new DoubleValue(this.x));
        data.setData(3, (DataValue)new DoubleValue(this.y));
        data.setData(4, (DataValue)new DoubleValue(this.z));
        if (this.unit != null) {
            data.setData(5, (DataValue)new StringValue(this.unit));
        } else {
            data.setData(5, (DataValue)new StringValue("?"));
        }
        data.setData(6, (DataValue)new StringValue(this.parameter));
        return data;
    }

    private DefaultDataSet getNextDataSet() {
        int numberOfColumns = this.numberOfColumns();
        if (!this.hasNext()) {
            return null;
        }
        TimeValuePair tvp = this.next();
        DefaultDataSet dataSet = new DefaultDataSet(numberOfColumns);
        Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
        cal.setTimeInMillis(tvp.time.getTimeInMillis());
        dataSet.setData(0, (DataValue)new CalendarValue(cal));
        dataSet.setData(1, (DataValue)new DoubleValue(tvp.getValue()));
        return dataSet;
    }

    private DefaultDataSet[] convertData(long count) {
        DefaultDataSet dataSet;
        ArrayList<DefaultDataSet> data = new ArrayList<DefaultDataSet>();
        while ((long)data.size() < count && (dataSet = this.getNextDataSet()) != null) {
            data.add(dataSet);
        }
        return data.toArray(new DefaultDataSet[data.size()]);
    }

    public int fetchValues() {
        this.currentData = this.convertData(Long.MAX_VALUE);
        return 0;
    }

    public int fetchValues(int count) {
        this.currentData = this.convertData(count);
        return 0;
    }

    public DefaultDataSet[] getData() {
        return this.currentData;
    }

    public String getRequestedTimeseriesObservation() {
        return this.requestedTimeseriesObservation;
    }

    public void setRequestedTimeseriesObservation(String requestedTimeseriesObservation) {
        this.requestedTimeseriesObservation = requestedTimeseriesObservation;
    }

    public String getSosURL() {
        return this.sosURL;
    }

    public void setSosURL(String sosURL) {
        this.sosURL = sosURL;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public static void main(String[] arg) throws FileNotFoundException, WaterML2Exception {
        WaterML2Reader wml2Reader = new WaterML2Reader();
        wml2Reader.setSosURL("http://localhost:24000/istSOS/sos.py?request=GetObservation&offering=urn:x-fsu:1.0:offering:592&procedure=urn:ogc:object:procedure:x-fsu:1.0:DAILY&eventTime=2002-02-10T16:00:00/2003-02-10T17:00:00&observedProperty=urn:ogc:def:property:x-fsu:1.0:precipitation&responseFormat=text/xml;subtype='WML2'&service=SOS&version=1.0.0");
        wml2Reader.setRequestedTimeseriesObservation("ts_serie1");
        wml2Reader.init();
    }
}

