/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins.waterml2;

import jams.workspace.plugins.waterml2.Common;
import jams.workspace.plugins.waterml2.WaterML2Exception;
import java.text.ParseException;
import java.util.GregorianCalendar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeValuePair {
    GregorianCalendar time;
    Double value;
    String unit;

    public TimeValuePair() {
        this.unit = "";
    }

    public TimeValuePair(Node timeValuePairNode, TimeValuePair defaultTimeValuePair) throws WaterML2Exception {
        NodeList list = timeValuePairNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeName().matches(".*time")) {
                try {
                    if (node.getFirstChild() == null) {
                        throw new WaterML2Exception("invalid timeValuePair date:null");
                    }
                    this.time = Common.parseTime(node.getFirstChild().getNodeValue());
                    continue;
                }
                catch (ParseException pe) {
                    throw new WaterML2Exception("invalid timeValuePair: " + node.getNodeValue());
                }
            }
            if (node.getNodeName().matches(".*value")) {
                try {
                    if (node.getFirstChild() == null) {
                        throw new WaterML2Exception("invalid timeValuePair value:null");
                    }
                    if (node.getFirstChild().getNodeValue().toLowerCase().compareTo("nan") == 0) {
                        this.value = Double.NaN;
                        continue;
                    }
                    if (node.getFirstChild().getNodeValue().toLowerCase().compareTo("inf") == 0) {
                        this.value = Double.POSITIVE_INFINITY;
                        continue;
                    }
                    if (node.getFirstChild().getNodeValue().toLowerCase().compareTo("-inf") == 0) {
                        this.value = Double.NEGATIVE_INFINITY;
                        continue;
                    }
                    this.value = Double.parseDouble(node.getFirstChild().getNodeValue());
                    continue;
                }
                catch (NumberFormatException pe) {
                    throw new WaterML2Exception("invalid double value: " + node.getFirstChild().getNodeValue());
                }
            }
            if (node.getNodeName().matches(".*unitOfMeasure")) {
                this.unit = node.getNodeValue();
                continue;
            }
            if (!node.getNodeName().matches(".*quality") && !node.getNodeName().matches(".*dataType") && !node.getNodeName().matches(".*processing") && !node.getNodeName().matches(".*qualifier")) continue;
        }
        if (defaultTimeValuePair != null) {
            if (this.time == null) {
                this.time = (GregorianCalendar)defaultTimeValuePair.time.clone();
            }
            if (this.value == null) {
                this.value = (double)defaultTimeValuePair.value;
            }
            if (this.unit == null) {
                this.unit = defaultTimeValuePair.unit.substring(0);
            }
        }
    }

    public void setTime(GregorianCalendar time) {
        this.time = time;
    }

    public GregorianCalendar getTime() {
        return this.time;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }
}

