/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins.waterml2;

import jams.workspace.plugins.waterml2.Common;
import jams.workspace.plugins.waterml2.WaterML2Exception;
import java.text.ParseException;
import java.util.GregorianCalendar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentMetadata {
    String generationSystem;
    String version;
    GregorianCalendar generationTime;

    public DocumentMetadata(Node metaDataNode) throws WaterML2Exception {
        NodeList list = metaDataNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeName().matches(".*generationDate")) {
                try {
                    this.generationTime = Common.parseTime(node.getFirstChild().getNodeValue());
                    continue;
                }
                catch (ParseException pe) {
                    throw new WaterML2Exception("generationDate: " + node.getFirstChild().getNodeValue());
                }
            }
            if (node.getNodeName().matches(".*generationSystem")) {
                this.generationSystem = node.getNodeValue();
                continue;
            }
            if (!node.getNodeName().matches(".*version")) continue;
            this.version = node.getNodeValue();
        }
    }
}

