/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.workspace.DataReader;
import jams.workspace.DataSet;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.Workspace;
import jams.workspace.datatypes.CalendarValue;
import jams.workspace.datatypes.DoubleValue;
import jams.workspace.datatypes.LongValue;
import jams.workspace.datatypes.ObjectValue;
import jams.workspace.datatypes.StringValue;
import jams.workspace.plugins.JdbcSQLConnector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class PollingSQL
implements DataReader {
    private static final int DOUBLE = 0;
    private static final int LONG = 1;
    private static final int STRING = 2;
    private static final int TIMESTAMP = 3;
    private static final int OBJECT = 4;
    private String user;
    private String password;
    private String host;
    private String db;
    private String query;
    private String lastDateQuery;
    private String driver;
    private String dateColumnName;
    private String metadataQuery;
    private transient QueryResult metadataResult = null;
    private transient QueryResult dataResult = null;
    private boolean openEnd = false;
    private transient JdbcSQLConnector pgsql = null;
    private DefaultDataSet[] currentData = null;
    private boolean isClosed = true;
    private final boolean alwaysReconnect = false;
    private String lastDate;
    private Long currentDateDB;
    private Long currentDateDS;
    private Long timestep = 3600L;
    int offset = 0;
    DefaultDataSet nextDataSet = null;

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setDateColumnName(String name) {
        this.dateColumnName = name;
    }

    public void setLastDateQuery(String query) {
        this.lastDateQuery = query;
    }

    public void setOpenEnd(String openEnd) {
        this.openEnd = openEnd.equals("true");
    }

    public DefaultDataSet[] getData() {
        return this.currentData;
    }

    public DataReader.ReaderType getReaderType() {
        if (this.metadataQuery != null && this.query != null) {
            return DataReader.ReaderType.ContentAndMetadataReader;
        }
        if (this.metadataQuery != null) {
            return DataReader.ReaderType.MetadataReader;
        }
        if (this.query != null) {
            return DataReader.ReaderType.ContentReader;
        }
        return DataReader.ReaderType.Empty;
    }

    public int numberOfColumns() {
        return this.dataResult.numberOfColumns;
    }

    public String getMetadataQuery() {
        return this.metadataQuery;
    }

    public void setMetadataQuery(String metadataQuery) {
        this.metadataQuery = metadataQuery;
    }

    public int fetchValues() {
        return this.fetchValues(Integer.MAX_VALUE);
    }

    public int fetchValues(int count) {
        if (this.getReaderType() != DataReader.ReaderType.ContentReader && this.getReaderType() != DataReader.ReaderType.ContentAndMetadataReader) {
            return 0;
        }
        if (this.dataResult == null) {
            this.query();
        }
        this.currentData = this.getDBRows(this.dataResult, count);
        return 0;
    }

    public DataSet getMetadata(int i) {
        if (this.getReaderType() != DataReader.ReaderType.MetadataReader && this.getReaderType() != DataReader.ReaderType.ContentAndMetadataReader) {
            return null;
        }
        if (this.isClosed) {
            this.establishConnection();
        }
        if (this.metadataResult == null) {
            this.metadataResult = this.executeQuery(this.getMetadataQuery());
        }
        ArrayList<DefaultDataSet> list = new ArrayList<DefaultDataSet>();
        DefaultDataSet currentMetadata = null;
        while ((currentMetadata = this.getNextDBRow(this.metadataResult)) != null) {
            list.add(currentMetadata);
        }
        return (DataSet)list.get(i);
    }

    private boolean skip(long count) {
        try {
            if (count == 0L) {
                return true;
            }
            if (count > 1L) {
                this.dataResult.rs.relative((int)count - 1);
                this.dataResult.rs.next();
            } else {
                this.dataResult.rs.next();
            }
        }
        catch (SQLException sqlex) {
            System.err.println("PollingSQL: " + sqlex);
            sqlex.printStackTrace();
            return false;
        }
        return true;
    }

    public Attribute.Calendar getLastDate() {
        this.establishConnection();
        try {
            ResultSet rs2 = null;
            rs2 = this.pgsql.execQuery(this.lastDateQuery);
            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
            String date = this.lastDate;
            if (rs2.next()) {
                date = rs2.getString(1);
            }
            cal.setTimeInMillis(Long.parseLong(date) * 1000L);
            rs2.close();
            return cal;
        }
        catch (Exception sqlex) {
            System.err.println("PollingSQL: " + sqlex);
            sqlex.printStackTrace();
            sqlex.printStackTrace();
            return null;
        }
    }

    private DefaultDataSet constructDefaultDataSet(Date date) {
        DefaultDataSet dataSet = new DefaultDataSet(this.dataResult.numberOfColumns);
        block6: for (int j = 0; j < this.dataResult.numberOfColumns; ++j) {
            switch (this.dataResult.type[j]) {
                case 0: {
                    dataSet.setData(j, (DataValue)new DoubleValue(JAMS.getMissingDataValue()));
                    continue block6;
                }
                case 1: {
                    dataSet.setData(j, (DataValue)new LongValue(((Long)JAMS.getMissingDataValue(Long.TYPE)).longValue()));
                    continue block6;
                }
                case 2: {
                    dataSet.setData(j, (DataValue)new StringValue((String)JAMS.getMissingDataValue(String.class)));
                    continue block6;
                }
                case 3: {
                    Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
                    cal.setTime(date);
                    dataSet.setData(j, (DataValue)new CalendarValue(cal));
                    continue block6;
                }
                default: {
                    dataSet.setData(j, (DataValue)new StringValue((String)JAMS.getMissingDataValue(String.class)));
                }
            }
        }
        return dataSet;
    }

    private DefaultDataSet getNextDBRow(QueryResult r) {
        try {
            if (!r.rs.next()) {
                return null;
            }
            ++this.offset;
            DefaultDataSet dataSet = new DefaultDataSet(r.numberOfColumns);
            this.lastDate = r.rs.getString(1);
            this.currentDateDB = Long.parseLong(this.lastDate);
            block10: for (int j = 0; j < r.numberOfColumns; ++j) {
                switch (r.type[j]) {
                    case 0: {
                        DoubleValue value = new DoubleValue(r.rs.getDouble(j + 1));
                        dataSet.setData(j, (DataValue)value);
                        continue block10;
                    }
                    case 1: {
                        DoubleValue value = new LongValue(r.rs.getLong(j + 1));
                        dataSet.setData(j, (DataValue)value);
                        continue block10;
                    }
                    case 2: {
                        DoubleValue value = new StringValue(r.rs.getString(j + 1));
                        dataSet.setData(j, (DataValue)value);
                        continue block10;
                    }
                    case 3: {
                        Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
                        GregorianCalendar greg = new GregorianCalendar();
                        greg.setTimeZone(TimeZone.getTimeZone("GMT"));
                        cal.setTimeInMillis(r.rs.getDate(j + 1, (Calendar)greg).getTime());
                        String date = r.rs.getString(j + 1);
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
                        try {
                            long millis = format.parse(date + " +0000").getTime();
                            cal.setTimeInMillis(millis);
                        }
                        catch (Exception e) {
                            throw new SQLException(e.toString());
                        }
                        DoubleValue value = new CalendarValue(cal);
                        dataSet.setData(j, (DataValue)value);
                        continue block10;
                    }
                    default: {
                        DoubleValue value = new ObjectValue(r.rs.getObject(j + 1));
                        dataSet.setData(j, (DataValue)value);
                    }
                }
            }
            return dataSet;
        }
        catch (SQLException sqlex) {
            System.err.println("PollingSQL: " + sqlex);
            sqlex.printStackTrace();
            sqlex.printStackTrace();
            return null;
        }
    }

    private DefaultDataSet[] getDBRows(QueryResult r, long count) {
        ArrayList<DefaultDataSet> data = new ArrayList<DefaultDataSet>();
        if (r == null || r.rs == null) {
            return null;
        }
        while ((long)data.size() < count) {
            DefaultDataSet dataSet;
            if (this.currentDateDS == null) {
                dataSet = this.getNextDBRow(r);
                data.add(dataSet);
                this.currentDateDS = new Long(this.currentDateDB);
                this.currentDateDS = this.currentDateDS + this.timestep;
                continue;
            }
            if (this.nextDataSet != null) {
                dataSet = this.nextDataSet;
            } else {
                dataSet = this.getNextDBRow(r);
                if (dataSet == null) {
                    if (!this.openEnd) break;
                    dataSet = this.constructDefaultDataSet(new Date(this.currentDateDS));
                    this.currentDateDB = this.currentDateDS;
                }
            }
            if (Math.abs(this.currentDateDB - this.currentDateDS) <= 1800L) {
                this.nextDataSet = null;
                data.add(dataSet);
                this.currentDateDS = this.currentDateDS + this.timestep;
                continue;
            }
            if (this.currentDateDB > this.currentDateDS) {
                this.nextDataSet = dataSet;
                data.add(this.constructDefaultDataSet(new Date(this.currentDateDS)));
                this.currentDateDS = this.currentDateDS + this.timestep;
                continue;
            }
            if (this.currentDateDB >= this.currentDateDS) continue;
            this.nextDataSet = null;
        }
        return data.toArray(new DefaultDataSet[data.size()]);
    }

    QueryResult executeQuery(String query) {
        if (this.isClosed || query == null) {
            return null;
        }
        QueryResult result = new QueryResult();
        try {
            ResultSet rs = null;
            if (rs != null) {
                rs.close();
            }
            rs = !query.contains("LIMIT") ? (query.contains("WHERE") ? this.pgsql.execQuery(query + " AND " + this.dateColumnName + ">\"" + this.lastDate + "\" ORDER BY " + this.dateColumnName + " ASC") : this.pgsql.execQuery(query + " WHERE " + this.dateColumnName + ">\"" + this.lastDate + "\" ORDER BY " + this.dateColumnName + " ASC")) : this.pgsql.execQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            int[] type = new int[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                type[i] = rsmd.getColumnTypeName(i + 1).startsWith("int") || rsmd.getColumnTypeName(i + 1).startsWith("INT") || rsmd.getColumnTypeName(i + 1).startsWith("integer") || rsmd.getColumnTypeName(i + 1).startsWith("INTEGER") ? 1 : (rsmd.getColumnTypeName(i + 1).startsWith("float") || rsmd.getColumnTypeName(i + 1).startsWith("FLOAT") ? 0 : (rsmd.getColumnTypeName(i + 1).startsWith("double") || rsmd.getColumnTypeName(i + 1).startsWith("DOUBLE") ? 0 : (rsmd.getColumnTypeName(i + 1).startsWith("numeric") || rsmd.getColumnTypeName(i + 1).startsWith("NUMERIC") ? 0 : (rsmd.getColumnTypeName(i + 1).startsWith("varchar") || rsmd.getColumnTypeName(i + 1).startsWith("VARCHAR") ? 2 : (rsmd.getColumnTypeName(i + 1).startsWith("datetime") || rsmd.getColumnTypeName(i + 1).startsWith("DATETIME") ? 3 : 4)))));
            }
            result.numberOfColumns = numberOfColumns;
            result.type = type;
            result.rs = rs;
        }
        catch (SQLException sqlex) {
            System.err.println("jdbcSQL: " + sqlex);
            sqlex.printStackTrace();
            return null;
        }
        return result;
    }

    public void query() {
        this.establishConnection();
        this.dataResult = this.executeQuery(this.query);
    }

    void establishConnection() {
        try {
            if (this.pgsql == null) {
                this.pgsql = new JdbcSQLConnector(this.host, this.db, this.user, this.password, this.driver);
                this.pgsql.connect();
                this.isClosed = false;
            } else {
                this.getClass();
            }
        }
        catch (SQLException sqlex) {
            System.err.println("PollingSQL: " + sqlex);
            sqlex.printStackTrace();
            this.isClosed = true;
        }
    }

    public int init() {
        this.offset = 0;
        if (this.db == null) {
            return -1;
        }
        if (this.user == null) {
            return -1;
        }
        if (this.password == null) {
            return -1;
        }
        if (this.host == null) {
            return -1;
        }
        if (this.query == null && this.metadataQuery == null) {
            return -1;
        }
        if (this.driver == null) {
            this.driver = "jdbc:postgresql";
        }
        this.lastDate = "1970-01-01 01:00";
        return 0;
    }

    private int closeResult(QueryResult r) {
        try {
            if (r.rs != null) {
                r.rs.close();
                r.rs = null;
            }
        }
        catch (SQLException sqlex) {
            System.out.println("jdbcSQL: " + sqlex);
            sqlex.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int cleanup() {
        try {
            if (this.closeResult(this.metadataResult) != 0) {
                return -1;
            }
            if (this.closeResult(this.dataResult) != 0) {
                return -1;
            }
            if (this.pgsql != null) {
                this.pgsql.close();
                this.pgsql = null;
                this.isClosed = true;
            }
        }
        catch (SQLException sqlex) {
            System.out.println("jdbcSQL: " + sqlex);
            return -1;
        }
        return 0;
    }

    public void setWorkspace(Workspace ws) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.isClosed) {
            this.cleanup();
            return;
        }
        long ot = System.currentTimeMillis();
        int oldOffset = this.offset;
        this.query();
        long dt = System.currentTimeMillis() - ot;
        System.out.println("recover-time_query:" + dt);
        this.skip(oldOffset);
    }

    static class QueryResult {
        ResultSet rs;
        int numberOfColumns = -1;
        int[] type;

        QueryResult() {
        }
    }
}

