/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning.kernels;

import jams.components.machineLearning.kernels.Kernel;

public class NoNoiseExponential
extends Kernel {
    public NoNoiseExponential(int inputDim) {
        this.inputDim = inputDim;
        this.KernelParameterCount = 2 * inputDim;
        this.parameterCount = 2 * inputDim;
    }

    public double Distance(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = Math.abs(x[i] - y[i]);
            sum += Math.pow(tmp * this.theta[2 * i], this.theta[2 * i + 1]);
        }
        return sum;
    }

    @Override
    public String[] getParameterNames() {
        super.getParameterNames();
        for (int i = 0; i < this.inputDim; ++i) {
            this.KernelParameterNames[2 * i] = "l_" + i;
            this.KernelParameterNames[2 * i + 1] = "alpha_" + i;
        }
        return this.KernelParameterNames;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = this.Distance(x, y);
        return Math.exp(-0.5 * r);
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        return 0.0;
    }
}

