/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.util.Random;

public class Learner
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Entity trainData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Entity validationData;
    protected int DataLength = 0;
    protected int TrainLength = 0;
    protected double[][] data;
    protected double[] result;
    double[][] normed_data;
    protected double[] min;
    protected double[] max;
    protected double[] base;
    protected double pmin;
    protected double pmax;
    protected double pbase;
    Random generator = new Random();
    public boolean normalizeData;

    public void setTrainingData(double[][] data, double[] result) {
        int j;
        int i;
        this.TrainLength = data.length;
        this.DataLength = data[0].length;
        this.data = data;
        this.result = result;
        this.min = new double[this.DataLength];
        this.max = new double[this.DataLength];
        this.base = new double[this.DataLength];
        for (i = 0; i < this.DataLength; ++i) {
            this.min[i] = Double.POSITIVE_INFINITY;
            this.max[i] = Double.NEGATIVE_INFINITY;
            for (j = 0; j < this.TrainLength; ++j) {
                if (data[j][i] < this.min[i]) {
                    this.min[i] = data[j][i];
                }
                if (!(data[j][i] > this.max[i])) continue;
                this.max[i] = data[j][i];
            }
            this.base[i] = (this.min[i] + this.max[i]) / 2.0;
            if (this.min[i] != this.max[i]) continue;
            this.max[i] = this.min[i] + 1.0;
        }
        for (i = 0; i < this.DataLength; ++i) {
            this.pmin = Double.POSITIVE_INFINITY;
            this.pmax = Double.NEGATIVE_INFINITY;
            for (j = 0; j < this.TrainLength; ++j) {
                if (data[j][i] < this.pmin) {
                    this.pmin = data[j][i];
                }
                if (!(data[j][i] > this.pmax)) continue;
                this.pmax = data[j][i];
            }
            this.pbase = (this.pmin + this.pmax) / 2.0;
        }
    }

    public double[] normalize(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = 2.0 * (x[i] - this.base[i]) / (this.max[i] - this.min[i]);
        }
        return result;
    }

    public void normalizeAll() {
        this.normed_data = new double[this.data.length][this.data[0].length];
        for (int i = 0; i < this.data.length; ++i) {
            this.normed_data[i] = this.normalize(this.data[i]);
        }
    }

    public void run() {
        double[][] t1 = (double[][])this.trainData.getObject("data");
        double[] t2 = (double[])this.trainData.getObject("predict");
        this.setTrainingData(t1, t2);
        this.normalizeAll();
    }
}

