/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.components.efficiencies.Regression;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.workspace.DataSetDefinition;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.TSDataStore;
import java.util.ArrayList;

@JAMSComponentDescription(title="TSDataStoreReader", author="Sven Kralisch", date="2014-02-16", version="1.2", description="This component can be used to obtain data from a time series data store which contains only double values and a number of station-specific metadata. Additional functions:\n- automated time shift if start date of datastore is before start date of model\n- automated aggregation if time steps of data store and model differ")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2008-10-20", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2013-06-17", comment="Cache functions removed, minor bug fixes"), @VersionComments.Entry(version="1.1", date="2014-02-16", comment="- Aggregation functions if time steps of data store and model differ\n- Fixed wrong time shift in case of monthly data\n"), @VersionComments.Entry(version="1.1_1", date="2014-05-14", comment="Fixed bug that caused wrong forward skipping if time offset was very long (> 68 years of daily data)"), @VersionComments.Entry(version="1.2", date="2014-06-20", comment="Added attributes to output column names and columns IDs for further use")})
public class TSDataStoreReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Datastore ID")
    public Attribute.String id;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Descriptive name of the dataset (equals datastore ID)")
    public Attribute.String dataSetName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of double values received from the datastore. Order according to datastore")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of column names")
    public Attribute.StringArray name;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of column IDs")
    public Attribute.StringArray columnID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station elevations")
    public Attribute.DoubleArray elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station's x coordinate")
    public Attribute.DoubleArray xCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station's y coordinate")
    public Attribute.DoubleArray yCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The time interval within which the component shall read data from the datastore")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Aggregate multiple datastore entries to averages or sums?", defaultValue="true")
    public Attribute.Boolean calcAvg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current model time - needed in case of aggregation over irregular time steps (e.g. months). Aggregation is disabled if this value is not set.")
    public Attribute.Calendar time;
    private TSDataStore store;
    private double[] doubles;
    private double[] elevationArray;
    boolean shifted = false;
    int tsRatio = 1;
    Attribute.Calendar storeDate;
    int storeUnit;
    int storeUnitCount;
    int targetUnit;
    int targetUnitCount;

    public void init() {
        this.shifted = false;
        InputDataStore is = null;
        if (this.id != null) {
            is = this.getModel().getWorkspace().getInputDataStore(this.id.getValue());
        }
        if (is == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore could not be found!");
            return;
        }
        if (!(is instanceof TSDataStore)) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore is not a time series datastore!");
            return;
        }
        this.store = (TSDataStore)is;
        if (this.store.getStartDate().after(this.timeInterval.getStart()) && this.store.getStartDate().compareTo(this.timeInterval.getStart(), this.timeInterval.getTimeUnit()) != 0) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Start date of datastore (" + this.store.getStartDate() + ") does not match given time interval (" + this.timeInterval.getStart() + ")!");
            return;
        }
        if (this.store.getEndDate().before(this.timeInterval.getEnd()) && this.store.getEndDate().compareTo(this.timeInterval.getEnd(), this.timeInterval.getTimeUnit()) != 0) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": End date of datastore (" + this.store.getEndDate() + ") does not match given time interval (" + this.timeInterval.getEnd() + ")!");
            return;
        }
        DataSetDefinition dsDef = this.store.getDataSetDefinition();
        if (dsDef.getAttributeValues("X") == null) {
            this.getModel().getRuntime().sendHalt("Error in data set definition \"" + this.id + "\" from " + this.getInstanceName() + ": x coordinate not specified");
        }
        if (dsDef.getAttributeValues("Y") == null) {
            this.getModel().getRuntime().sendHalt("Error in data set definition \"" + this.id + "\" from " + this.getInstanceName() + ": y coordinate not specified");
        }
        if (dsDef.getAttributeValues("ELEVATION") == null) {
            this.getModel().getRuntime().sendHalt("Error in data set definition \"" + this.id + "\" from " + this.getInstanceName() + ": elevation not specified");
        }
        this.xCoord.setValue(this.listToDoubleArray(dsDef.getAttributeValues("X")));
        this.yCoord.setValue(this.listToDoubleArray(dsDef.getAttributeValues("Y")));
        this.elevation.setValue(this.listToDoubleArray(dsDef.getAttributeValues("ELEVATION")));
        this.name.setValue(this.listToStringArray(dsDef.getAttributeValues("NAME")));
        this.columnID.setValue(this.listToStringArray(dsDef.getAttributeValues("ID")));
        this.elevationArray = this.elevation.getValue();
        this.dataSetName.setValue(this.id.getValue());
        this.getModel().getRuntime().println("Datastore " + this.id + " initialized!", 3);
        this.doubles = new double[this.store.getDataSetDefinition().getColumnCount()];
        this.dataArray.setValue(this.doubles);
    }

    private double[] listToDoubleArray(ArrayList<Object> list) {
        if (list == null) {
            return null;
        }
        double[] result = new double[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = (Double)o;
            ++i;
        }
        return result;
    }

    private String[] listToStringArray(ArrayList<Object> list) {
        if (list == null) {
            return null;
        }
        String[] result = new String[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = o.toString();
            ++i;
        }
        return result;
    }

    private void checkConsistency() {
        Attribute.Calendar targetDate = this.timeInterval.getStart().clone();
        this.targetUnit = this.timeInterval.getTimeUnit();
        this.targetUnitCount = this.timeInterval.getTimeUnitCount();
        this.storeDate = this.store.getStartDate().clone();
        this.storeUnit = this.store.getTimeUnit();
        this.storeUnitCount = this.store.getTimeUnitCount();
        this.storeDate.removeUnsignificantComponents(this.storeUnit);
        targetDate.removeUnsignificantComponents(this.targetUnit);
        int offset = this.storeDate.compareTo(targetDate, this.targetUnit);
        if (offset > 0) {
            this.getModel().getRuntime().sendHalt("Time series data read by " + this.getInstanceName() + " start after model start time!\n(" + this.store.getStartDate() + " vs " + this.timeInterval.getStart() + ")");
        } else if (offset < 0) {
            int steps;
            long diff = (targetDate.getTimeInMillis() - this.storeDate.getTimeInMillis()) / 1000L;
            switch (this.storeUnit) {
                case 6: {
                    steps = (int)(diff / 3600L / 24L / (long)this.storeUnitCount);
                    this.storeDate.add(this.storeUnit, this.storeUnitCount * steps);
                    break;
                }
                case 11: {
                    steps = (int)(diff / 3600L / (long)this.storeUnitCount);
                    this.storeDate.add(this.storeUnit, this.storeUnitCount * steps);
                    break;
                }
                case 3: {
                    steps = (int)(diff / 3600L / 24L / 7L / (long)this.storeUnitCount);
                    this.storeDate.add(this.storeUnit, this.storeUnitCount * steps);
                    break;
                }
                case 12: {
                    steps = (int)(diff / 60L / (long)this.storeUnitCount);
                    this.storeDate.add(this.storeUnit, this.storeUnitCount * steps);
                    break;
                }
                case 13: {
                    steps = (int)(diff / (long)this.storeUnitCount);
                    this.storeDate.add(this.storeUnit, this.storeUnitCount * steps);
                    break;
                }
                default: {
                    steps = this.iterateStoreDate(targetDate);
                }
            }
            this.store.skip(steps);
        }
        if (this.storeUnit != this.targetUnit || this.storeUnitCount != this.targetUnitCount) {
            if (this.time == null) {
                this.getModel().getRuntime().sendHalt("Time steps in datastore " + this.store.getID() + " and model are different while time is not set! Please set the time atrtibute or adapt your datastore");
            }
            if (this.storeUnit > 2 && this.targetUnit > 2) {
                int storeMS = this.getMilliseconds(this.storeUnit);
                int targetMS = this.getMilliseconds(this.targetUnit);
                double dRatio = (double)(targetMS * this.targetUnitCount) / (double)(storeMS * this.storeUnitCount);
                int ratio = (int)Math.floor(dRatio);
                if ((double)ratio != dRatio) {
                    this.getModel().getRuntime().sendHalt("Time steps in datastore " + this.store.getID() + " and model are incompatible. Please adapt your datastore first!");
                }
                this.tsRatio = ratio;
            } else {
                this.tsRatio = -1;
            }
        }
    }

    private int getMilliseconds(int unit) {
        int ms = 0;
        switch (unit) {
            case 6: {
                ms = 86400000;
                break;
            }
            case 11: {
                ms = 3600000;
                break;
            }
            case 3: {
                ms = 604800000;
                break;
            }
            case 12: {
                ms = 60000;
                break;
            }
            case 13: {
                ms = 1000;
                break;
            }
            case 14: {
                ms = 1;
                break;
            }
            default: {
                this.getModel().getRuntime().sendHalt("Cannot calculate constant time unit duration!");
            }
        }
        return ms;
    }

    private int iterateStoreDate(Attribute.Calendar date) {
        int steps = 0;
        while (this.storeDate.compareTo(date, this.storeUnit) < 0) {
            this.storeDate.add(this.storeUnit, this.storeUnitCount);
            ++steps;
        }
        return steps;
    }

    public void initAll() {
        this.checkConsistency();
    }

    public void run() {
        if (this.tsRatio == 1) {
            DefaultDataSet ds = this.store.getNext();
            if (ds == null) {
                this.getModel().getRuntime().sendHalt("Empty dataset found in component " + this.getInstanceName() + " (" + this.time + ")");
            }
            DataValue[] data = ds.getData();
            for (int i = 1; i < data.length; ++i) {
                this.doubles[i - 1] = data[i].getDouble();
            }
            this.dataArray.setValue(this.doubles);
            this.regCoeff.setValue(Regression.calcLinReg(this.elevationArray, this.doubles));
        } else {
            int i;
            int n;
            if (this.tsRatio < 0) {
                Attribute.Calendar nextTime = this.time.clone();
                nextTime.add(this.targetUnit, this.targetUnitCount);
                n = this.iterateStoreDate(nextTime);
            } else {
                n = this.tsRatio;
            }
            for (i = 0; i < this.doubles.length; ++i) {
                this.doubles[i] = 0.0;
            }
            for (int j = 0; j < n; ++j) {
                DefaultDataSet ds = this.store.getNext();
                DataValue[] data = ds.getData();
                for (int i2 = 1; i2 < data.length; ++i2) {
                    int n2 = i2 - 1;
                    this.doubles[n2] = this.doubles[n2] + data[i2].getDouble();
                }
            }
            if (this.calcAvg.getValue()) {
                i = 0;
                while (i < this.doubles.length) {
                    int n3 = i++;
                    this.doubles[n3] = this.doubles[n3] / (double)n;
                }
            }
            this.dataArray.setValue(this.doubles);
            this.regCoeff.setValue(Regression.calcLinReg(this.elevationArray, this.doubles));
        }
    }

    public void cleanup() {
        this.store.close();
    }
}

