/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="SnowLine", author="Sven Kralisch", description="Calculate whether or not an entity is part of the snow line", date="2021-09-30", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SnowLine
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow water equivalent", defaultValue="0", unit="L")
    public Attribute.Double swe;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity elevation", defaultValue="0", unit="m")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow water equivalent", defaultValue="0", unit="L")
    public Attribute.Double oldSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="probability that this entity is part of the snow line", defaultValue="0")
    public Attribute.Double snowLine;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="probability that this entity is part of the snow line", defaultValue="0")
    public Attribute.Double snowLineElevation;
    private int count = 0;

    public void run() {
        double sl = 0.0;
        if (this.oldSnow.getValue() == 0.0 && this.swe.getValue() != 0.0) {
            sl = 1.0;
        } else if (this.oldSnow.getValue() != 0.0 && this.swe.getValue() == 0.0) {
            sl = 1.0;
        }
        if (sl == 1.0) {
            if (this.snowLineElevation.getValue() == 0.0) {
                this.count = 0;
            }
            this.snowLineElevation.setValue((this.snowLineElevation.getValue() * (double)this.count + this.elevation.getValue()) / (double)(++this.count));
        }
        this.snowLine.setValue(sl);
        this.oldSnow.setValue(this.swe.getValue() == 0.0 ? 0.0 : 1.0);
    }
}

