/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;
import jams.components.indices.TimeSeriesIndicators;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RVector;
import org.rosuda.JRI.Rengine;

@JAMSComponentDescription(title="IHA_DischargeIndicators", author="Sven Kralisch", description="Calculates various discharge indicators based on the Indicators of Hydrological Alteration (IHA) approach. To provide the required environment, run the following commands at the R command line:> install.packages(\"devtools\")\n> library(devtools)\n> install_github(\"mkoohafkan/flowregime\")", date="2019-05-16", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class IHA_DischargeIndicators
extends TimeSeriesIndicators {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of JSON output file (leave empty to disable)")
    public Attribute.String jsonFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Use a local package dir? If yes, component will try to load all packages from the temp dir of the workspave and - if required - will try to download packages automatically from the mirror defined by 'cranMirror'.", defaultValue="false")
    public Attribute.Boolean localPackageDir;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="CRAN mirror to use for packages", defaultValue="https://cran.uni-muenster.de")
    public Attribute.String cranMirror;
    private Rengine re;
    private final String[] efc_strings = new String[]{"extreme low flow", "low flow", "low flow pulse", "high flow pulse", "small flood", "large flood"};
    private boolean inMissingTI = false;

    public void init() {
        REXP x;
        this.re = (Rengine)JAMS.getObjectRepo().get("Rengine");
        if (this.re == null) {
            String[] args = new String[]{"--no-save"};
            this.re = new Rengine(args, false, null);
            this.re.waitForR();
            JAMS.getObjectRepo().put("Rengine", this.re);
        }
        if (this.localPackageDir.getValue()) {
            File libFolder = new File(this.getModel().getWorkspace().getTempDirectory(), "R");
            if (!libFolder.exists() && !libFolder.mkdirs()) {
                this.getModel().getRuntime().sendHalt("Could not create local R package repo in " + libFolder.getAbsolutePath());
            }
            String libPath = libFolder.getAbsolutePath().replace("\\", "/");
            this.re.eval(".libPaths( c('" + libPath + "', .libPaths() ) )");
        }
        if ((x = this.re.eval("library(flowregime)")) == null) {
            if (this.localPackageDir.getValue()) {
                this.re.eval("install.packages('devtools', repos='" + this.cranMirror.getValue() + "')");
                this.re.eval("library(devtools)");
                this.re.eval("install_github('mkoohafkan/flowregime')");
                x = this.re.eval("library(flowregime)");
                if (x == null) {
                    this.getModel().getRuntime().sendHalt("Could not install required R packages");
                }
            } else {
                this.getModel().getRuntime().sendHalt("Could not load required package 'flowregime'");
            }
        }
    }

    public void run() {
        this.readTSData();
        JSONObject json = new JSONObject();
        json.put("nColumns", this.values.length);
        json.put("efcStateNames", (Object)this.efc_strings);
        json.put("dates", (Collection)this.dateStrings);
        JSONObject jsonColumn = new JSONObject();
        json.put("columns", (Object)jsonColumn);
        String[] sArray = this.dateStrings.toArray(new String[this.dateStrings.size()]);
        this.re.assign("sarray", sArray);
        for (int c = 0; c < this.values.length; ++c) {
            String[] states;
            JSONObject colStats = new JSONObject();
            jsonColumn.put(Integer.toString(c), (Object)colStats);
            JSONObject jsonEFCThresholds = new JSONObject();
            colStats.put("efcThresholds", (Object)jsonEFCThresholds);
            JSONObject jsonEFCStates = new JSONObject();
            colStats.put("efcStates", (Object)jsonEFCStates);
            ArrayList<Double> valueList = new ArrayList<Double>();
            ArrayList<String> dateList = new ArrayList<String>();
            ArrayList<String[]> missingTIs = new ArrayList<String[]>();
            for (int i = 0; i < this.values[c].size(); ++i) {
                double d = (Double)this.values[c].get(i);
                if (d == JAMS.getMissingDataValue()) {
                    if (!this.inMissingTI) {
                        String[] gap = new String[2];
                        gap[0] = sArray[i];
                        missingTIs.add(gap);
                        this.inMissingTI = true;
                    }
                } else if (this.inMissingTI) {
                    ((String[])missingTIs.get((int)(missingTIs.size() - 1)))[1] = sArray[i - 1];
                    this.inMissingTI = false;
                }
                if (this.inMissingTI) continue;
                valueList.add(d);
                dateList.add(sArray[i]);
            }
            String[] lastMissing = (String[])missingTIs.get(missingTIs.size() - 1);
            if (lastMissing[1].isEmpty()) {
                lastMissing[1] = sArray[sArray.length - 1];
            }
            colStats.put("missingIntervals", missingTIs);
            double[] valueArray = new double[valueList.size()];
            for (int i = 0; i < valueList.size(); ++i) {
                valueArray[i] = (Double)valueList.get(i);
            }
            String[] dateArray = new String[dateList.size()];
            for (int i = 0; i < dateList.size(); ++i) {
                dateArray[i] = (String)dateList.get(i);
            }
            this.re.assign("varray", valueArray);
            this.re.assign("darray", dateArray);
            this.re.eval("dates <- as.Date(darray)");
            this.re.eval("xts <- xts(x=varray, order.by=dates)");
            REXP x = this.re.eval("build_EFC_thresholds(xts, method = \"advanced\")");
            RVector v = x.asVector();
            for (int i = 0; i < v.size(); ++i) {
                jsonEFCThresholds.put(v.getNames().get(i).toString(), v.at(i).asDouble());
                if (!v.getNames().get(i).toString().equals("high flow")) continue;
                double highFlow = v.at(i).asDouble();
                x = this.re.eval("longest_high_flow_duration(xts, " + highFlow + ")");
                colStats.put("efcHighFlowDuration", x.asDouble());
            }
            this.re.eval("efcs <- EFC(xts, method = \"advanced\")");
            x = this.re.eval("sort(unique(efcs))");
            for (String state : states = x.asStringArray()) {
                x = this.re.eval("efcs==\"" + state + "\"");
                int[] mask = x.asIntArray();
                ArrayList l = new ArrayList(this.values[c].size());
                int j = 0;
                for (int i = 0; i < this.values[c].size(); ++i) {
                    if ((Double)this.values[c].get(i) == JAMS.getMissingDataValue()) {
                        l.add(null);
                        continue;
                    }
                    if (mask[j] == 1) {
                        l.add(this.values[c].get(i));
                    } else {
                        l.add(null);
                    }
                    ++j;
                }
                jsonEFCStates.put(state, l);
            }
        }
        this.re.end();
        if (this.jsonFileName != null) {
            try {
                FileWriter writer = new FileWriter(new File(this.getModel().getWorkspace().getOutputDataDirectory(), this.jsonFileName.getValue()));
                writer.write(json.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(IHA_DischargeIndicators.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println(json.toString());
        }
    }
}

