/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.CTSPlot;
import jams.components.gui.spreadsheet.GraphProperties;
import jams.components.gui.spreadsheet.JAMSTimePlot;
import jams.components.gui.spreadsheet.JXYConfigurator;
import jams.gui.tools.GUIHelper;
import jams.tools.JAMSTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class JTSConfigurator
extends JFrame {
    GroupLayout gLayout;
    GroupLayout.SequentialGroup hGroup;
    GroupLayout.SequentialGroup vGroup;
    GroupLayout.Group group1;
    GroupLayout.Group group2;
    GroupLayout.Group group3;
    GroupLayout.Group group4;
    GroupLayout.Group group5;
    GroupLayout.Group group6;
    GroupLayout.Group group7;
    GroupLayout.Group group8;
    GroupLayout.Group group9;
    GroupLayout.Group group10;
    GroupLayout.Group group11;
    GroupLayout.Group group12;
    GroupLayout.Group group13;
    GroupLayout.Group group14;
    GroupLayout.Group group15;
    private Vector<ActionListener> addAction = new Vector();
    private JFrame parent;
    private JFrame thisDlg;
    private JTSConfigurator thisJTS;
    private JXYConfigurator thisJXY;
    private JPanel frame;
    private JPanel mainpanel;
    private JPanel plotpanel;
    private JPanel optionpanel;
    private JPanel graphpanel;
    private JPanel southpanel;
    private JPanel edTitlePanel;
    private JPanel edLeftAxisPanel;
    private JPanel edRightAxisPanel;
    private JPanel edTimeAxisPanel;
    private JPanel savePanel;
    private JProgressBar bar;
    private JSplitPane split_hor = new JSplitPane(1);
    private JSplitPane split_vert = new JSplitPane(0);
    private JPanel[] datapanels;
    private JScrollPane graphScPane;
    private JScrollPane plotScPane;
    private JScrollPane mainScPane;
    private JScrollPane optScPane;
    private String[] headers;
    private JLabel edTitle = new JLabel("Plot Title: ");
    private JLabel edLeft = new JLabel("Left axis title: ");
    private JLabel edXAxis = new JLabel("X axis title");
    private JLabel edRight = new JLabel("Right axis title: ");
    private JLabel rLeftLabel = new JLabel("Renderer left");
    private JLabel rRightLabel = new JLabel("Renderer right");
    private JLabel invLeftLabel = new JLabel("Invert left axis");
    private JLabel invRightLabel = new JLabel("Invert right axis");
    private JLabel timeFormatLabel = new JLabel("Time format");
    private JTextField edTitleField = new JTextField(14);
    private JTextField edLeftField = new JTextField(14);
    private JTextField edRightField = new JTextField(14);
    private JTextField edXAxisField = new JTextField(14);
    private String[] types = new String[]{"Line and Shape", "Bar", "Area", "Step", "StepArea", "Difference"};
    private JComboBox rLeftBox = new JComboBox<String>(this.types);
    private JComboBox rRightBox = new JComboBox<String>(this.types);
    private JCheckBox invLeftBox = new JCheckBox("Invert left Axis");
    private JCheckBox invRightBox = new JCheckBox("Invert right Axis");
    private JCheckBox timeFormat_yy = new JCheckBox("yy");
    private JCheckBox timeFormat_mm = new JCheckBox("mm");
    private JCheckBox timeFormat_dd = new JCheckBox("dd");
    private JCheckBox timeFormat_hm = new JCheckBox("hh:mm");
    private JButton applyButton = new JButton("Apply");
    private JButton addButton = new JButton("Add Graph");
    private JButton saveButton = new JButton("EPS export");
    private JButton saveTempButton = new JButton("Save Template");
    private JButton loadTempButton = new JButton("Load Template");
    private JProgressBar progressbar;
    private JDialog bardlg;
    private Vector<GraphProperties> propVector = new Vector();
    private JAMSTimePlot jts = new JAMSTimePlot();
    private int index;
    private int colour_cnt;
    HashMap<String, Color> colorTable = new HashMap();
    int[] rows;
    int[] columns;
    JTable table;
    CTSPlot ctsplot;
    int graphCount = 0;
    JCheckBox[] activate;
    JComboBox[] datachoice;
    JComboBox[] poschoice;
    JComboBox[] typechoice;
    JComboBox[] colorchoice;
    ActionListener[] activationChange;
    Runnable plotRunnable = new Runnable(){
        JProgressBar bar;
        {
            this.bar = JTSConfigurator.this.progressbar;
        }

        @Override
        public void run() {
            JTSConfigurator.this.updatePropVector();
            int l = 0;
            int r = 0;
            int rLeft = JTSConfigurator.this.rLeftBox.getSelectedIndex();
            int rRight = JTSConfigurator.this.rRightBox.getSelectedIndex();
            XYLineAndShapeRenderer rendererLeft = new XYLineAndShapeRenderer();
            XYLineAndShapeRenderer rendererRight = new XYLineAndShapeRenderer();
            XYLineAndShapeRenderer lsr_R = new XYLineAndShapeRenderer();
            XYBarRenderer brr_R = new XYBarRenderer();
            XYDifferenceRenderer dfr_R = new XYDifferenceRenderer();
            XYAreaRenderer ar_R = new XYAreaRenderer();
            XYStepRenderer str_R = new XYStepRenderer();
            XYStepAreaRenderer sar_R = new XYStepAreaRenderer();
            XYLineAndShapeRenderer lsr_L = new XYLineAndShapeRenderer();
            XYBarRenderer brr_L = new XYBarRenderer();
            XYDifferenceRenderer dfr_L = new XYDifferenceRenderer();
            XYAreaRenderer ar_L = new XYAreaRenderer();
            XYStepRenderer str_L = new XYStepRenderer();
            XYStepAreaRenderer sar_L = new XYStepAreaRenderer();
            int max = JTSConfigurator.this.propVector.size();
            this.setMax(max);
            for (int i = 0; i < max; ++i) {
                GraphProperties prop = (GraphProperties)JTSConfigurator.this.propVector.get(i);
                if (prop.getPosChoice().getSelectedItem() == "left") {
                    ++l;
                    switch (rLeft) {
                        case 0: {
                            lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                            lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                            lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                            lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                            lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                            lsr_L.setUseOutlinePaint(true);
                            lsr_L.setSeriesFillPaint(i - r, (Paint)prop.getSeriesFillPaint());
                            lsr_L.setUseFillPaint(true);
                            lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                            lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = lsr_L;
                            break;
                        }
                        case 1: {
                            brr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                            brr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                            brr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                            brr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = brr_L;
                            break;
                        }
                        case 2: {
                            ar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                            ar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                            ar_L.setSeriesShape(i - r, prop.getSeriesShape());
                            ar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                            ar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                            ar_L.setOutline(prop.getOutlineVisible());
                            rendererLeft = ar_L;
                            break;
                        }
                        case 3: {
                            str_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                            str_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                            str_L.setSeriesShape(i - r, prop.getSeriesShape());
                            rendererLeft = str_L;
                            break;
                        }
                        case 4: {
                            sar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                            sar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                            sar_L.setSeriesShape(i - r, prop.getSeriesShape());
                            sar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                            sar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                            sar_L.setOutline(prop.getOutlineVisible());
                            rendererLeft = sar_L;
                            break;
                        }
                        case 5: {
                            dfr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                            dfr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                            dfr_L.setSeriesShape(i - r, prop.getSeriesShape());
                            dfr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                            dfr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                            dfr_L.setShapesVisible(prop.getShapesVisible());
                            rendererLeft = dfr_L;
                            break;
                        }
                        default: {
                            lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                            lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                            lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                            lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                            lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                            lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                            lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = lsr_L;
                        }
                    }
                }
                if (prop.getPosChoice().getSelectedItem() == "right") {
                    ++r;
                    switch (rRight) {
                        case 0: {
                            lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                            lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                            lsr_R.setUseOutlinePaint(true);
                            lsr_R.setSeriesFillPaint(i - l, (Paint)prop.getSeriesFillPaint());
                            lsr_R.setUseFillPaint(true);
                            lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = lsr_R;
                            break;
                        }
                        case 1: {
                            brr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            brr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            brr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            brr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = brr_R;
                            break;
                        }
                        case 2: {
                            ar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            ar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            ar_R.setSeriesShape(i - l, prop.getSeriesShape());
                            ar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            ar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = ar_R;
                            break;
                        }
                        case 3: {
                            str_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            str_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            str_R.setSeriesShape(i - l, prop.getSeriesShape());
                            str_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            str_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = str_R;
                            break;
                        }
                        case 4: {
                            sar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            sar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            sar_R.setSeriesShape(i - l, prop.getSeriesShape());
                            sar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            sar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = sar_R;
                            break;
                        }
                        case 5: {
                            dfr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            dfr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            dfr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            dfr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            dfr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            dfr_R.setShapesVisible(prop.getShapesVisible());
                            rendererRight = dfr_R;
                            break;
                        }
                        default: {
                            lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                            lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                            lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = lsr_R;
                        }
                    }
                }
                this.setValue(i);
            }
            if (l > 0) {
                JTSConfigurator.this.jts.plotLeft((XYItemRenderer)rendererLeft, JTSConfigurator.this.edLeftField.getText(), JTSConfigurator.this.edXAxisField.getText(), JTSConfigurator.this.invLeftBox.isSelected());
            }
            if (r > 0) {
                JTSConfigurator.this.jts.plotRight((XYItemRenderer)rendererRight, JTSConfigurator.this.edRightField.getText(), JTSConfigurator.this.edXAxisField.getText(), JTSConfigurator.this.invRightBox.isSelected());
            }
            if (r == 0 && l == 0) {
                JTSConfigurator.this.jts.plotEmpty();
            }
            JTSConfigurator.this.jts.setTitle(JTSConfigurator.this.edTitleField.getText());
            JTSConfigurator.this.jts.setDateFormat(JTSConfigurator.this.timeFormat_yy.isSelected(), JTSConfigurator.this.timeFormat_mm.isSelected(), JTSConfigurator.this.timeFormat_dd.isSelected(), JTSConfigurator.this.timeFormat_hm.isSelected());
            this.hideBarDlg();
        }

        public void setMax(final int max) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        bar.setMinimum(0);
                        bar.setValue(0);
                        bar.setMaximum(max);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setValue(final int value) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        bar.setValue(value);
                        JTSConfigurator.this.bardlg.repaint();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            });
        }

        public void hideBarDlg() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JTSConfigurator.this.bardlg.setVisible(false);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            });
        }
    };
    ActionListener titleListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            JTSConfigurator.this.ctsplot.getChart().setTitle(JTSConfigurator.this.edTitleField.getText());
        }
    };
    ActionListener timeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            JTSConfigurator.this.jts.setDateFormat(JTSConfigurator.this.timeFormat_yy.isSelected(), JTSConfigurator.this.timeFormat_mm.isSelected(), JTSConfigurator.this.timeFormat_dd.isSelected(), JTSConfigurator.this.timeFormat_hm.isSelected());
        }
    };
    ActionListener propbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.ctsplot.getChartPanel().doEditChartProperties();
        }
    };
    ActionListener addbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphProperties prop = JTSConfigurator.this.propVector.size() > 0 ? (GraphProperties)JTSConfigurator.this.propVector.get(0) : new GraphProperties(JTSConfigurator.this.thisJTS);
            JTSConfigurator.this.addGraph(prop);
        }
    };
    ActionListener plotbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.plotAllGraphs();
        }
    };
    ActionListener actChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    ActionListener saveImageAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showSaveDialog(JTSConfigurator.this.thisDlg);
                File file = chooser.getSelectedFile();
                JTSConfigurator.this.jts.saveAsEPS(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    ActionListener saveTempListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.saveTemplate();
        }
    };
    ActionListener loadTempListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.loadTemplate();
        }
    };

    public JTSConfigurator() {
    }

    public JTSConfigurator(JFrame parent, JTable table) {
        this.parent = parent;
        this.setTitle("JAMS JTS Viewer");
        this.setIconImages(JAMSTools.getJAMSIcons());
        this.thisJTS = this;
        this.setLayout(new FlowLayout());
        Point parentloc = parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.table = table;
        this.rows = table.getSelectedRows();
        this.columns = table.getSelectedColumns();
        this.graphCount = this.columns.length;
        this.headers = new String[this.graphCount];
        this.setSize(680, 480);
        this.createPanel();
        this.pack();
        this.setVisible(true);
    }

    private void createProgressBarDlg() {
        this.bardlg = new JDialog();
        this.progressbar = new JProgressBar();
        this.progressbar.setValue(0);
        this.progressbar.setMinimum(0);
        this.progressbar.setMaximum(1);
        this.bardlg.add(this.progressbar);
        this.bardlg.setAlwaysOnTop(true);
        this.bardlg.pack();
        this.bardlg.setLocationRelativeTo(null);
        this.bardlg.setVisible(true);
    }

    private void hideProgressBarDlg() {
        this.bardlg.setVisible(false);
    }

    public void createPanel() {
        this.thisDlg = this;
        this.colour_cnt = 0;
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Renderer");
        JLabel colorLabel = new JLabel("Colour");
        JLabel dataLabel = new JLabel("Select Data / Legend Entry");
        JLabel timeLabel = new JLabel("Time Interval");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry");
        nameLabel.setBackground(Color.DARK_GRAY);
        posLabel.setBackground(Color.DARK_GRAY);
        typeLabel.setBackground(Color.DARK_GRAY);
        colorLabel.setBackground(Color.DARK_GRAY);
        dataLabel.setBackground(Color.DARK_GRAY);
        timeLabel.setBackground(Color.DARK_GRAY);
        this.savePanel = new JPanel();
        GridBagLayout sgbl = new GridBagLayout();
        this.savePanel.setLayout(sgbl);
        GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.saveButton, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.saveTempButton, (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.savePanel, (GridBagLayout)sgbl, (Component)this.loadTempButton, (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        this.saveButton.addActionListener(this.saveImageAction);
        this.saveTempButton.addActionListener(this.saveTempListener);
        this.loadTempButton.addActionListener(this.loadTempListener);
        this.setLayout(new BorderLayout());
        this.plotpanel = new JPanel();
        this.plotpanel.setLayout(new BorderLayout());
        this.frame = new JPanel();
        this.frame.setLayout(new BorderLayout());
        this.graphScPane = new JScrollPane();
        this.optionpanel = new JPanel();
        this.graphpanel = new JPanel();
        this.initGroupUI();
        this.southpanel = new JPanel();
        this.southpanel.setLayout(new FlowLayout());
        this.edTitlePanel = new JPanel();
        this.edTitlePanel.setLayout(new FlowLayout());
        this.edLeftAxisPanel = new JPanel();
        this.edLeftAxisPanel.setLayout(new FlowLayout());
        this.edRightAxisPanel = new JPanel();
        this.edRightAxisPanel.setLayout(new FlowLayout());
        this.edTitleField.setText("Time Series Plot");
        this.edTitleField.setSize(40, 10);
        this.edTitleField.addActionListener(this.plotbuttonclick);
        this.edLeftField.setText("Left Axis Title");
        this.edLeftField.addActionListener(this.plotbuttonclick);
        this.edLeftField.setSize(40, 10);
        this.edRightField.setText("Right Axis Title");
        this.edRightField.addActionListener(this.plotbuttonclick);
        this.edRightField.setSize(40, 10);
        this.edXAxisField.setText("Time");
        this.edXAxisField.addActionListener(this.plotbuttonclick);
        this.applyButton.addActionListener(this.plotbuttonclick);
        this.optionpanel.add(this.edTitle);
        this.optionpanel.add(this.edTitleField);
        this.optionpanel.add(this.edLeft);
        this.optionpanel.add(this.edLeftField);
        this.optionpanel.add(this.edRight);
        this.optionpanel.add(this.edRightField);
        this.optionpanel.add(this.applyButton);
        this.rLeftBox.setSelectedIndex(0);
        this.rRightBox.setSelectedIndex(0);
        for (int k = 0; k < this.graphCount; ++k) {
            GraphProperties prop = new GraphProperties(this.thisJTS);
            prop.setIndex(k);
            prop.setSelectedColumn(this.columns[k]);
            prop.setSelectedRows(this.rows);
            prop.setTimeSTART(this.rows[0]);
            prop.setTimeEND(this.rows[this.rows.length - 1]);
            int color_cnt = k < 9 ? k : 0;
            String[] colors = this.getColorScheme(color_cnt);
            prop.setSeriesPaint(this.colorTable.get(colors[0]));
            prop.setSeriesFillPaint(this.colorTable.get(colors[1]));
            prop.setSeriesOutlinePaint(this.colorTable.get(colors[2]));
            prop.setName(this.table.getColumnName(k + 1));
            prop.setLegendName(this.table.getColumnName(k + 1));
            prop.applyTSProperties();
            this.addPropGroup(prop);
            this.propVector.add(k, prop);
        }
        this.finishGroupUI();
        this.createOptionPanel();
        this.handleRenderer();
        this.jts.setPropVector(this.propVector);
        this.jts.createPlot();
        JPanel graphPanel = new JPanel();
        JPanel optPanel = new JPanel();
        graphPanel.add(this.graphpanel);
        optPanel.add(this.optionpanel);
        this.graphScPane = new JScrollPane(graphPanel);
        this.graphScPane.setVerticalScrollBarPolicy(22);
        this.jts.getPanel().add((Component)this.savePanel, "East");
        this.optionpanel.setBorder(new EtchedBorder());
        this.plotScPane = new JScrollPane(this.jts.getPanel());
        this.optScPane = new JScrollPane(optPanel);
        this.split_hor.add((Component)this.optScPane, 0);
        this.split_hor.add((Component)this.graphScPane, 1);
        this.split_vert.add((Component)this.split_hor, 0);
        this.split_vert.add((Component)this.plotScPane, 1);
        this.add(this.split_vert);
        this.jts.setDateFormat(this.timeFormat_yy.isSelected(), this.timeFormat_mm.isSelected(), this.timeFormat_dd.isSelected(), this.timeFormat_hm.isSelected());
        this.plotAllGraphs();
    }

    private String[] getColorScheme(int scheme) {
        String[] colors = new String[3];
        switch (scheme) {
            case 0: {
                colors[0] = "red";
                colors[1] = "red";
                colors[2] = "gray";
                break;
            }
            case 1: {
                colors[0] = "blue";
                colors[1] = "blue";
                colors[2] = "black";
                break;
            }
            case 2: {
                colors[0] = "green";
                colors[1] = "green";
                colors[2] = "gray";
                break;
            }
            case 3: {
                colors[0] = "black";
                colors[1] = "black";
                colors[2] = "yellow";
                break;
            }
            case 4: {
                colors[0] = "orange";
                colors[1] = "orange";
                colors[2] = "cyan";
                break;
            }
            case 5: {
                colors[0] = "cyan";
                colors[1] = "cyan";
                colors[2] = "black";
                break;
            }
            case 6: {
                colors[0] = "magenta";
                colors[1] = "yellow";
                colors[2] = "magenta";
                break;
            }
            case 7: {
                colors[0] = "lightgray";
                colors[1] = "orange";
                colors[2] = "lightgray";
                break;
            }
            default: {
                colors[0] = "red";
                colors[1] = "blue";
                colors[2] = "red";
            }
        }
        return colors;
    }

    public void addGraph(GraphProperties prop) {
        AddGraphDlg dlg = new AddGraphDlg();
        dlg.setVisible(true);
        if (dlg.getResult()) {
            int i = this.propVector.indexOf(prop);
            GraphProperties newProp = new GraphProperties(this);
            newProp.setPosition(dlg.getSide());
            i = dlg.getPosition();
            dlg.dispose();
            newProp.setSeriesPaint(this.colorTable.get(this.getColorScheme(i)[0]));
            newProp.setSeriesFillPaint(this.colorTable.get(this.getColorScheme(i)[1]));
            newProp.setSeriesOutlinePaint(this.colorTable.get(this.getColorScheme(i)[2]));
            if (i >= 0) {
                int t_s = prop.getTimeChoiceSTART().getSelectedIndex();
                int t_e = prop.getTimeChoiceEND().getSelectedIndex();
                newProp.getTimeChoiceSTART().setSelectedIndex(t_s);
                newProp.getTimeChoiceEND().setSelectedIndex(t_e);
            }
            this.propVector.add(i, newProp);
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            this.handleRenderer();
            for (int k = 0; k < this.graphCount; ++k) {
                newProp = this.propVector.get(k);
                newProp.setIndex(k);
                this.addPropGroup(newProp);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void removeGraph(GraphProperties prop) {
        if (this.graphCount > 1) {
            this.propVector.remove(this.propVector.indexOf(prop));
            this.graphCount = this.propVector.size();
            this.handleRenderer();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties newProp = this.propVector.get(k);
                this.addPropGroup(newProp);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void upGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        if (i - 1 >= 0 && i - 1 < this.graphCount) {
            this.propVector.remove(prop);
            this.propVector.add(i - 1, prop);
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                prop = this.propVector.get(k);
                this.addPropGroup(prop);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void downGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        if (i + 1 < this.propVector.size()) {
            GraphProperties newProp = this.propVector.get(i + 1);
            if (i + 1 >= 0 && i + 1 < this.graphCount) {
                this.propVector.remove(i + 1);
                this.propVector.add(i, newProp);
                this.graphCount = this.propVector.size();
                this.initGroupUI();
                for (int k = 0; k < this.graphCount; ++k) {
                    newProp = this.propVector.get(k);
                    newProp.setIndex(k);
                    this.addPropGroup(newProp);
                }
                this.finishGroupUI();
                this.repaint();
            }
        }
    }

    private void updatePropVector() {
        for (int i = 0; i < this.propVector.size(); ++i) {
            this.propVector.get(i).applyTSProperties();
        }
    }

    public void plotAllGraphs() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JTSConfigurator.this.updatePropVector();
                int l = 0;
                int r = 0;
                int rLeft = JTSConfigurator.this.rLeftBox.getSelectedIndex();
                int rRight = JTSConfigurator.this.rRightBox.getSelectedIndex();
                XYLineAndShapeRenderer rendererLeft = new XYLineAndShapeRenderer();
                XYLineAndShapeRenderer rendererRight = new XYLineAndShapeRenderer();
                XYLineAndShapeRenderer lsr_R = new XYLineAndShapeRenderer();
                XYBarRenderer brr_R = new XYBarRenderer();
                XYDifferenceRenderer dfr_R = new XYDifferenceRenderer();
                XYAreaRenderer ar_R = new XYAreaRenderer();
                XYStepRenderer str_R = new XYStepRenderer();
                XYStepAreaRenderer sar_R = new XYStepAreaRenderer();
                XYLineAndShapeRenderer lsr_L = new XYLineAndShapeRenderer();
                XYBarRenderer brr_L = new XYBarRenderer();
                XYDifferenceRenderer dfr_L = new XYDifferenceRenderer();
                XYAreaRenderer ar_L = new XYAreaRenderer();
                XYStepRenderer str_L = new XYStepRenderer();
                XYStepAreaRenderer sar_L = new XYStepAreaRenderer();
                block16: for (int i = 0; i < JTSConfigurator.this.propVector.size(); ++i) {
                    GraphProperties prop = (GraphProperties)JTSConfigurator.this.propVector.get(i);
                    if (prop.getPosChoice().getSelectedItem() == "left") {
                        ++l;
                        switch (rLeft) {
                            case 0: {
                                lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                                lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                                lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                                lsr_L.setUseOutlinePaint(true);
                                lsr_L.setSeriesFillPaint(i - r, (Paint)prop.getSeriesFillPaint());
                                lsr_L.setUseFillPaint(true);
                                lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                rendererLeft = lsr_L;
                                break;
                            }
                            case 1: {
                                brr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                brr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                brr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                brr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                rendererLeft = brr_L;
                                break;
                            }
                            case 2: {
                                ar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                ar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                ar_L.setSeriesShape(i - r, prop.getSeriesShape());
                                ar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                ar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                ar_L.setOutline(prop.getOutlineVisible());
                                rendererLeft = ar_L;
                                break;
                            }
                            case 3: {
                                str_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                str_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                str_L.setSeriesShape(i - r, prop.getSeriesShape());
                                rendererLeft = str_L;
                                break;
                            }
                            case 4: {
                                sar_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                sar_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                sar_L.setSeriesShape(i - r, prop.getSeriesShape());
                                sar_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                sar_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                sar_L.setOutline(prop.getOutlineVisible());
                                rendererLeft = sar_L;
                                break;
                            }
                            case 5: {
                                dfr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                dfr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                dfr_L.setSeriesShape(i - r, prop.getSeriesShape());
                                dfr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                dfr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                dfr_L.setShapesVisible(prop.getShapesVisible());
                                rendererLeft = dfr_L;
                                break;
                            }
                            default: {
                                lsr_L.setSeriesPaint(i - r, (Paint)prop.getSeriesPaint());
                                lsr_L.setSeriesStroke(i - r, prop.getSeriesStroke());
                                lsr_L.setSeriesShape(i - r, prop.getSeriesShape());
                                lsr_L.setSeriesShapesVisible(i - r, prop.getShapesVisible());
                                lsr_L.setSeriesLinesVisible(i - r, prop.getLinesVisible());
                                lsr_L.setSeriesOutlineStroke(i - r, prop.getSeriesOutlineStroke());
                                lsr_L.setSeriesOutlinePaint(i - r, (Paint)prop.getSeriesOutlinePaint());
                                rendererLeft = lsr_L;
                            }
                        }
                    }
                    if (prop.getPosChoice().getSelectedItem() != "right") continue;
                    ++r;
                    switch (rRight) {
                        case 0: {
                            lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                            lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                            lsr_R.setUseOutlinePaint(true);
                            lsr_R.setSeriesFillPaint(i - l, (Paint)prop.getSeriesFillPaint());
                            lsr_R.setUseFillPaint(true);
                            lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = lsr_R;
                            continue block16;
                        }
                        case 1: {
                            brr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            brr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            brr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            brr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = brr_R;
                            continue block16;
                        }
                        case 2: {
                            ar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            ar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            ar_R.setSeriesShape(i - l, prop.getSeriesShape());
                            ar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            ar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = ar_R;
                            continue block16;
                        }
                        case 3: {
                            str_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            str_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            str_R.setSeriesShape(i - l, prop.getSeriesShape());
                            str_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            str_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = str_R;
                            continue block16;
                        }
                        case 4: {
                            sar_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            sar_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            sar_R.setSeriesShape(i - l, prop.getSeriesShape());
                            sar_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            sar_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = sar_R;
                            continue block16;
                        }
                        case 5: {
                            dfr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            dfr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            dfr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            dfr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            dfr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            dfr_R.setShapesVisible(prop.getShapesVisible());
                            rendererRight = dfr_R;
                            continue block16;
                        }
                        default: {
                            lsr_R.setSeriesPaint(i - l, (Paint)prop.getSeriesPaint());
                            lsr_R.setSeriesStroke(i - l, prop.getSeriesStroke());
                            lsr_R.setSeriesShape(i - l, prop.getSeriesShape());
                            lsr_R.setSeriesShapesVisible(i - l, prop.getShapesVisible());
                            lsr_R.setSeriesLinesVisible(i - l, prop.getLinesVisible());
                            lsr_R.setSeriesOutlineStroke(i - l, prop.getSeriesOutlineStroke());
                            lsr_R.setSeriesOutlinePaint(i - l, (Paint)prop.getSeriesOutlinePaint());
                            rendererRight = lsr_R;
                        }
                    }
                }
                if (l > 0) {
                    JTSConfigurator.this.jts.plotLeft((XYItemRenderer)rendererLeft, JTSConfigurator.this.edLeftField.getText(), JTSConfigurator.this.edXAxisField.getText(), JTSConfigurator.this.invLeftBox.isSelected());
                }
                if (r > 0) {
                    JTSConfigurator.this.jts.plotRight((XYItemRenderer)rendererRight, JTSConfigurator.this.edRightField.getText(), JTSConfigurator.this.edXAxisField.getText(), JTSConfigurator.this.invRightBox.isSelected());
                }
                if (r == 0 && l == 0) {
                    JTSConfigurator.this.jts.plotEmpty();
                }
                JTSConfigurator.this.jts.setTitle(JTSConfigurator.this.edTitleField.getText());
                JTSConfigurator.this.jts.setDateFormat(JTSConfigurator.this.timeFormat_yy.isSelected(), JTSConfigurator.this.timeFormat_mm.isSelected(), JTSConfigurator.this.timeFormat_dd.isSelected(), JTSConfigurator.this.timeFormat_hm.isSelected());
            }
        };
        r.run();
    }

    public void handleRenderer() {
        int r = 0;
        int l = 0;
        for (int i = 0; i < this.propVector.size(); ++i) {
            if (this.propVector.get(i).getPosChoice().getSelectedItem() == "left") {
                ++l;
            }
            if (this.propVector.get(i).getPosChoice().getSelectedItem() != "right") continue;
            ++r;
        }
        if ((l < 2 || l > 2) && this.rLeftBox.getItemCount() == 6) {
            this.rLeftBox.removeItemAt(5);
        }
        if ((r < 2 || r > 2) && this.rRightBox.getItemCount() == 6) {
            this.rRightBox.removeItemAt(5);
        }
        if (l == 2 && this.rLeftBox.getItemCount() == 5) {
            this.rLeftBox.addItem("Difference");
        }
        if (r == 2 && this.rRightBox.getItemCount() == 5) {
            this.rRightBox.addItem("Difference");
        }
    }

    public int getRendererLeft() {
        return this.rLeftBox.getSelectedIndex();
    }

    public int getRendererRight() {
        return this.rRightBox.getSelectedIndex();
    }

    public void setRendererLeft(int type) {
        this.rLeftBox.setSelectedIndex(type);
    }

    public void setRendererRight(int type) {
        this.rRightBox.setSelectedIndex(type);
    }

    private void createOptionPanel() {
        GroupLayout optLayout = new GroupLayout(this.optionpanel);
        JPanel timeFormatPanel = new JPanel();
        timeFormatPanel.add(this.timeFormat_dd);
        timeFormatPanel.add(this.timeFormat_mm);
        timeFormatPanel.add(this.timeFormat_yy);
        timeFormatPanel.add(this.timeFormat_hm);
        this.timeFormat_yy.setSelected(true);
        this.timeFormat_mm.setSelected(true);
        this.timeFormat_dd.setSelected(true);
        this.timeFormat_hm.setSelected(false);
        this.addButton.addActionListener(this.addbuttonclick);
        this.optionpanel.setLayout(optLayout);
        optLayout.setAutoCreateGaps(true);
        optLayout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup optHGroup = optLayout.createSequentialGroup();
        GroupLayout.SequentialGroup optVGroup = optLayout.createSequentialGroup();
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edTitleField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edLeft).addComponent(this.edLeftField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edRight).addComponent(this.edRightField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edXAxis).addComponent(this.edXAxisField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rLeftLabel).addComponent(this.rLeftBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rRightLabel).addComponent(this.rRightBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invLeftBox).addComponent(this.addButton));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invRightBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.timeFormatLabel));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(timeFormatPanel).addComponent(this.applyButton));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edLeft).addComponent(this.edRight).addComponent(this.edXAxis).addComponent(this.rLeftLabel).addComponent(this.rRightLabel).addComponent(this.invLeftBox).addComponent(this.invRightBox).addComponent(this.timeFormatLabel).addComponent(timeFormatPanel));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitleField).addComponent(this.edLeftField).addComponent(this.edRightField).addComponent(this.edXAxisField).addComponent(this.rLeftBox).addComponent(this.rRightBox).addComponent(this.addButton).addGap(1, 1, 1).addComponent(this.applyButton));
        optLayout.setHorizontalGroup(optHGroup);
        optLayout.setVerticalGroup(optVGroup);
    }

    private void initGroupUI() {
        this.graphpanel.removeAll();
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Colour / Position");
        JLabel colorLabel = new JLabel("Type/Colour");
        JLabel dataLabel = new JLabel("Data / Legend Entry");
        JLabel timeLabel = new JLabel("Time Interval");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry: ");
        this.gLayout = new GroupLayout(this.graphpanel);
        this.graphpanel.setLayout(this.gLayout);
        this.gLayout.setAutoCreateGaps(true);
        this.gLayout.setAutoCreateContainerGaps(true);
        this.hGroup = this.gLayout.createSequentialGroup();
        this.vGroup = this.gLayout.createSequentialGroup();
        this.group1 = this.gLayout.createParallelGroup();
        this.group2 = this.gLayout.createParallelGroup();
        this.group3 = this.gLayout.createParallelGroup();
        this.group4 = this.gLayout.createParallelGroup();
        this.group5 = this.gLayout.createParallelGroup();
        this.group6 = this.gLayout.createParallelGroup();
        this.group7 = this.gLayout.createParallelGroup();
        this.group8 = this.gLayout.createParallelGroup();
        this.group9 = this.gLayout.createParallelGroup();
        this.group10 = this.gLayout.createParallelGroup();
        this.group11 = this.gLayout.createParallelGroup();
        this.group12 = this.gLayout.createParallelGroup();
        this.group13 = this.gLayout.createParallelGroup();
        this.group14 = this.gLayout.createParallelGroup();
        this.group15 = this.gLayout.createParallelGroup();
        this.group1.addComponent(dataLabel);
        this.group2.addComponent(timeLabel);
        this.group3.addComponent(typeLabel);
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(dataLabel).addComponent(timeLabel).addComponent(typeLabel));
    }

    private void addPropGroup(GraphProperties prop) {
        JLabel space1 = new JLabel(" ");
        JLabel space2 = new JLabel(" ");
        JLabel space3 = new JLabel(" ");
        JLabel space4 = new JLabel(" ");
        JLabel space5 = new JLabel("   ");
        JLabel space6 = new JLabel("   ");
        JTextField lf = prop.getLegendField();
        this.group6.addComponent(space5).addComponent(space6);
        this.group1.addComponent(prop.getDataChoice()).addComponent(lf).addGap(20);
        this.group2.addComponent(prop.getTimeChoiceSTART()).addComponent(prop.getTimeChoiceEND());
        this.group3.addComponent(prop.getCustomizeButton()).addComponent(prop.getPosChoice());
        this.group9.addComponent(space3);
        this.group11.addComponent(space4);
        this.group13.addComponent(prop.getColorLabel()).addComponent(prop.getRemButton());
        this.group14.addComponent(prop.getUpButton());
        this.group15.addComponent(prop.getDownButton());
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(prop.getDataChoice()).addComponent(prop.getTimeChoiceSTART()).addComponent(space5).addComponent(prop.getCustomizeButton()).addGap(10).addComponent(prop.getColorLabel()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lf).addComponent(prop.getTimeChoiceEND()).addComponent(space6).addComponent(prop.getPosChoice()).addComponent(space3).addComponent(space4).addComponent(prop.getRemButton()).addComponent(prop.getUpButton()).addComponent(prop.getDownButton()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup().addGap(20));
    }

    private void finishGroupUI() {
        this.hGroup.addGroup(this.group1);
        this.hGroup.addGroup(this.group2);
        this.hGroup.addGroup(this.group6);
        this.hGroup.addGroup(this.group3);
        this.hGroup.addGroup(this.group9);
        this.hGroup.addGroup(this.group10);
        this.hGroup.addGroup(this.group11);
        this.hGroup.addGroup(this.group12);
        this.hGroup.addGroup(this.group13);
        this.hGroup.addGroup(this.group14);
        this.hGroup.addGroup(this.group15);
        this.gLayout.setHorizontalGroup(this.hGroup);
        this.gLayout.setVerticalGroup(this.vGroup);
    }

    public JPanel getPanel() {
        return this.mainpanel;
    }

    public JPanel getCTSPlot() {
        return this.ctsplot.getPanel();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    private void saveTemplate() {
        Properties properties = new Properties();
        int no_of_props = this.propVector.size();
        String names = "";
        String number = "" + no_of_props;
        properties.setProperty("number", number);
        properties.setProperty("title", this.edTitleField.getText());
        properties.setProperty("axisLTitle", this.edLeftField.getText());
        properties.setProperty("axisRTitle", this.edRightField.getText());
        properties.setProperty("xAxisTitle", this.edXAxisField.getText());
        properties.setProperty("renderer_left", "" + this.rLeftBox.getSelectedIndex());
        properties.setProperty("renderer_right", "" + this.rRightBox.getSelectedIndex());
        properties.setProperty("inv_left", "" + this.invLeftBox.isSelected());
        properties.setProperty("inv_right", "" + this.invRightBox.isSelected());
        properties.setProperty("timeFormat_yy", "" + this.timeFormat_yy.isSelected());
        properties.setProperty("timeFormat_mmy", "" + this.timeFormat_mm.isSelected());
        properties.setProperty("timeFormat_dd", "" + this.timeFormat_dd.isSelected());
        properties.setProperty("timeFormat_hm", "" + this.timeFormat_hm.isSelected());
        for (int i = 0; i < no_of_props; ++i) {
            GraphProperties gprop = this.propVector.get(i);
            String name = gprop.getName();
            names = i == 0 ? name : names + "," + name;
            properties.setProperty(name + ".legendname", gprop.getLegendName());
            properties.setProperty(name + ".position", gprop.getPosition());
            String stroke_type = "" + gprop.getStrokeType();
            properties.setProperty(name + ".linestroke", stroke_type);
            Color linecolor_load = gprop.getSeriesPaint();
            String stroke_color = "" + linecolor_load.getRed() + "," + linecolor_load.getGreen() + "," + linecolor_load.getBlue();
            properties.setProperty(name + ".linecolor", stroke_color);
            String lines_vis = "" + gprop.getLinesVisible();
            properties.setProperty(name + ".linesvisible", lines_vis);
            String shapes_vis = "" + gprop.getShapesVisible();
            properties.setProperty(name + ".shapesvisible", shapes_vis);
            String shape_type = "" + gprop.getShapeType();
            properties.setProperty(name + ".shapetype", shape_type);
            String size_type = "" + gprop.getSizeType();
            properties.setProperty(name + ".shapesize", size_type);
            Color fillcolor_load = gprop.getSeriesFillPaint();
            String shape_color = "" + fillcolor_load.getRed() + "," + fillcolor_load.getGreen() + "," + fillcolor_load.getBlue();
            properties.setProperty(name + ".shapecolor", shape_color);
            String outline_type = "" + gprop.getOutlineType();
            properties.setProperty(name + ".outlinestroke", outline_type);
            Color outcolor_load = gprop.getSeriesOutlinePaint();
            String outline_color = "" + outcolor_load.getRed() + "," + outcolor_load.getGreen() + "," + outcolor_load.getBlue();
            properties.setProperty(name + ".outlinecolor", outline_color);
        }
        properties.setProperty("names", names);
        try {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(this.thisDlg);
            File file = chooser.getSelectedFile();
            FileOutputStream fout = new FileOutputStream(file);
            properties.store(fout, "");
            fout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadTemplate() {
        Properties properties = new Properties();
        boolean load_prop = false;
        int returnVal = -1;
        try {
            JFileChooser chooser = new JFileChooser();
            returnVal = chooser.showOpenDialog(this.thisDlg);
            File file = chooser.getSelectedFile();
            FileInputStream fin = new FileInputStream(file);
            properties.load(fin);
            fin.close();
        }
        catch (Exception fnfexc) {
            returnVal = -1;
        }
        if (returnVal == 0) {
            int no_of_props;
            this.propVector = new Vector();
            String names = properties.getProperty("names");
            this.graphCount = no_of_props = new Integer(properties.getProperty("number")).intValue();
            StringTokenizer nameTokenizer = new StringTokenizer(names, ",");
            this.initGroupUI();
            for (int i = 0; i < no_of_props; ++i) {
                load_prop = false;
                GraphProperties gprop = new GraphProperties(this);
                if (!nameTokenizer.hasMoreTokens()) continue;
                String name = nameTokenizer.nextToken();
                for (int k = 0; k < this.table.getColumnCount(); ++k) {
                    if (this.table.getColumnName(k).compareTo(name) != 0) continue;
                    gprop.setSelectedColumn(k);
                    load_prop = true;
                    break;
                }
                if (load_prop) {
                    gprop.setLegendName(properties.getProperty(name + ".legendname", "legend name"));
                    gprop.setPosition(properties.getProperty(name + ".position"));
                    gprop.setTimeSTART(0);
                    gprop.setTimeEND(this.table.getRowCount() - 1);
                    gprop.setName(name);
                    gprop.setStroke(new Integer(properties.getProperty(name + ".linestroke", "2")));
                    gprop.setStrokeSlider(gprop.getStrokeType());
                    String stroke_color = properties.getProperty(name + ".linecolor", "255,0,0");
                    StringTokenizer colorTokenizer = new StringTokenizer(stroke_color, ",");
                    gprop.setSeriesPaint(new Color(new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken()), new Integer(colorTokenizer.nextToken())));
                    boolean lv = new Boolean(properties.getProperty(name + ".linesvisible"));
                    gprop.setLinesVisible(lv);
                    gprop.setLinesVisBox(lv);
                    boolean sv = new Boolean(properties.getProperty(name + ".shapesvisible"));
                    gprop.setShapesVisible(sv);
                    gprop.setShapesVisBox(sv);
                    int stype = new Integer(properties.getProperty(name + ".shapetype", "0"));
                    int ssize = new Integer(properties.getProperty(name + ".shapesize"));
                    gprop.setShape(stype, ssize);
                    gprop.setShapeBox(stype);
                    gprop.setShapeSlider(ssize);
                    String shape_color = properties.getProperty(name + ".shapecolor", "255,0,0");
                    StringTokenizer shapeTokenizer = new StringTokenizer(shape_color, ",");
                    gprop.setSeriesFillPaint(new Color(new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken()), new Integer(shapeTokenizer.nextToken())));
                    int os = new Integer(properties.getProperty(name + ".outlinestroke"));
                    gprop.setOutlineStroke(os);
                    gprop.setOutlineSlider(os);
                    String outline_color = properties.getProperty(name + ".outlinecolor", "255,0,0");
                    StringTokenizer outTokenizer = new StringTokenizer(outline_color, ",");
                    gprop.setSeriesOutlinePaint(new Color(new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken()), new Integer(outTokenizer.nextToken())));
                    gprop.applyTSProperties();
                    this.propVector.add(gprop);
                    this.addPropGroup(gprop);
                }
                this.edTitleField.setText(properties.getProperty("title"));
                this.edLeftField.setText(properties.getProperty("axisLTitle"));
                this.edRightField.setText(properties.getProperty("axisRTitle"));
                this.edXAxisField.setText(properties.getProperty("xAxisTitle"));
                this.rLeftBox.setSelectedIndex(new Integer(properties.getProperty("renderer_left")));
                this.rRightBox.setSelectedIndex(new Integer(properties.getProperty("renderer_right")));
                this.invLeftBox.setSelected(new Boolean(properties.getProperty("inv_left")));
                this.invRightBox.setSelected(new Boolean(properties.getProperty("inv_right")));
                this.timeFormat_yy.setSelected(new Boolean(properties.getProperty("timeFormat_yy")));
                this.timeFormat_mm.setSelected(new Boolean(properties.getProperty("timeFormat_mmy")));
                this.timeFormat_dd.setSelected(new Boolean(properties.getProperty("timeFormat_dd")));
                this.timeFormat_hm.setSelected(new Boolean(properties.getProperty("timeFormat_hm")));
            }
            this.finishGroupUI();
            this.jts.setPropVector(this.propVector);
            this.plotAllGraphs();
        }
    }

    private class AddGraphDlg
    extends JDialog {
        boolean result;
        int max;
        String side;
        int side_index;
        int position;
        JSpinner posSpinner;
        JComboBox sideChoice;
        JButton okButton;
        JLabel pos_label;
        JLabel side_label;
        ActionListener ok;

        public AddGraphDlg() {
            super(JTSConfigurator.this.thisDlg, "Add Graph", true);
            this.result = false;
            this.ok = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddGraphDlg.this.side_index = AddGraphDlg.this.sideChoice.getSelectedIndex();
                    AddGraphDlg.this.position = (Integer)AddGraphDlg.this.posSpinner.getValue();
                    AddGraphDlg.this.result = true;
                    AddGraphDlg.this.setVisible(false);
                }
            };
            this.setIconImages(JAMSTools.getJAMSIcons());
            Point parentloc = JTSConfigurator.this.parent.getLocation();
            this.setLocation(parentloc.x + 50, parentloc.y + 50);
            this.createPanel();
        }

        void createPanel() {
            this.setLayout(new FlowLayout());
            this.max = JTSConfigurator.this.propVector.size();
            String[] posArray = new String[]{"left", "right"};
            this.posSpinner = this.max > 0 ? new JSpinner(new SpinnerNumberModel(this.max, 1, this.max, 1)) : new JSpinner(new SpinnerNumberModel(0, 0, 0, 0));
            this.sideChoice = new JComboBox<String>(posArray);
            this.sideChoice.setSelectedIndex(0);
            JButton okButton = new JButton("OK");
            this.pos_label = new JLabel("position after: ");
            this.side_label = new JLabel("side: ");
            this.add(this.side_label);
            this.add(this.sideChoice);
            this.add(this.pos_label);
            this.add(this.posSpinner);
            this.add(okButton);
            okButton.addActionListener(this.ok);
            this.pack();
        }

        String getSide() {
            this.side = this.side_index == 0 ? "left" : "right";
            return this.side;
        }

        int getPosition() {
            return this.position;
        }

        boolean getResult() {
            return this.result;
        }
    }
}

