/*
 * Decompiled with CFR 0.152.
 */
package jams.components.core;

import jams.data.Attribute;
import jams.data.JAMSLong;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.Context;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;

@JAMSComponentDescription(title="Nested temporal context", author="Sven Kralisch", date="2018-11-16", version="1.0_0", description="This component represents a JAMS context which can be used to represent iteration over discrete time steps typically used in conceptional environmental models. In addition, this context can be nested within another temporal context to iterate over sub-timesteps.")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2018-11-16", comment="Initial Version")})
public class TemporalNestedContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current outer date/time")
    public Attribute.Calendar outerTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Significant component of outer date/time:\n0 - YEAR\n1 - MONTH\n2 - WEEK\n3 - DAY\n4 - HOUR\n5 - MINUTE\n6 - SECOND\n")
    public Attribute.Integer significantComponent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Step size of inner date/time iteration:\n0 - YEAR\n1 - MONTH\n2 - WEEK\n3 - DAY\n4 - HOUR\n5 - MINUTE\n6 - SECOND\n")
    public Attribute.Integer stepSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Step count of inner date/time iteration", defaultValue="1")
    public Attribute.Integer stepCount;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current date/time of temporal context")
    public Attribute.Calendar current;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Print the current time every \"printTime\" time steps", defaultValue="0")
    public Attribute.Integer printTime;
    private Attribute.Calendar startTime;
    private Attribute.Calendar endTime;
    private Attribute.Calendar lastTime;
    private int counter = 0;
    private long timestepCount = -1L;
    private static int[] DATE_FIELDS = new int[]{1, 2, 3, 5, 11, 12, 13};

    protected DataTracer createDataTracer(OutputDataStore store) {
        return new AbstractTracer((Context)this, store, JAMSLong.class){

            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String string;
                    if (filter.getContext() == TemporalNestedContext.this || filter.isFiltered(string = filter.getContext().getTraceMark())) continue;
                    return;
                }
                String traceMark = TemporalNestedContext.this.getTraceMark();
                for (Filter filter : this.store.getFilters()) {
                    if (filter.getContext() != TemporalNestedContext.this || filter.isFiltered(traceMark)) continue;
                    return;
                }
                if (!this.hasOutput()) {
                    this.setOutput(true);
                    this.startMark();
                }
                this.output(traceMark);
                for (Filter filter : this.getAccessorObjects()) {
                    this.output(filter.getComponentObject());
                }
                this.nextRow();
                this.flush();
            }
        };
    }

    public void init() {
        super.init();
        if (this.outerTime == null) {
            this.getModel().getRuntime().sendErrorMsg("No outer date/time provided");
        }
        if (this.current == null) {
            this.current = this.getModel().getRuntime().getDataFactory().createCalendar();
        }
    }

    public void initAll() {
        super.initAll();
    }

    public void cleanupAll() {
        super.cleanupAll();
    }

    private void calcStartEnd(Attribute.Calendar time) {
        int i;
        this.endTime = time.clone();
        for (i = this.significantComponent.getValue() + 1; i < DATE_FIELDS.length; ++i) {
            if (i == 2) continue;
            this.endTime.set(DATE_FIELDS[i], this.endTime.getActualMaximum(DATE_FIELDS[i]));
        }
        this.lastTime = this.endTime.clone();
        this.lastTime.add(DATE_FIELDS[this.stepSize.getValue()], -this.stepCount.getValue());
        this.startTime = time.clone();
        for (i = this.significantComponent.getValue() + 1; i < DATE_FIELDS.length; ++i) {
            if (i == 2) continue;
            this.startTime.set(DATE_FIELDS[i], this.startTime.getActualMinimum(DATE_FIELDS[i]));
        }
    }

    public void run() {
        this.calcStartEnd(this.outerTime);
        super.run();
        if (!this.isPaused) {
            for (DataTracer dataTracer : this.dataTracers) {
                if (!dataTracer.hasOutput()) continue;
                dataTracer.endMark();
                dataTracer.setOutput(false);
            }
        }
    }

    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getRunEnumerator() {
        if (!this.components.isEmpty()) {
            return new ComponentEnumerator(){
                ComponentEnumerator ce;
                {
                    this.ce = TemporalNestedContext.this.getTCChildrenEnumerator();
                }

                public boolean hasNext() {
                    boolean nextTime = TemporalNestedContext.this.current.before(TemporalNestedContext.this.lastTime);
                    boolean nextComp = this.ce.hasNext();
                    return nextTime || nextComp;
                }

                public boolean hasPrevious() {
                    boolean prevTime = TemporalNestedContext.this.current.after(TemporalNestedContext.this.startTime);
                    boolean prevComp = this.ce.hasPrevious();
                    return prevTime || prevComp;
                }

                public Component next() {
                    if (!this.ce.hasNext() && TemporalNestedContext.this.current.before(TemporalNestedContext.this.lastTime)) {
                        for (DataTracer dataTracer : TemporalNestedContext.this.getDataTracers()) {
                            dataTracer.trace();
                        }
                        TemporalNestedContext.this.current.add(DATE_FIELDS[TemporalNestedContext.this.stepSize.getValue()], TemporalNestedContext.this.stepCount.getValue());
                        this.printTime();
                        this.ce.reset();
                    }
                    return this.ce.next();
                }

                public void reset() {
                    TemporalNestedContext.this.current.setValue(TemporalNestedContext.this.startTime.getValue());
                    this.printTime();
                    this.ce.reset();
                }

                public Component previous() {
                    if (this.ce.hasPrevious()) {
                        return this.ce.previous();
                    }
                    TemporalNestedContext.this.current.add(TemporalNestedContext.this.stepSize.getValue(), -TemporalNestedContext.this.stepCount.getValue());
                    while (this.ce.hasNext()) {
                        this.ce.next();
                    }
                    return this.ce.previous();
                }

                private void printTime() {
                    if (TemporalNestedContext.this.printTime.getValue() > 0) {
                        if (TemporalNestedContext.this.counter % TemporalNestedContext.this.printTime.getValue() == 0) {
                            TemporalNestedContext.this.counter = 0;
                            TemporalNestedContext.this.getModel().getRuntime().println(TemporalNestedContext.this.getInstanceName() + " " + TemporalNestedContext.this.current, 0);
                        }
                        TemporalNestedContext.this.counter++;
                    }
                }
            };
        }
        return new ComponentEnumerator(){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }

            public Component next() {
                return null;
            }

            public Component previous() {
                return null;
            }

            public void reset() {
            }
        };
    }

    private DataTracer[] getDataTracers() {
        return this.dataTracers;
    }

    private ComponentEnumerator getTCChildrenEnumerator() {
        return this.getChildrenEnumerator();
    }

    public long getNumberOfIterations() {
        Attribute.Calendar cal = this.getModel().getRuntime().getDataFactory().createCalendar();
        cal.set(1970, 3, 1, 0, 0, 0);
        this.calcStartEnd(cal);
        Attribute.Calendar start = this.startTime.clone();
        Attribute.Calendar end = this.endTime.clone();
        long count = 1L;
        start.add(DATE_FIELDS[this.stepSize.getValue()], this.stepCount.getValue());
        while (!start.after(end)) {
            ++count;
            start.add(DATE_FIELDS[this.stepSize.getValue()], this.stepCount.getValue());
        }
        return count;
    }

    public String getTraceMark() {
        return this.current.toString();
    }
}

