/*
 * Decompiled with CFR 0.152.
 */
package jams.components.core;

import jams.JAMS;
import jams.components.core.TemporalContext;
import jams.data.Attribute;
import jams.data.JAMSLong;
import jams.io.BufferedFileReader;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.Context;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

@JAMSComponentDescription(title="TemporalFileInputContext", author="Sven Kralisch", description="Context that iterates over lines in a tab-separated text file and offers the current time step stored in the first column (attribute \"time\") and the data in other columns (attribute \"values\").", date="2018-09-12", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2018-09-12", comment="Initial version")})
public class TemporalFileInputContext
extends TemporalContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The name of the file to read from")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The key word that indicates the start of the data section", defaultValue="@start")
    public Attribute.String startIndicator;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Description")
    public Attribute.Double[] values;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The current time, if \"parseDateTime\" was set to \"true\"")
    public Attribute.Calendar time;
    private transient BufferedFileReader fileReader;
    private String line;
    private int counter;

    @Override
    protected DataTracer createDataTracer(OutputDataStore store) {
        return new AbstractTracer((Context)this, store, JAMSLong.class){

            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String string;
                    if (filter.getContext() == TemporalFileInputContext.this || filter.isFiltered(string = filter.getContext().getTraceMark())) continue;
                    return;
                }
                String traceMark = TemporalFileInputContext.this.getTraceMark();
                for (Filter filter : this.store.getFilters()) {
                    if (filter.getContext() != TemporalFileInputContext.this || filter.isFiltered(traceMark)) continue;
                    return;
                }
                if (!this.hasOutput()) {
                    this.setOutput(true);
                    this.startMark();
                }
                this.output(traceMark);
                for (Filter filter : this.getAccessorObjects()) {
                    this.output(filter.getComponentObject());
                }
                this.nextRow();
                this.flush();
            }
        };
    }

    @Override
    public void init() {
        this.timeInterval = this.getModel().getRuntime().getDataFactory().createTimeInterval();
        this.timeInterval.setValue("1970-01-01 00:00 1970-01-01 00:00 1 1");
        super.init();
        this.initFile();
    }

    @Override
    public void initAll() {
        super.initAll();
    }

    @Override
    public void cleanupAll() {
        super.cleanupAll();
    }

    private void initFile() {
        try {
            this.fileReader = new BufferedFileReader(new FileInputStream(new File(this.getModel().getWorkspacePath(), this.fileName.getValue())), JAMS.getCharset());
            while ((this.line = this.fileReader.readLine()) != null && !this.line.startsWith(this.startIndicator.getValue())) {
            }
            this.line = this.fileReader.readLine();
            int i = 0;
            boolean first = true;
            for (String value : this.line.split("\\s+")) {
                if (first) {
                    this.time.setValue(value);
                    first = false;
                    continue;
                }
                this.values[i].setValue(value);
                ++i;
            }
            this.counter = 0;
        }
        catch (FileNotFoundException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    @Override
    public void run() {
        super.run();
        if (!this.isPaused) {
            for (DataTracer dataTracer : this.dataTracers) {
                if (!dataTracer.hasOutput()) continue;
                dataTracer.endMark();
                dataTracer.setOutput(false);
            }
        }
    }

    public void cleanup() {
        super.cleanup();
        try {
            this.fileReader.close();
        }
        catch (IOException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    @Override
    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getInitEnumerator();
    }

    @Override
    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getInitEnumerator();
    }

    @Override
    protected ComponentEnumerator getRunEnumerator() {
        if (!this.components.isEmpty()) {
            return new ComponentEnumerator(){
                ComponentEnumerator ce;
                {
                    this.ce = TemporalFileInputContext.this.getFICChildrenEnumerator();
                }

                public boolean hasNext() {
                    boolean nextComp = this.ce.hasNext();
                    if (!nextComp) {
                        try {
                            TemporalFileInputContext.this.line = TemporalFileInputContext.this.fileReader.readLine();
                        }
                        catch (IOException ex) {
                            TemporalFileInputContext.this.getModel().getRuntime().handle((Throwable)ex);
                        }
                    }
                    boolean nextLine = TemporalFileInputContext.this.line != null;
                    return nextLine || nextComp;
                }

                public boolean hasPrevious() {
                    boolean prevLine = false;
                    boolean prevComp = this.ce.hasPrevious();
                    return prevLine || prevComp;
                }

                public Component next() {
                    if (!this.ce.hasNext() && TemporalFileInputContext.this.line != null) {
                        for (DataTracer dataTracer : TemporalFileInputContext.this.getDataTracers()) {
                            dataTracer.trace();
                        }
                        int i = 0;
                        boolean first = true;
                        for (String value : TemporalFileInputContext.this.line.split("\\s+")) {
                            if (first) {
                                TemporalFileInputContext.this.time.setValue(value);
                                first = false;
                                continue;
                            }
                            TemporalFileInputContext.this.values[i].setValue(value);
                            ++i;
                        }
                        TemporalFileInputContext.this.counter++;
                        this.ce.reset();
                    }
                    return this.ce.next();
                }

                public void reset() {
                    TemporalFileInputContext.this.initFile();
                    this.ce.reset();
                }

                public Component previous() {
                    if (this.ce.hasPrevious()) {
                        return this.ce.previous();
                    }
                    return null;
                }
            };
        }
        return new ComponentEnumerator(){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }

            public Component next() {
                return null;
            }

            public Component previous() {
                return null;
            }

            public void reset() {
            }
        };
    }

    private ComponentEnumerator getFICChildrenEnumerator() {
        return this.getChildrenEnumerator();
    }

    private DataTracer[] getDataTracers() {
        return this.dataTracers;
    }

    @Override
    public long getNumberOfIterations() {
        return 1L;
    }

    @Override
    public String getTraceMark() {
        return this.time.toString();
    }
}

