/*
 * Decompiled with CFR 0.152.
 */
package jams.components.core;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSLong;
import jams.io.BufferedFileReader;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.Context;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

@JAMSComponentDescription(title="FileInputContext", author="Sven Kralisch", description="Context that iterates over lines in a tab-separated text file and offers the stored data in different columns (attribute \"values\").", date="2018-09-14", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2018-09-14", comment="Some improvements")})
public class FileInputContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The name of the file to read from")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The key word that indicates the start of the data section", defaultValue="@start")
    public Attribute.String startIndicator;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Values that were read from file")
    public Attribute.Double[] values;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current iteration number")
    public Attribute.Double counter;
    private transient BufferedFileReader fileReader;
    private String line;
    private int counter_;

    protected DataTracer createDataTracer(OutputDataStore store) {
        return new AbstractTracer((Context)this, store, JAMSLong.class){

            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String string;
                    if (filter.getContext() == FileInputContext.this || filter.isFiltered(string = filter.getContext().getTraceMark())) continue;
                    return;
                }
                String traceMark = FileInputContext.this.getTraceMark();
                for (Filter filter : this.store.getFilters()) {
                    if (filter.getContext() != FileInputContext.this || filter.isFiltered(traceMark)) continue;
                    return;
                }
                if (!this.hasOutput()) {
                    this.setOutput(true);
                    this.startMark();
                }
                this.output(traceMark);
                for (Filter filter : this.getAccessorObjects()) {
                    this.output(filter.getComponentObject());
                }
                this.nextRow();
                this.flush();
            }
        };
    }

    public void init() {
        super.init();
        this.initFile();
    }

    public void initAll() {
        super.initAll();
    }

    public void cleanupAll() {
        super.cleanupAll();
    }

    private void initFile() {
        try {
            this.fileReader = new BufferedFileReader(new FileInputStream(new File(this.getModel().getWorkspacePath(), this.fileName.getValue())), JAMS.getCharset());
            while ((this.line = this.fileReader.readLine()) != null && !this.line.startsWith(this.startIndicator.getValue())) {
            }
            this.line = this.fileReader.readLine();
            int i = 0;
            boolean first = true;
            for (String value : this.line.split("\\s+")) {
                this.values[i].setValue(value);
                ++i;
            }
            this.counter_ = 0;
            this.counter.setValue((double)this.counter_);
        }
        catch (FileNotFoundException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    public void run() {
        super.run();
        if (!this.isPaused) {
            for (DataTracer dataTracer : this.dataTracers) {
                if (!dataTracer.hasOutput()) continue;
                dataTracer.endMark();
                dataTracer.setOutput(false);
            }
        }
    }

    public void cleanup() {
        super.cleanup();
        try {
            this.fileReader.close();
        }
        catch (IOException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getRunEnumerator() {
        if (!this.components.isEmpty()) {
            return new ComponentEnumerator(){
                ComponentEnumerator ce;
                {
                    this.ce = FileInputContext.this.getFICChildrenEnumerator();
                }

                public boolean hasNext() {
                    boolean nextComp = this.ce.hasNext();
                    if (!nextComp) {
                        try {
                            FileInputContext.this.line = FileInputContext.this.fileReader.readLine();
                        }
                        catch (IOException ex) {
                            FileInputContext.this.getModel().getRuntime().handle((Throwable)ex);
                        }
                    }
                    boolean nextLine = FileInputContext.this.line != null;
                    return nextLine || nextComp;
                }

                public boolean hasPrevious() {
                    boolean prevLine = false;
                    boolean prevComp = this.ce.hasPrevious();
                    return prevLine || prevComp;
                }

                public Component next() {
                    if (!this.ce.hasNext() && FileInputContext.this.line != null) {
                        for (DataTracer dataTracer : FileInputContext.this.getDataTracers()) {
                            dataTracer.trace();
                        }
                        int i = 0;
                        boolean first = true;
                        for (String value : FileInputContext.this.line.split("\\s+")) {
                            FileInputContext.this.values[i].setValue(value);
                            ++i;
                        }
                        FileInputContext.this.counter_++;
                        FileInputContext.this.counter.setValue((double)FileInputContext.this.counter_);
                        this.ce.reset();
                    }
                    return this.ce.next();
                }

                public void reset() {
                    FileInputContext.this.initFile();
                    this.ce.reset();
                }

                public Component previous() {
                    if (this.ce.hasPrevious()) {
                        return this.ce.previous();
                    }
                    return null;
                }
            };
        }
        return new ComponentEnumerator(){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }

            public Component next() {
                return null;
            }

            public Component previous() {
                return null;
            }

            public void reset() {
            }
        };
    }

    private ComponentEnumerator getFICChildrenEnumerator() {
        return this.getChildrenEnumerator();
    }

    private DataTracer[] getDataTracers() {
        return this.dataTracers;
    }

    public long getNumberOfIterations() {
        return 1L;
    }

    public String getTraceMark() {
        return Integer.toString(this.counter_);
    }
}

