/*
 * Decompiled with CFR 0.152.
 */
package jams.components.conditional;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="CalendarConditionalContext", author="Sven Kralisch", date="2016-12-05", description="This component represents a JAMS context which can be used to conditionally execute components. This context must contain two components. If \"time\" matches \"timePattern\", the first one will be executed, otherwise the second one.", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_1", date="2015-02-18", comment="Fixed minor issue with wrong counting of run() invocations")})
public class CalendarConditionalContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calendar value")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calendar pattern to be matched against")
    public Attribute.String timePattern;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian day pattern to be matched against")
    public Attribute.String julDayPattern;

    public ComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    public long getNumberOfIterations() {
        return -1L;
    }

    public long getRunCount() {
        return -1L;
    }

    public static void main(String[] args) {
        String time = "2000-10-10 07:30";
        String pattern = "^.*-1[0-2]-.*";
        System.out.println(time.matches(pattern));
    }

    static /* synthetic */ Component[] access$000(CalendarConditionalContext x0) {
        return x0.getCompArray();
    }

    public class RunEnumerator
    implements ComponentEnumerator {
        final JAMSComponent dummy = new JAMSComponent(){

            public void run() {
            }
        };
        Component[] compArray = CalendarConditionalContext.access$000(CalendarConditionalContext.this);
        boolean next = true;

        public boolean hasNext() {
            if (this.next) {
                this.next = false;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.hasNext();
        }

        public Component next() {
            CalendarConditionalContext.this.runCount++;
            boolean b = CalendarConditionalContext.this.julDayPattern != null ? Integer.toString(CalendarConditionalContext.this.time.get(6)).matches(CalendarConditionalContext.this.julDayPattern.getValue()) : CalendarConditionalContext.this.time.toString().matches(CalendarConditionalContext.this.timePattern.getValue());
            if (b) {
                return this.compArray[0];
            }
            if (this.compArray.length < 2 || this.compArray[1] == null) {
                return this.dummy;
            }
            return this.compArray[1];
        }

        public Component previous() {
            return this.next();
        }

        public void reset() {
            this.next = true;
        }
    }
}

