/*
 * Decompiled with CFR 0.152.
 */
package jams.components.concurrency;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@JAMSComponentDescription(title="EntityPartitioner", author="Sven Kralisch", description="Creates a partitioning of entities in an entity collection in such a way that entities within one partition are not interdependent. The maximum number of partitions can be configured by a component attribute.", date="2013-07-04", version="1.1_0")
public class EntityPartitioner
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Input entity collection")
    public Attribute.EntityCollection inEntities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Resulting entity collections, length of this array defines the number of partitions")
    public Attribute.EntityCollection[] outEntities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly")
    public Attribute.String associationAttribute;
    private HashMap<Attribute.Entity, List<Attribute.Entity>> linkMap = new HashMap();

    public void init() {
        ArrayList<Attribute.Entity>[] listArray;
        if (this.associationAttribute.getValue().equals("")) {
            listArray = this.distributeEntities(this.outEntities.length);
        } else {
            ArrayList<ArrayList<Attribute.Entity>> alList = this.createDepthPartitioning(this.inEntities, this.associationAttribute.getValue());
            listArray = this.distributeEntities(alList, this.outEntities.length);
        }
        this.getModel().getRuntime().println("");
        this.getModel().getRuntime().println("Partitioning of " + this.inEntities.getValue().size() + " entities resulted in " + listArray.length + " partitions:");
        for (int i = 0; i < this.outEntities.length; ++i) {
            this.getModel().getRuntime().println(String.format("    partition %02d: %d entities", i, listArray[i].size()));
            this.outEntities[i].setValue(listArray[i]);
        }
        this.getModel().getRuntime().println("");
    }

    protected ArrayList<ArrayList<Attribute.Entity>> createDepthPartitioning(Attribute.EntityCollection col, String asso) {
        Attribute.Entity f;
        ArrayList<ArrayList<Attribute.Entity>> alList = new ArrayList<ArrayList<Attribute.Entity>>();
        for (Attribute.Entity e : col.getEntities()) {
            try {
                f = (Attribute.Entity)e.getObject(asso);
                List<Attribute.Entity> linkList = this.linkMap.get(f);
                if (linkList == null) {
                    linkList = new ArrayList<Attribute.Entity>();
                    this.linkMap.put(f, linkList);
                }
                linkList.add(e);
            }
            catch (Attribute.Entity.NoSuchAttributeException ex) {
                this.getModel().getRuntime().sendErrorMsg("Component attribute " + asso + " is not exising in entity " + e.getId() + "!");
            }
        }
        for (Attribute.Entity e : col.getEntities()) {
            try {
                f = (Attribute.Entity)e.getObject(asso);
                if (!f.isEmpty()) continue;
                alList.add(this.listSubTree(e));
            }
            catch (Attribute.Entity.NoSuchAttributeException ex) {
                this.getModel().getRuntime().sendErrorMsg("Component attribute " + asso + " is not exising in entity " + e.getId() + "!");
            }
        }
        Collections.sort(alList, new Comparator<ArrayList<Attribute.Entity>>(){

            @Override
            public int compare(ArrayList<Attribute.Entity> o1, ArrayList<Attribute.Entity> o2) {
                return o1.size() - o2.size();
            }
        });
        return alList;
    }

    private ArrayList<Attribute.Entity>[] distributeEntities(int numberOfLists) {
        int i;
        ArrayList[] listArray = new ArrayList[numberOfLists];
        for (i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        i = 0;
        for (Attribute.Entity e : this.inEntities.getEntities()) {
            listArray[i % numberOfLists].add(e);
            ++i;
        }
        return listArray;
    }

    private ArrayList<Attribute.Entity>[] distributeEntities(ArrayList<ArrayList<Attribute.Entity>> alList, int numberOfLists) {
        ArrayList[] listArray = new ArrayList[numberOfLists];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        while (alList.size() > 0) {
            int sum = 0;
            for (ArrayList list : listArray) {
                sum += list.size();
            }
            double avgSize = sum / listArray.length;
            for (ArrayList list : listArray) {
                while ((double)list.size() <= avgSize && alList.size() > 0) {
                    ArrayList<Attribute.Entity> largestList = alList.remove(alList.size() - 1);
                    list.addAll(largestList);
                }
            }
        }
        return listArray;
    }

    private ArrayList<Attribute.Entity> listSubTree(Attribute.Entity root) {
        ArrayList<Attribute.Entity> list = new ArrayList<Attribute.Entity>();
        List<Attribute.Entity> children = this.linkMap.get(root);
        if (children != null) {
            for (Attribute.Entity child : children) {
                list.addAll(this.listSubTree(child));
            }
        }
        list.add(root);
        return list;
    }

    protected ArrayList<ArrayList<Attribute.Entity>> createBreadthPartitioning(Attribute.EntityCollection col, String asso) {
        HashMap<Attribute.Entity, Integer> depthMap = new HashMap<Attribute.Entity, Integer>();
        boolean mapChanged = true;
        for (Object e : col.getEntities()) {
            depthMap.put((Attribute.Entity)e, new Integer(0));
        }
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e : col.getEntities()) {
                try {
                    Attribute.Entity f = (Attribute.Entity)e.getObject(asso);
                    if (f == null || !f.isEmpty()) continue;
                    Integer eDepth = (Integer)depthMap.get(e);
                    Integer fDepth = (Integer)depthMap.get(f);
                    if (fDepth > eDepth) continue;
                    depthMap.put(f, eDepth + 1);
                    mapChanged = true;
                }
                catch (Attribute.Entity.NoSuchAttributeException ex) {
                    this.getModel().getRuntime().sendErrorMsg("Component attribute " + asso + " is not exising!");
                }
            }
        }
        int maxDepth = 0;
        for (Attribute.Entity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList<ArrayList<Attribute.Entity>> alList = new ArrayList<ArrayList<Attribute.Entity>>();
        for (int i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            alList.get(depth).add(e);
        }
        return alList;
    }
}

