/*
 * Decompiled with CFR 0.152.
 */
package jams.components.calc;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Double_transition", author="Manfred Fink", description="Transfers linear double values according to a multiplyer or a summand and a transition intervall and one independent variable", date="2018-10-09", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Double_transition
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Values to be transfered (M_S, range and Para_trans must have the same number of entries)")
    public Attribute.Double[] Para;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Multiplier or sumand depending on Add_or_mult")
    public Attribute.Double[] M_S;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intervall range")
    public Attribute.Double[] range;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intended denter of control parameter")
    public Attribute.Double independet_pos;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="control parameter")
    public Attribute.Double independet_var;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intervall range around the control parameter")
    public Attribute.Double trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="indicattes if transition is an addition (0) or a multiplication (1)", defaultValue="1")
    public Attribute.Double Add_or_mult;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Values that are transfered ")
    public Attribute.Double[] Para_trans;

    public void init() {
    }

    public void run() {
        int i = this.Para.length;
        if (i == this.range.length && i == this.Para_trans.length && i == this.M_S.length) {
            double start = this.independet_pos.getValue() - this.trans.getValue() / 2.0;
            double end = this.independet_pos.getValue() + this.trans.getValue() / 2.0;
            double relpos = this.independet_var.getValue() <= end ? (this.independet_var.getValue() >= start ? (this.independet_var.getValue() - start) / this.trans.getValue() : 0.0) : 1.0;
            --i;
            while (i >= 0) {
                double result = 0.0;
                if (this.Add_or_mult.getValue() == 1.0) {
                    result = this.Para[i].getValue() * (this.M_S[i].getValue() + this.range[i].getValue() * relpos);
                } else if (this.Add_or_mult.getValue() == 0.0) {
                    result = this.Para[i].getValue() + (this.M_S[i].getValue() + this.range[i].getValue() * relpos);
                } else {
                    this.getModel().getRuntime().println("Variable Add_or_mult has not a defined value (must be 0 or 1 ) - HALT", 1);
                    this.getModel().getRuntime().sendHalt();
                }
                this.Para_trans[i].setValue(result);
                --i;
            }
        } else {
            this.getModel().getRuntime().println("Variable numbers are not equal for the different input variables - HALT", 1);
            this.getModel().getRuntime().sendHalt();
        }
    }
}

