/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g.lowmem;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.util.Arrays;

public class Regionalisation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="use only pidw stations for elevation correction", defaultValue="false")
    public Attribute.Boolean localElevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station elevations")
    public Attribute.DoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station elevations")
    public Attribute.DoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station elevations")
    public Attribute.DoubleArray statElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of station's weights")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array position of weights")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regionalised data value")
    public Attribute.Double dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name elevation")
    public Attribute.Double entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of IDW stations", defaultValue="3")
    public Attribute.Integer nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply elevation correction to measured data")
    public Attribute.Boolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Minimum r\u00b2 value for elevation correction application")
    public Attribute.Double rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="-Infinity")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="Infinity")
    public Attribute.Double fixedMaximum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Power of IDW function")
    public Attribute.Double pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculation with geographical coordinates lat, long", defaultValue="false")
    public Attribute.Boolean latLong;
    Projection proj = null;
    private double[] data;
    private double[] elev;
    private double[] weights;
    private double[] dist;
    int n = 0;
    int nIDW = 0;
    double pIDW = 0.0;
    boolean invalidDatasetReported = false;

    public void init() {
        boolean isLatLon = this.latLong != null && this.latLong.getValue();
        this.proj = isLatLon ? Projection.LATLON : Projection.ANY;
        this.n = this.statX.getValue().length;
        this.nIDW = Math.min(this.nidw.getValue(), this.statX.getValue().length);
        this.pIDW = this.pidw.getValue();
        this.dist = new double[this.n];
        this.data = new double[this.nIDW];
        this.elev = new double[this.nIDW];
        this.weights = new double[this.nIDW];
    }

    private double rad(double decDeg) {
        return decDeg * Math.PI / 180.0;
    }

    public void calcDistances(double entityX, double entityY, double[] statX, double[] statY, double pidw) {
        double R = 6378137.0;
        if (this.proj == Projection.ANY) {
            for (int s = 0; s < statX.length; ++s) {
                double x = entityX - statX[s];
                double y = entityY - statY[s];
                this.dist[s] = x * x + y * y;
                if (pidw == 2.0) continue;
                this.dist[s] = Math.pow(this.dist[s], pidw / 2.0);
            }
        } else {
            for (int s = 0; s < statX.length; ++s) {
                this.dist[s] = 6378137.0 * Math.acos(Math.sin(this.rad(entityY)) * Math.sin(this.rad(statY[s])) + Math.cos(this.rad(entityY)) * Math.cos(this.rad(statY[s])) * Math.cos(this.rad(statX[s]) - this.rad(entityX)));
                this.dist[s] = Math.abs(Math.pow(this.dist[s], pidw));
            }
        }
    }

    private int minIndex(double[] v) {
        double min = Double.POSITIVE_INFINITY;
        int p = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] < min)) continue;
            min = v[i];
            p = i;
        }
        return p;
    }

    public void initAll() {
        int i;
        double[] weights = this.statWeights.getValue();
        int[] wA = this.statOrder.getValue();
        double distsum = 0.0;
        if (weights == null || weights.length != this.n) {
            weights = new double[this.nIDW];
        }
        if (wA == null || wA.length != this.nIDW) {
            wA = new int[this.nIDW];
        }
        this.calcDistances(this.entityX.getValue(), this.entityY.getValue(), this.statX.getValue(), this.statY.getValue(), this.pidw.getValue());
        for (int p = 0; p < this.nIDW; ++p) {
            int min = this.minIndex(this.dist);
            weights[p] = this.dist[min];
            wA[p] = min;
            if (this.dist[min] == 0.0) {
                Arrays.fill(weights, 0.0);
                Arrays.fill(wA, 0);
                wA[p] = min;
                weights[p] = 1.0;
                break;
            }
            this.dist[min] = Double.MAX_VALUE;
        }
        for (i = 0; i < this.nIDW; ++i) {
            distsum += weights[i];
        }
        for (i = 0; i < this.nIDW; ++i) {
            if (weights[i] == 0.0) continue;
            weights[i] = distsum / weights[i];
        }
        this.statWeights.setValue(weights);
        this.statOrder.setValue(wA);
        this.calcDistances(this.entityX.getValue(), this.entityY.getValue(), this.statX.getValue(), this.statY.getValue(), this.pidw.getValue());
    }

    public void run() {
        double[] regCoeff = this.regCoeff.getValue();
        double gradient = regCoeff[1];
        double rsq = regCoeff[2];
        double[] sourceElevations = this.statElevation.getValue();
        double[] sourceData = this.dataArray.getValue();
        double[] sourceWeights = this.statWeights.getValue();
        double targetElevation = this.entityElevation.getValue();
        int[] wA = this.statOrder.getValue();
        double value = 0.0;
        double deltaElev = 0.0;
        if (this.localElevationCorrection.getValue()) {
            int element;
            double xq = 0.0;
            double yq = 0.0;
            int counter = 0;
            for (element = 0; element < this.nIDW; ++element) {
                int t = wA[element];
                if (sourceData[t] == JAMS.getMissingDataValue()) continue;
                xq += sourceElevations[t];
                yq += sourceData[t];
                ++counter;
            }
            xq /= (double)counter;
            yq /= (double)counter;
            double covxy = 0.0;
            double covx = 0.0;
            double covy = 0.0;
            for (element = 0; element < this.nIDW; ++element) {
                int t = wA[element];
                if (sourceData[t] == JAMS.getMissingDataValue()) continue;
                double p = sourceElevations[t] - xq;
                double q = sourceData[t] - yq;
                covxy += p * q;
                covx += p * p;
                covy += q * q;
            }
            gradient = covxy / covx;
            rsq = covx == 0.0 || covy == 0.0 ? 0.0 : covxy * covxy / (covx * covy);
        }
        Arrays.fill(this.data, 0.0);
        Arrays.fill(this.weights, 0.0);
        Arrays.fill(this.elev, 0.0);
        int counter = 0;
        int element = 0;
        boolean valid = false;
        double weightsum = 0.0;
        while (counter < this.nIDW) {
            int t = wA[element];
            if (sourceData[t] == JAMS.getMissingDataValue()) {
                if (++element < wA.length) continue;
                break;
            }
            valid = true;
            this.data[counter] = sourceData[t];
            this.weights[counter] = sourceWeights[element];
            this.elev[counter] = sourceElevations[t];
            weightsum += this.weights[counter];
            ++counter;
            if (++element < wA.length) continue;
            break;
        }
        if (valid) {
            for (int i = 0; i < counter; ++i) {
                int n = i;
                this.weights[n] = this.weights[n] / weightsum;
                if (rsq >= this.rsqThreshold.getValue() && this.elevationCorrection.getValue()) {
                    deltaElev = targetElevation - this.elev[i];
                    double tVal = (deltaElev * gradient + this.data[i]) * this.weights[i];
                    value += tVal;
                    continue;
                }
                value += this.data[i] * this.weights[i];
            }
        } else {
            if (!this.invalidDatasetReported) {
                this.getModel().getRuntime().sendHalt("Invalid dataset found while regionalizing data in component " + this.getInstanceName() + ".\nThis might occur if all of the provided values are missing data values.");
                this.invalidDatasetReported = true;
            }
            value = JAMS.getMissingDataValue();
        }
        value = Math.max(this.fixedMinimum.getValue(), value);
        value = Math.min(this.fixedMaximum.getValue(), value);
        this.dataValue.setValue(value);
    }

    public static void main(String[] args) {
        Regionalisation reg = new Regionalisation();
        reg.dataValue = JAMSDataFactory.createDouble();
        reg.elevationCorrection = JAMSDataFactory.createBoolean();
        reg.entityElevation = JAMSDataFactory.createDouble();
        reg.entityX = JAMSDataFactory.createDouble();
        reg.entityY = JAMSDataFactory.createDouble();
        reg.fixedMaximum = JAMSDataFactory.createDouble();
        reg.fixedMinimum = JAMSDataFactory.createDouble();
        reg.latLong = JAMSDataFactory.createBoolean();
        reg.nidw = JAMSDataFactory.createInteger();
        reg.pidw = JAMSDataFactory.createDouble();
        reg.rsqThreshold = JAMSDataFactory.createDouble();
        reg.regCoeff = JAMSDataFactory.createDoubleArray();
        reg.statElevation = JAMSDataFactory.createDoubleArray();
        reg.statOrder = JAMSDataFactory.createIntegerArray();
        reg.statWeights = JAMSDataFactory.createDoubleArray();
        reg.statX = JAMSDataFactory.createDoubleArray();
        reg.statY = JAMSDataFactory.createDoubleArray();
        reg.dataArray = JAMSDataFactory.createDoubleArray();
        reg.elevationCorrection.setValue(true);
        reg.fixedMinimum.setValue(-999999.0);
        reg.fixedMaximum.setValue(999999.0);
        reg.pidw.setValue(2.0);
        reg.nidw.setValue(4);
        reg.latLong.setValue(false);
        reg.statElevation.setValue(new double[]{100.0, 200.0, 300.0, 400.0});
        reg.statX.setValue(new double[]{0.0, 0.0, 1.0, 1.0});
        reg.statY.setValue(new double[]{0.0, 1.0, 0.0, 1.0});
        reg.regCoeff.setValue(new double[3]);
        reg.rsqThreshold.setValue(-1.0);
        reg.init();
        double[] entityX = new double[]{0.5, 0.0, 1.0, 0.0, 1.0, 0.25, 0.5, 0.75, 0.25, 0.5};
        double[] entityY = new double[]{0.5, 1.0, 0.0, 0.0, 1.0, 0.25, 0.25, 0.25, 0.75, 0.75};
        double[] entityElevation = new double[]{100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0};
        double[][] dataArray = new double[][]{{1.0, 2.0, 1.0, 2.0}, {2.0, 3.0, 4.0, 5.0}, {0.0, 0.0, 0.0, 1.0}, {2.0, 0.0, 0.0, 0.0}, {4.0, 2.0, 1.0, 0.0}, {5.0, 5.0, 5.0, 5.0}, {1.0, 2.0, 1.0, 2.0}, {0.0, 0.0, 0.0, 0.0}};
        for (int i = 0; i < 10; ++i) {
            System.out.println("Entity " + i);
            reg.entityX.setValue(entityX[i]);
            reg.entityY.setValue(entityY[i]);
            reg.entityElevation.setValue(entityElevation[i]);
            reg.initAll();
            System.out.println(Arrays.toString(reg.statOrder.getValue()));
            System.out.println(Arrays.toString(reg.statWeights.getValue()));
            for (int j = 0; j < 8; ++j) {
                reg.dataArray.setValue(dataArray[j]);
                reg.run();
                System.out.println("Timestep: " + j + "->" + reg.dataValue.getValue());
            }
        }
    }

    public static enum Projection {
        LATLON,
        ANY;

    }
}

