/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class TSDataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Data file name")
    public Attribute.String dataFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Data file directory name")
    public Attribute.String dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Column of first data value")
    public Attribute.Integer startColumn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of current temporal context")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of data values for current time step", defaultValue="")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="data set descriptor", defaultValue="")
    public Attribute.String dataSetName;
    private JAMSTableDataStore store;
    private JAMSTableDataArray da;

    public void init() {
        int headerLineCount = 0;
        String dataName = null;
        Object tres = null;
        String start = null;
        String end = null;
        String fileName = this.dirName.getValue() + "/" + this.dataFileName.getValue();
        String line = "#";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while (line.charAt(0) == '#') {
                line = reader.readLine();
                ++headerLineCount;
            }
            StringTokenizer tok = new StringTokenizer(line, "\t");
            start = tok.nextToken();
            String lastLine = null;
            while (line.charAt(0) != '#') {
                lastLine = line;
                line = reader.readLine();
            }
            tok = new StringTokenizer(lastLine, "\t");
            end = tok.nextToken();
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        this.store = new GenericDataReader(this.dirName.getValue() + "/" + this.dataFileName.getValue(), false, headerLineCount);
        Attribute.Calendar startTime = this.parseJ2KTime(start);
        Attribute.Calendar endTime = this.parseJ2KTime(end);
        if (this.timeInterval != null && (this.timeInterval.getStart().before(startTime) || this.timeInterval.getEnd().after(endTime))) {
            this.getModel().getRuntime().sendHalt("TSData start and end time of " + this.dataFileName.getValue() + " do not match current temporal context!");
        }
        this.dataSetName.setValue(dataName);
        if (this.timeInterval != null) {
            int timeUnit = this.timeInterval.getTimeUnit();
            Attribute.Calendar tiStart = this.timeInterval.getStart();
            Attribute.Calendar date = this.getModel().getRuntime().getDataFactory().createCalendar();
            if (timeUnit == 6) {
                date.set(tiStart.get(1), tiStart.get(2), tiStart.get(5), 0, 0, 0);
            } else if (timeUnit == 11) {
                date.set(tiStart.get(1), tiStart.get(2), tiStart.get(5), tiStart.get(11), tiStart.get(12), 0);
            } else if (timeUnit == 2) {
                date.set(tiStart.get(1), tiStart.get(2), 1, 0, 0, 0);
            }
            while (startTime.before(date) && this.store.hasNext()) {
                this.da = this.store.getNext();
                if (timeUnit == 6) {
                    startTime.add(5, 1);
                    continue;
                }
                if (timeUnit == 11) {
                    startTime.add(11, 1);
                    continue;
                }
                if (timeUnit != 2) continue;
                startTime.add(2, 1);
            }
        }
        this.getModel().getRuntime().println(this.dataSetName.getValue() + " data file initalised ... ", 2);
    }

    public void run() {
        this.dataArray.setValue(JAMSTableDataConverter.toDouble((JAMSTableDataArray)this.store.getNext(), (int)this.startColumn.getValue()));
    }

    private Attribute.Calendar parseJ2KTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0", "0", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        Attribute.Calendar cal = this.getModel().getRuntime().getDataFactory().createCalendar();
        cal.setValue(timeArray[2] + "-" + timeArray[1] + "-" + timeArray[0] + " " + timeArray[3] + ":" + timeArray[4]);
        return cal;
    }

    public void cleanup() {
        this.store.close();
    }
}

