/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="SoilWaterBalance", author="Peter Krause", description="Calculates a simplified soil water balance for each HRU")
public class SoilWaterGen
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum MPS")
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var actual MPS")
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var relative saturation of MPS")
    public Attribute.Double satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="surface runoff")
    public Attribute.Double surfaceQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="subsurface runoff")
    public Attribute.Double subsurfaceQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="groundwater recharge")
    public Attribute.Double gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total runoff")
    public Attribute.Double totQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="potential ET")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual ET")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precipitation")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lateral-vertical distribution coefficient")
    public Attribute.Double latVertDist;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ET reduction factor")
    public Attribute.Double linETRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum percolation")
    public Attribute.Double maxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="direct runoff coefficient beta")
    public Attribute.Double df_beta;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="direct runoff coefficient a")
    public Attribute.Double df_a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="pet multiplier")
    public Attribute.Double mPET;

    public void init() {
    }

    public void run() {
        double balMPSend;
        double balFlows;
        double totBal;
        double actMPS = this.actMPS.getValue();
        double inflow = this.precip.getValue() + this.snowMelt.getValue();
        double maxMPS = this.maxMPS.getValue();
        double balIn = inflow;
        double balMPSstart = actMPS;
        double actET = this.actET.getValue();
        double potET = this.potET.getValue() * this.mPET.getValue();
        this.potET.setValue(potET);
        double deltaET = potET - actET;
        if (inflow >= deltaET) {
            actET = potET;
            inflow -= deltaET;
            deltaET = 0.0;
        } else {
            actET += inflow;
            inflow = 0.0;
            deltaET = potET - actET;
        }
        double linRed = this.linETRed.getValue();
        double reduceET = 1.0;
        if (actMPS < linRed * maxMPS) {
            reduceET = maxMPS == 0.0 ? 0.0 : actMPS / (linRed * maxMPS);
        }
        if (actMPS >= (deltaET *= reduceET)) {
            actET += deltaET;
            actMPS -= deltaET;
            deltaET = 0.0;
        } else {
            actET += actMPS;
            actMPS = 0.0;
        }
        double balET = actET;
        double directFlow = 0.0;
        double ifbf = 0.0;
        double fact = 0.0;
        if (this.df_beta.getValue() != 0.0) {
            double sat = 0.0;
            if (maxMPS > 0.0) {
                sat = actMPS / maxMPS;
            }
            double b = this.df_beta.getValue();
            double a = this.df_a.getValue();
            fact = a * Math.pow(sat, b);
            if (fact < 0.0) {
                fact = 0.0;
            }
            directFlow = fact * inflow;
            inflow -= directFlow;
        }
        double deltaMPS = maxMPS - actMPS;
        deltaMPS = maxMPS - actMPS;
        if (inflow <= deltaMPS) {
            actMPS += inflow;
            inflow = 0.0;
        } else {
            actMPS = maxMPS;
            inflow -= deltaMPS;
        }
        double interflow = 0.0;
        double gwRecharge = 0.0;
        double slope_weight = Math.tan(this.slope.getValue() * (Math.PI / 180)) * this.latVertDist.getValue();
        if (slope_weight > 1.0) {
            slope_weight = 1.0;
        }
        interflow = inflow * slope_weight;
        gwRecharge = inflow * (1.0 - slope_weight);
        inflow = 0.0;
        if (gwRecharge > this.maxPerc.getValue()) {
            double delta = gwRecharge - this.maxPerc.getValue();
            interflow += delta;
            gwRecharge = this.maxPerc.getValue();
        }
        if (Math.abs(totBal = balIn - balET - (balFlows = directFlow + interflow + gwRecharge) + (balMPSstart - (balMPSend = actMPS))) > 0.001) {
            System.out.println("Balance error: " + totBal);
        }
        double sat = 0.0;
        if (maxMPS > 0.0) {
            sat = actMPS / maxMPS;
        }
        this.actET.setValue(actET);
        this.actMPS.setValue(actMPS);
        this.satMPS.setValue(sat);
        this.surfaceQ.setValue(directFlow);
        this.subsurfaceQ.setValue(interflow);
        this.gwRecharge.setValue(gwRecharge);
        this.totQ.setValue(directFlow + interflow + gwRecharge);
    }

    public void cleanup() {
    }
}

